/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;

public abstract class FileAndFileObjectFilter
extends FileFilterFactory.AbstractFileAndFileObjectFilter {
    @Override
    public final boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            if (this.accept(f.getName())) {
                return true;
            }
            return this.mimeAccept(f);
        }
        return false;
    }

    protected boolean mimeAccept(File f) {
        return false;
    }

    @Override
    public final boolean accept(FileObject f) {
        if (f != null) {
            if (f.isFolder()) {
                return true;
            }
            if (this.accept(f.getNameExt())) {
                return true;
            }
            return this.mimeAccept(f);
        }
        return false;
    }

    protected boolean mimeAccept(FileObject f) {
        return false;
    }

    protected final boolean accept(String fileName) {
        String suffix;
        int index = fileName.lastIndexOf(46);
        return index >= 0 ? this.amongSuffixes(suffix = fileName.substring(index + 1), this.getSuffixes()) : this.amongSuffixes(fileName, this.getSuffixes());
    }

    protected abstract String[] getSuffixes();

    @Override
    public String getSuffixesAsString() {
        String[] suffixes = this.getSuffixes();
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < suffixes.length; ++i) {
            if (0 < i) {
                ret.append(' ');
            }
            ret.append('.').append(suffixes[i]);
        }
        return ret.toString();
    }

    private boolean amongSuffixes(String suffix, String[] suffixes) {
        for (int i = 0; i < suffixes.length; ++i) {
            if (!this.areFilenamesEqual(suffixes[i], suffix)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getDescription();
    }

    protected boolean areFilenamesEqual(String firstFile, String secondFile) {
        return CndFileUtils.isSystemCaseSensitive() ? firstFile.equals(secondFile) : firstFile.equalsIgnoreCase(secondFile);
    }
}

