/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.filters.FileAndFileObjectFilter;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ElfExecutableFileFilter
extends FileAndFileObjectFilter {
    private static ElfExecutableFileFilter instance = null;

    public static ElfExecutableFileFilter getInstance() {
        if (instance == null) {
            instance = new ElfExecutableFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(ElfExecutableFileFilter.class, (String)"FILECHOOSER_ELFEXECUTABLE_FILEFILTER");
    }

    @Override
    protected boolean mimeAccept(File f) {
        FileObject fo = CndFileSystemProvider.toFileObject(f);
        return fo == null ? this.checkElfHeader(f) : this.checkElfHeader(fo);
    }

    @Override
    protected boolean mimeAccept(FileObject f) {
        return this.checkElfHeader(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkElfHeader(Object f) {
        short e_type;
        CndUtils.assertTrue(f instanceof File || f instanceof FileObject);
        byte[] b = new byte[18];
        int offset = 0;
        InputStream is = null;
        try {
            int n;
            is = f instanceof File ? new FileInputStream((File)f) : ((FileObject)f).getInputStream();
            for (int left = 18; left > 0; left -= n) {
                n = is.read(b, offset, left);
                if (n <= 0) {
                    boolean bl = false;
                    return bl;
                }
                offset += n;
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        if (b[5] == 1) {
            e_type = b[17];
            e_type = (short)(e_type << 8);
            e_type = (short)(e_type + (short)b[16]);
        } else {
            e_type = b[16];
            e_type = (short)(e_type << 8);
            e_type = (short)(e_type + (short)b[17]);
        }
        return b[0] == 127 && b[1] == 69 && b[2] == 76 && b[3] == 70 && e_type == 2;
    }

    @Override
    protected String[] getSuffixes() {
        return new String[0];
    }
}

