/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.AbstractEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.openide.modules.Dependency;

abstract class AbstractBinaryEntry
extends AbstractEntry {
    private final String cnb;
    private final File jar;
    private final String cpext;
    private final File clusterDir;
    private final String releaseVersion;
    private final String specVersion;
    private final String[] providedTokens;
    private LocalizedBundleInfo bundleInfo;
    private final ManifestManager.PackageExport[] publicPackages;
    private final String[] friends;
    private final boolean deprecated;
    private final String[] runDependencies;
    private Set<String> allPackageNames;

    AbstractBinaryEntry(String cnb, File jar, File[] exts, File clusterDir, String releaseVersion, String specVersion, String[] providedTokens, ManifestManager.PackageExport[] publicPackages, String[] friends, boolean deprecated, Set<Dependency> moduleDependencies) {
        this.cnb = cnb;
        this.jar = jar;
        this.clusterDir = clusterDir;
        StringBuffer _cpext = new StringBuffer();
        for (int i = 0; i < exts.length; ++i) {
            _cpext.append(File.pathSeparatorChar);
            _cpext.append(exts[i].getAbsolutePath());
        }
        this.cpext = _cpext.toString();
        this.releaseVersion = releaseVersion;
        this.specVersion = specVersion;
        this.providedTokens = providedTokens;
        this.publicPackages = publicPackages;
        this.friends = friends;
        this.deprecated = deprecated;
        TreeSet<String> deps = new TreeSet<String>();
        for (Dependency d : moduleDependencies) {
            String codename = d.getName();
            int slash = codename.lastIndexOf(47);
            if (slash == -1) {
                deps.add(codename);
                continue;
            }
            deps.add(codename.substring(0, slash));
        }
        this.runDependencies = deps.toArray(new String[deps.size()]);
    }

    @Override
    public String getNetBeansOrgPath() {
        return null;
    }

    @Override
    public File getJarLocation() {
        return this.jar;
    }

    @Override
    public String getCodeNameBase() {
        return this.cnb;
    }

    @Override
    public File getClusterDirectory() {
        return this.clusterDir;
    }

    @Override
    public String getClassPathExtensions() {
        return this.cpext;
    }

    @Override
    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    @Override
    public String getSpecificationVersion() {
        return this.specVersion;
    }

    @Override
    public String[] getProvidedTokens() {
        return this.providedTokens;
    }

    @Override
    protected LocalizedBundleInfo getBundleInfo() {
        if (this.bundleInfo == null) {
            this.bundleInfo = Util.findLocalizedBundleInfoFromJAR(this.getJarLocation());
            if (this.bundleInfo == null) {
                this.bundleInfo = LocalizedBundleInfo.EMPTY;
            }
        }
        return this.bundleInfo;
    }

    @Override
    public ManifestManager.PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    @Override
    public synchronized Set<String> getAllPackageNames() {
        if (this.allPackageNames == null) {
            this.allPackageNames = new TreeSet<String>();
            Util.scanJarForPackageNames(this.allPackageNames, this.getJarLocation());
        }
        return this.allPackageNames;
    }

    @Override
    public boolean isDeclaredAsFriend(String cnb) {
        return AbstractBinaryEntry.isDeclaredAsFriend(this.friends, cnb);
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    protected Set<String> computePublicClassNamesInMainModule() throws IOException {
        HashSet<String> result = new HashSet<String>();
        this.scanJarForPublicClassNames(result, this.jar);
        return result;
    }

    @Override
    public String[] getRunDependencies() {
        return this.runDependencies;
    }
}

