/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.Image;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.layers.LayerFileSystem;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.layers.OpenLayerFilesAction;
import org.netbeans.modules.apisupport.project.layers.PickIconAction;
import org.netbeans.modules.apisupport.project.layers.PickNameAction;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;

public final class LayerNode
extends FilterNode
implements Node.Cookie {
    private static final RequestProcessor RP = new RequestProcessor(LayerNode.class);
    private final boolean specialDisplayName;

    public LayerNode(LayerHandle handle) {
        this(LayerNode.getDataNode(handle), handle, true);
    }

    LayerNode(Node delegate, LayerHandle handle, boolean specialDisplayName) {
        super(delegate, (Children)new LayerChildren(handle));
        this.specialDisplayName = specialDisplayName;
    }

    private static Node getDataNode(LayerHandle handle) {
        FileObject layer = handle.getLayerFile();
        try {
            return DataObject.find((FileObject)layer).getNodeDelegate();
        }
        catch (DataObjectNotFoundException e) {
            assert (false) : e;
            return Node.EMPTY;
        }
    }

    private static FileSystem badge(final FileSystem base, final FileObject layer, final String rootLabel, final FileSystem highlighted) {
        class BadgingMergedFileSystem
        extends LayerFileSystem {
            public BadgingMergedFileSystem() {
                super(new FileSystem[]{fileSystem});
                this.setPropagateMasks(true);
                this.status.addFileStatusListener(new FileStatusListener(){

                    public void annotationChanged(FileStatusEvent ev) {
                        this.fireFileStatusChanged(ev);
                    }
                });
                this.addFileChangeListener(new FileChangeListener(){

                    private void fire() {
                        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, true, true));
                    }

                    public void fileAttributeChanged(FileAttributeEvent fe) {
                        this.fire();
                    }

                    public void fileChanged(FileEvent fe) {
                        this.fire();
                    }

                    public void fileDataCreated(FileEvent fe) {
                        this.fire();
                    }

                    public void fileDeleted(FileEvent fe) {
                        this.fire();
                    }

                    public void fileFolderCreated(FileEvent fe) {
                        this.fire();
                    }

                    public void fileRenamed(FileRenameEvent fe) {
                        this.fire();
                    }
                });
            }

            @Override
            public FileSystem.Status getStatus() {
                return new FileSystem.HtmlStatus(){

                    public String annotateNameHtml(String name, Set<? extends FileObject> files) {
                        String htmlLabel;
                        String nonHtmlLabel = status.annotateName(name, files);
                        if (files.size() == 1 && files.iterator().next().isRoot()) {
                            nonHtmlLabel = rootLabel;
                        }
                        try {
                            htmlLabel = XMLUtil.toElementContent((String)nonHtmlLabel);
                        }
                        catch (CharConversionException e) {
                            Util.err.notify(1, (Throwable)e);
                            htmlLabel = nonHtmlLabel;
                        }
                        boolean deleted = false;
                        for (FileObject fileObject : files) {
                            if (!fileObject.getNameExt().endsWith("_hidden")) continue;
                            deleted = true;
                            break;
                        }
                        if (highlighted != null) {
                            boolean local = false;
                            for (FileObject fileObject : files) {
                                if (fileObject.isRoot() || highlighted.findResource(fileObject.getPath()) == null) continue;
                                local = true;
                                break;
                            }
                            if (local) {
                                htmlLabel = "<b>" + htmlLabel + "</b>";
                            }
                        }
                        if (deleted) {
                            htmlLabel = "<s>" + htmlLabel + "</s>";
                        }
                        return htmlLabel;
                    }

                    public String annotateName(String name, Set<? extends FileObject> files) {
                        return name;
                    }

                    public Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
                        return status.annotateIcon(icon, iconType, files);
                    }
                };
            }

            public String getDisplayName() {
                return FileUtil.getFileDisplayName((FileObject)layer);
            }

            public SystemAction[] getActions(Set<FileObject> foSet) {
                return new SystemAction[]{SystemAction.get(PickNameAction.class), SystemAction.get(PickIconAction.class), SystemAction.get(OpenLayerFilesAction.class)};
            }
        }
        return new BadgingMergedFileSystem();
    }

    public String getDisplayName() {
        if (this.specialDisplayName) {
            return NbBundle.getMessage(LayerNode.class, (String)"LayerNode_label");
        }
        return super.getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (this.specialDisplayName) {
            return null;
        }
        return this.getOriginal().getHtmlDisplayName();
    }

    private static final class LayerChildren
    extends Children.Keys<KeyType> {
        private final LayerHandle handle;
        private Project p;
        private FileSystem layerfs;
        private FileSystem sfs;

        public LayerChildren(LayerHandle handle) {
            this.handle = handle;
        }

        protected void addNotify() {
            super.addNotify();
            this.handle.setAutosave(true);
            this.setKeys(Collections.singleton(KeyType.WAIT));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileObject layer = LayerChildren.this.handle.getLayerFile();
                    LayerChildren.this.p = layer == null ? null : FileOwnerQuery.getOwner((FileObject)layer);
                    if (LayerChildren.this.p == null) {
                        LayerChildren.this.setKeys(Collections.emptySet());
                        return;
                    }
                    boolean showContextNode = true;
                    NbModuleProvider moduleProvider = (NbModuleProvider)LayerChildren.this.p.getLookup().lookup(NbModuleProvider.class);
                    if (null != moduleProvider && !moduleProvider.prepareContext(NbBundle.getMessage(LayerNode.class, (String)"LBL_XML_layer_in_context"))) {
                        showContextNode = false;
                    }
                    final boolean b = showContextNode;
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            LayerChildren.this.initialize(b);
                        }
                    });
                }
            });
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.p = null;
            this.layerfs = null;
            this.sfs = null;
            super.removeNotify();
        }

        protected Node[] createNodes(KeyType key) {
            try {
                switch (key) {
                    case RAW: {
                        FileSystem fs = LayerNode.badge(this.layerfs, this.handle.getLayerFile(), NbBundle.getMessage(LayerNode.class, (String)"LBL_this_layer"), null);
                        return new Node[]{DataObject.find((FileObject)fs.getRoot()).getNodeDelegate()};
                    }
                    case CONTEXTUALIZED: {
                        FileSystem fs = LayerNode.badge(this.sfs, this.handle.getLayerFile(), NbBundle.getMessage(LayerNode.class, (String)"LBL_this_layer_in_context"), this.handle.layer(false));
                        return new Node[]{DataObject.find((FileObject)fs.getRoot()).getNodeDelegate()};
                    }
                    case WAIT: {
                        return new Node[]{new AbstractNode(FilterNode.Children.LEAF){

                            public String getDisplayName() {
                                return NbBundle.getMessage(LayerNode.class, (String)"LayerNode_please_wait");
                            }
                        }};
                    }
                }
                throw new AssertionError((Object)key);
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
                return new Node[0];
            }
        }

        private void initialize(boolean showContextNode) {
            try {
                FileObject layer = this.handle.getLayerFile();
                Project prj = FileOwnerQuery.getOwner((FileObject)layer);
                if (prj == null) {
                    this.setKeys(Collections.emptySet());
                    return;
                }
                this.p = prj;
                this.layerfs = this.handle.layer(false);
                if (!showContextNode) {
                    this.setKeys(Collections.singleton(KeyType.RAW));
                } else {
                    this.setKeys(Arrays.asList(KeyType.RAW, KeyType.WAIT));
                    Project project = FileOwnerQuery.getOwner((FileObject)this.handle.getLayerFile());
                    boolean context = false;
                    if (project != null) {
                        LayerHandle h = LayerHandle.forProject(project);
                        h.setAutosave(true);
                        if (layer.equals(h.getLayerFile())) {
                            this.sfs = LayerUtils.getEffectiveSystemFilesystem(project);
                            this.setKeys(Arrays.asList(KeyType.RAW, KeyType.CONTEXTUALIZED));
                            context = true;
                        }
                    }
                    if (!context) {
                        this.setKeys(Collections.singleton(KeyType.RAW));
                    }
                }
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }

        static enum KeyType {
            WAIT,
            RAW,
            CONTEXTUALIZED;

        }
    }
}

