/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.maven.TextValueCompleter;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.ActionMappings;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.execute.NbGlobalActionGoalProvider;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.options.GlobalOptionsPanel;
import org.netbeans.modules.maven.options.MavenOptionController;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.options.MyJTextField;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SettingsPanel
extends JPanel {
    private static final String CP_SELECTED = "wasSelected";
    private static final String SEPARATOR = "SEPARATOR";
    private static final String BUNDLED_RUNTIME_VERSION = MavenSettings.getCommandLineMavenVersion(MavenSettings.getDefaultMavenHome());
    private static final int RUNTIME_COUNT_LIMIT = 5;
    private boolean changed;
    private boolean valid;
    private ActionListener listener;
    private DocumentListener docList;
    private MavenOptionController controller;
    private TextValueCompleter completer;
    private ActionListener listItemChangedListener;
    private List<String> userDefinedMavenRuntimes = new ArrayList<String>();
    private List<String> predefinedRuntimes = new ArrayList<String>();
    private DefaultComboBoxModel mavenHomeDataModel = new DefaultComboBoxModel();
    private String mavenRuntimeHome = null;
    private int lastSelected = -1;
    static String[] AVAILABLE_OPTIONS = new String[]{"--offline", "--debug", "--errors", "--batch-mode", "--fail-fast", "--fail-at-end", "--fail-never", "--strict-checksums", "--lax-checksums", "--check-plugin-updates", "--no-plugin-updates", "--update-snapshots", "--no-plugin-registry"};
    private ButtonGroup bgChecksums;
    private ButtonGroup bgFailure;
    private ButtonGroup bgPlugins;
    private JButton btnGoals;
    private JButton btnIndex;
    private JButton btnLocalRepository;
    private JButton btnOptions;
    private JCheckBox cbSkipTests;
    private JCheckBox cbSnapshots;
    private JComboBox comBinaries;
    private JComboBox comIndex;
    private JComboBox comJavadoc;
    private JComboBox comMavenHome;
    private JComboBox comSource;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel lblBinaries;
    private JLabel lblCommandLine;
    private JLabel lblExternalVersion;
    private JLabel lblIndex;
    private JLabel lblJavadoc;
    private JLabel lblLocalRepository;
    private JLabel lblOptions;
    private JLabel lblSource;
    private JTextField txtLocalRepository;
    private JTextField txtOptions;

    SettingsPanel(MavenOptionController controller) {
        this.initComponents();
        MavenSettings.DownloadStrategy[] downloads = MavenSettings.DownloadStrategy.values();
        this.comBinaries.setModel(new DefaultComboBoxModel<MavenSettings.DownloadStrategy>(downloads));
        this.comJavadoc.setModel(new DefaultComboBoxModel<MavenSettings.DownloadStrategy>(downloads));
        this.comSource.setModel(new DefaultComboBoxModel<MavenSettings.DownloadStrategy>(downloads));
        this.comMavenHome.setModel(this.mavenHomeDataModel);
        DefaultListCellRenderer rend = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String txt = "";
                if (value.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
                    txt = NbBundle.getMessage(SettingsPanel.class, (String)"TIT_NEVER");
                } else if (value.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
                    txt = NbBundle.getMessage(SettingsPanel.class, (String)"TIT_EVERY");
                } else if (value.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN)) {
                    txt = NbBundle.getMessage(SettingsPanel.class, (String)"TIT_FIRST");
                }
                return super.getListCellRendererComponent((JList<?>)list, txt, index, isSelected, cellHasFocus);
            }
        };
        this.comBinaries.setRenderer(rend);
        this.comSource.setRenderer(rend);
        this.comJavadoc.setRenderer(rend);
        this.comMavenHome.setRenderer(new ComboBoxRenderer());
        this.controller = controller;
        this.listItemChangedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingsPanel.SEPARATOR.equals(SettingsPanel.this.comMavenHome.getSelectedItem())) {
                    SettingsPanel.this.comMavenHome.setSelectedIndex(SettingsPanel.this.lastSelected);
                    return;
                }
                int selected = SettingsPanel.this.comMavenHome.getSelectedIndex();
                if (selected == SettingsPanel.this.mavenHomeDataModel.getSize() - 1) {
                    SettingsPanel.this.comMavenHome.setSelectedIndex(SettingsPanel.this.lastSelected);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SettingsPanel.this.browseAddNewRuntime();
                        }
                    });
                    return;
                }
                SettingsPanel.this.listDataChanged();
                SettingsPanel.this.lastSelected = selected;
            }
        };
        this.initValues();
        ((MyJTextField)this.txtLocalRepository).setHintText(NbBundle.getMessage(SettingsPanel.class, (String)"txt_default_repository"));
        this.listener = new ActionListenerImpl();
        this.cbSnapshots.addActionListener(this.listener);
        this.comIndex.addActionListener(this.listener);
        this.completer = new TextValueCompleter(SettingsPanel.getGlobalOptions(), this.txtOptions, " ");
    }

    static String[] getAvailableOptionsDescriptions() {
        return new String[]{NbBundle.getMessage(SettingsPanel.class, (String)"WORK_OFFLINE"), NbBundle.getMessage(SettingsPanel.class, (String)"PRODUCE_EXECUTION_DEBUG_OUTPUT"), NbBundle.getMessage(SettingsPanel.class, (String)"PRODUCE_EXECUTION_ERROR_MESSAGES"), NbBundle.getMessage(SettingsPanel.class, (String)"NON-INTERACTIVE_MODE."), NbBundle.getMessage(SettingsPanel.class, (String)"STOP_AT_FIRST_FAILURE"), NbBundle.getMessage(SettingsPanel.class, (String)"ONLY_FAIL_THE_BUILD_AFTERWARDS"), NbBundle.getMessage(SettingsPanel.class, (String)"NEVER_FAIL_THE_BUILD"), NbBundle.getMessage(SettingsPanel.class, (String)"FAIL_CHECKSUMS"), NbBundle.getMessage(SettingsPanel.class, (String)"WARN_CHECKSUMS"), NbBundle.getMessage(SettingsPanel.class, (String)"FORCE_UPTODATE_CHECK"), NbBundle.getMessage(SettingsPanel.class, (String)"SUPPRESS_UPTODATE_CHECK"), NbBundle.getMessage(SettingsPanel.class, (String)"FORCES_A_CHECK"), NbBundle.getMessage(SettingsPanel.class, (String)"DON'T_USE_PLUGIN-REGISTRY")};
    }

    private static List<String> getGlobalOptions() {
        return Arrays.asList(AVAILABLE_OPTIONS);
    }

    private void initValues() {
        this.comIndex.setSelectedIndex(0);
        this.cbSnapshots.setSelected(true);
    }

    private String getSelectedRuntime(int selected) {
        if (selected < 0) {
            return null;
        }
        if (selected < this.predefinedRuntimes.size()) {
            return this.predefinedRuntimes.get(selected);
        }
        if (!this.userDefinedMavenRuntimes.isEmpty() && selected - this.predefinedRuntimes.size() <= this.userDefinedMavenRuntimes.size()) {
            return this.userDefinedMavenRuntimes.get(selected - 1 - this.predefinedRuntimes.size());
        }
        return null;
    }

    private void listDataChanged() {
        this.changed = true;
        boolean oldvalid = this.valid;
        int selected = this.comMavenHome.getSelectedIndex();
        String path = this.getSelectedRuntime(selected);
        if (path != null && "".equals(path = path.trim())) {
            path = null;
            this.valid = true;
            this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"LBL_ExMavenVersion2", (Object)BUNDLED_RUNTIME_VERSION));
        }
        if (path != null) {
            path = path.trim();
            File fil = new File(path);
            String ver = null;
            if (fil.exists() && new File(fil, "bin" + File.separator + "mvn").exists()) {
                ver = MavenSettings.getCommandLineMavenVersion(new File(path));
            }
            if (ver != null) {
                this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"LBL_ExMavenVersion2", ver));
                this.valid = true;
            } else {
                this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"ERR_NoValidInstallation"));
            }
        }
        this.mavenRuntimeHome = path;
        if (oldvalid != this.valid) {
            this.controller.firePropChange("valid", oldvalid, this.valid);
        }
    }

    private ComboBoxModel createComboModel() {
        return new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_weekly"), NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_Daily"), NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_Always"), NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_Never")});
    }

    private void initComponents() {
        this.bgChecksums = new ButtonGroup();
        this.bgPlugins = new ButtonGroup();
        this.bgFailure = new ButtonGroup();
        this.lblCommandLine = new JLabel();
        this.lblExternalVersion = new JLabel();
        this.lblOptions = new JLabel();
        this.txtOptions = new JTextField();
        this.btnOptions = new JButton();
        this.cbSkipTests = new JCheckBox();
        this.lblLocalRepository = new JLabel();
        this.txtLocalRepository = new MyJTextField();
        this.btnLocalRepository = new JButton();
        this.lblBinaries = new JLabel();
        this.comBinaries = new JComboBox();
        this.lblJavadoc = new JLabel();
        this.comJavadoc = new JComboBox();
        this.lblSource = new JLabel();
        this.comSource = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.btnGoals = new JButton();
        this.lblIndex = new JLabel();
        this.comIndex = new JComboBox();
        this.btnIndex = new JButton();
        this.cbSnapshots = new JCheckBox();
        this.comMavenHome = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.lblCommandLine, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblCommandLine.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblOptions, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblOptions.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOptions, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnOptions.text"));
        this.btnOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.btnOptionsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipTests, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbSkipTests.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblLocalRepository, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblLocalRepository.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocalRepository, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnLocalRepository.text"));
        this.btnLocalRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.btnLocalRepositoryActionPerformed(evt);
            }
        });
        this.lblBinaries.setLabelFor(this.comBinaries);
        Mnemonics.setLocalizedText((JLabel)this.lblBinaries, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblBinaries.text"));
        this.lblJavadoc.setLabelFor(this.comJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.lblJavadoc, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblJavadoc.text"));
        this.lblSource.setLabelFor(this.comSource);
        Mnemonics.setLocalizedText((JLabel)this.lblSource, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblSource.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jLabel3.text"));
        this.jLabel3.setVerticalAlignment(1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnGoals, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnGoals.text"));
        this.btnGoals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.btnGoalsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblIndex, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblIndex.text"));
        this.comIndex.setModel(this.createComboModel());
        Mnemonics.setLocalizedText((AbstractButton)this.btnIndex, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnIndex.text"));
        this.btnIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.btnIndexActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbSnapshots, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbSnapshots.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCommandLine).addComponent(this.lblOptions).addComponent(this.lblLocalRepository)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblExternalVersion, -1, 525, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comSource, 0, 412, Short.MAX_VALUE).addComponent(this.comJavadoc, 0, 412, Short.MAX_VALUE).addComponent(this.comBinaries, 0, 412, Short.MAX_VALUE).addComponent(this.txtLocalRepository, -1, 412, Short.MAX_VALUE).addComponent(this.txtOptions, -1, 412, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLocalRepository).addComponent(this.btnOptions))).addComponent(this.cbSkipTests).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.comMavenHome, 0, 403, Short.MAX_VALUE).addGap(122, 122, 122)))).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblJavadoc).addComponent(this.lblBinaries).addComponent(this.lblSource).addComponent(this.jLabel3, -1, 605, Short.MAX_VALUE)).addGap(106, 106, 106)).addComponent(this.btnGoals).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbSnapshots).addComponent(this.comIndex, 0, 421, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnIndex))).addContainerGap()));
        layout.linkSize(0, this.btnIndex, this.btnLocalRepository, this.btnOptions);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCommandLine).addComponent(this.comMavenHome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblExternalVersion, -2, 14, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOptions).addComponent(this.txtOptions, -2, -1, -2).addComponent(this.btnOptions)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSkipTests).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtLocalRepository, -2, -1, -2).addComponent(this.btnLocalRepository).addComponent(this.lblLocalRepository)).addGap(16, 16, 16).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBinaries).addComponent(this.comBinaries, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJavadoc).addComponent(this.comJavadoc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSource).addComponent(this.comSource, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnGoals).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnIndex).addComponent(this.lblIndex).addComponent(this.comIndex, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSnapshots).addContainerGap(23, Short.MAX_VALUE)));
    }

    private void btnIndexActionPerformed(ActionEvent evt) {
        this.btnIndex.setEnabled(false);
        new RequestProcessor("Maven Repo Index Transfer/Scan").post(new Runnable(){

            @Override
            public void run() {
                RepositoryInfo info = RepositoryPreferences.getInstance().getRepositoryInfoById("local");
                if (info != null) {
                    RepositoryIndexer.indexRepo((RepositoryInfo)info);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SettingsPanel.this.btnIndex.setEnabled(true);
                        }
                    });
                }
            }
        });
    }

    private void btnLocalRepositoryActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Select"));
        chooser.setFileSelectionMode(1);
        chooser.setFileHidingEnabled(false);
        String path = ((MyJTextField)this.txtLocalRepository).getRealText();
        if (path.trim().length() == 0) {
            path = new File(System.getProperty("user.home"), ".m2").getAbsolutePath();
        }
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            ((MyJTextField)this.txtLocalRepository).setRealText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
        }
    }

    private void btnGoalsActionPerformed(ActionEvent evt) {
        NbGlobalActionGoalProvider provider = null;
        for (MavenActionsProvider prov : Lookup.getDefault().lookupAll(MavenActionsProvider.class)) {
            if (!(prov instanceof NbGlobalActionGoalProvider)) continue;
            provider = (NbGlobalActionGoalProvider)prov;
        }
        assert (provider != null);
        try {
            ActionToGoalMapping mappings = new NetbeansBuildActionXpp3Reader().read(new StringReader(provider.getRawMappingsAsString()));
            ActionMappings panel = new ActionMappings(mappings);
            panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SettingsPanel.class, (String)"ACSD_Global"));
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Global"));
            Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (retVal == DialogDescriptor.OK_OPTION) {
                FileObject dir = FileUtil.getConfigFile((String)"Projects/org-netbeans-modules-maven");
                CustomizerProviderImpl.writeNbActionsModel(dir, mappings, M2Configuration.getFileNameExt("%%DEFAULT%%"));
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void btnOptionsActionPerformed(ActionEvent evt) {
        GlobalOptionsPanel pnl = new GlobalOptionsPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Add_Globals"));
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == DialogDescriptor.OK_OPTION) {
            this.txtOptions.setText(this.txtOptions.getText() + pnl.getSelectedOnes());
        }
    }

    private void browseAddNewRuntime() {
        File f;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Select2"));
        chooser.setFileSelectionMode(1);
        chooser.setFileHidingEnabled(false);
        int selected = this.comMavenHome.getSelectedIndex();
        String path = this.getSelectedRuntime(selected);
        if (path == null || path.trim().length() == 0) {
            path = new File(System.getProperty("user.home")).getAbsolutePath();
        }
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            String newRuntimePath = FileUtil.normalizeFile((File)projectDir).getAbsolutePath();
            boolean existed = false;
            ArrayList<String> runtimes = new ArrayList<String>();
            runtimes.addAll(this.predefinedRuntimes);
            runtimes.addAll(this.userDefinedMavenRuntimes);
            for (String runtime : runtimes) {
                if (!runtime.equals(newRuntimePath)) continue;
                existed = true;
            }
            if (!existed) {
                if (this.userDefinedMavenRuntimes.isEmpty()) {
                    this.mavenHomeDataModel.insertElementAt(SEPARATOR, this.predefinedRuntimes.size());
                }
                this.userDefinedMavenRuntimes.add(newRuntimePath);
                this.mavenHomeDataModel.insertElementAt(newRuntimePath, runtimes.size() + 1);
            }
            this.comMavenHome.setSelectedItem(newRuntimePath);
        }
    }

    public void setValues() {
        this.txtOptions.setText(MavenSettings.getDefault().getDefaultOptions());
        this.predefinedRuntimes.clear();
        this.predefinedRuntimes.add("");
        String defaultExternalMavenRuntime = MavenSettings.getDefaultExternalMavenRuntime();
        if (defaultExternalMavenRuntime != null) {
            this.predefinedRuntimes.add(defaultExternalMavenRuntime);
        }
        this.userDefinedMavenRuntimes.clear();
        this.userDefinedMavenRuntimes.addAll(MavenSettings.getDefault().getUserDefinedMavenRuntimes());
        this.comMavenHome.removeActionListener(this.listItemChangedListener);
        this.mavenHomeDataModel.removeAllElements();
        File command = MavenSettings.getDefault().getMavenHome();
        String bundled = null;
        for (String runtime : this.predefinedRuntimes) {
            boolean bundledRuntime = runtime.isEmpty();
            String desc = NbBundle.getMessage(SettingsPanel.class, (String)(bundledRuntime ? "MAVEN_RUNTIME_Bundled" : "MAVEN_RUNTIME_External"), (Object[])new Object[]{runtime, bundledRuntime ? BUNDLED_RUNTIME_VERSION : MavenSettings.getCommandLineMavenVersion(new File(runtime))});
            this.mavenHomeDataModel.addElement(desc);
        }
        if (!this.userDefinedMavenRuntimes.isEmpty()) {
            this.mavenHomeDataModel.addElement(SEPARATOR);
            for (String runtime : this.userDefinedMavenRuntimes) {
                String desc = NbBundle.getMessage(SettingsPanel.class, (String)"MAVEN_RUNTIME_External", (Object[])new Object[]{runtime, MavenSettings.getCommandLineMavenVersion(new File(runtime))});
                this.mavenHomeDataModel.addElement(desc);
            }
        }
        this.mavenHomeDataModel.addElement(SEPARATOR);
        this.mavenHomeDataModel.addElement(NbBundle.getMessage(SettingsPanel.class, (String)"MAVEN_RUNTIME_Browse"));
        this.comMavenHome.setSelectedItem(command != null ? command.getAbsolutePath() : bundled);
        this.listDataChanged();
        this.lastSelected = this.comMavenHome.getSelectedIndex();
        this.comMavenHome.addActionListener(this.listItemChangedListener);
        this.cbSnapshots.setSelected(RepositoryPreferences.getInstance().isIncludeSnapshots());
        this.comIndex.setSelectedIndex(RepositoryPreferences.getInstance().getIndexUpdateFrequency());
        String repo = MavenSettings.getDefault().getCustomLocalRepository();
        ((MyJTextField)this.txtLocalRepository).setRealText(repo != null ? repo : "");
        this.comBinaries.setSelectedItem((Object)MavenSettings.getDefault().getBinaryDownloadStrategy());
        this.comJavadoc.setSelectedItem((Object)MavenSettings.getDefault().getJavadocDownloadStrategy());
        this.comSource.setSelectedItem((Object)MavenSettings.getDefault().getSourceDownloadStrategy());
        this.cbSkipTests.setSelected(MavenSettings.getDefault().isSkipTests());
        this.changed = false;
    }

    public void applyValues() {
        File command;
        MavenSettings.getDefault().setDefaultOptions(this.txtOptions.getText().trim());
        MavenSettings.getDefault().setCustomLocalRepository(((MyJTextField)this.txtLocalRepository).getRealText());
        ArrayList<String> runtimes = new ArrayList<String>();
        for (int i = 0; i < this.userDefinedMavenRuntimes.size() && i < 5; ++i) {
            runtimes.add(0, this.userDefinedMavenRuntimes.get(this.userDefinedMavenRuntimes.size() - 1 - i));
        }
        int selected = this.comMavenHome.getSelectedIndex() - this.predefinedRuntimes.size() - 1;
        if (selected >= 0 && runtimes.size() == 5 && this.userDefinedMavenRuntimes.size() - 5 > selected) {
            runtimes.set(0, this.userDefinedMavenRuntimes.get(selected));
        }
        if (this.predefinedRuntimes.size() > 1) {
            runtimes.add(0, this.predefinedRuntimes.get(1));
        }
        MavenSettings.getDefault().setMavenRuntimes(runtimes);
        String cl = this.mavenRuntimeHome;
        File file = command = cl == null || cl.isEmpty() ? null : new File(cl);
        if (command != null && command.isDirectory()) {
            MavenSettings.getDefault().setMavenHome(command);
        } else {
            MavenSettings.getDefault().setMavenHome(null);
        }
        RepositoryPreferences.getInstance().setIndexUpdateFrequency(this.comIndex.getSelectedIndex());
        RepositoryPreferences.getInstance().setIncludeSnapshots(this.cbSnapshots.isSelected());
        MavenSettings.getDefault().setBinaryDownloadStrategy((MavenSettings.DownloadStrategy)((Object)this.comBinaries.getSelectedItem()));
        MavenSettings.getDefault().setJavadocDownloadStrategy((MavenSettings.DownloadStrategy)((Object)this.comJavadoc.getSelectedItem()));
        MavenSettings.getDefault().setSourceDownloadStrategy((MavenSettings.DownloadStrategy)((Object)this.comSource.getSelectedItem()));
        MavenSettings.getDefault().setSkipTests(this.cbSkipTests.isSelected());
        this.changed = false;
    }

    boolean hasValidValues() {
        return this.valid;
    }

    boolean hasChangedValues() {
        return this.changed;
    }

    private class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsPanel.this.changed = true;
        }
    }

    private static class ComboBoxRenderer
    extends DefaultListCellRenderer {
        private JSeparator separator = new JSeparator(0);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (SettingsPanel.SEPARATOR.equals(value)) {
                return this.separator;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

