/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public abstract class OutputTabMaintainer {
    protected static final Map<InputOutput, Collection<String>> freeTabs = new WeakHashMap<InputOutput, Collection<String>>();
    protected InputOutput io;
    private final String name;

    protected OutputTabMaintainer(String name) {
        assert (name != null);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markFreeTab() {
        Map<InputOutput, Collection<String>> map = freeTabs;
        synchronized (map) {
            assert (this.io != null);
            freeTabs.put(this.io, this.createContext());
        }
    }

    protected void reassignAdditionalContext(Iterator it) {
    }

    protected Collection<String> createContext() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.add(this.name);
        toRet.add(this.getClass().getName());
        return toRet;
    }

    protected Action[] createNewTabActions() {
        return new Action[0];
    }

    public final InputOutput getInputOutput() {
        if (this.io == null) {
            this.io = this.createInputOutput();
        }
        return this.io;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final InputOutput createInputOutput() {
        Map<InputOutput, Collection<String>> map = freeTabs;
        synchronized (map) {
            for (Map.Entry<InputOutput, Collection<String>> entry : freeTabs.entrySet()) {
                InputOutput free = entry.getKey();
                Iterator<String> vals = entry.getValue().iterator();
                String freeName = vals.next();
                String type = vals.next();
                if (this.io == null && freeName.equals(this.name) && type.equals(this.getClass().getName())) {
                    this.io = free;
                    this.reassignAdditionalContext(vals);
                    try {
                        this.io.getOut().reset();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                free.closeInputOutput();
            }
            freeTabs.clear();
        }
        if (this.io == null) {
            this.io = IOProvider.getDefault().getIO(this.name, this.createNewTabActions());
            this.io.setInputVisible(true);
        }
        return this.io;
    }
}

