/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.MavenSettingsSingleton;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.util.NbCollections;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectProfileHandlerImpl
implements ProjectProfileHandler {
    private static final String PROFILES = "profiles";
    private static final String ACTIVEPROFILES = "activeProfiles";
    private static final String SEPARATOR = " ";
    private static final String NAMESPACE = null;
    private final List<String> privateProfiles = new ArrayList<String>();
    private final List<String> sharedProfiles = new ArrayList<String>();
    private final AuxiliaryConfiguration ac;
    private final NbMavenProjectImpl nmp;
    private List<Model> lineage;

    public ProjectProfileHandlerImpl(NbMavenProjectImpl nmp, AuxiliaryConfiguration ac) {
        this.nmp = nmp;
        this.ac = ac;
        this.privateProfiles.addAll(this.retrieveActiveProfiles(ac, false));
        this.sharedProfiles.addAll(this.retrieveActiveProfiles(ac, true));
    }

    public synchronized void clearLineageCache() {
        this.lineage = null;
    }

    private synchronized List<Model> getLineage() {
        if (this.lineage == null) {
            try {
                this.lineage = EmbedderFactory.createModelLineage((File)this.nmp.getPOMFile(), (MavenEmbedder)this.nmp.getEmbedder());
            }
            catch (ModelBuildingException ex) {
                Logger.getLogger(ProjectProfileHandlerImpl.class.getName()).log(Level.FINE, "Error reading model lineage", ex);
                this.lineage = Collections.emptyList();
            }
        }
        return this.lineage;
    }

    @Override
    public List<String> getAllProfiles() {
        HashSet<String> profileIds = new HashSet<String>();
        this.extractProfiles(profileIds);
        profileIds.addAll(NbCollections.checkedMapByFilter((Map)MavenSettingsSingleton.getInstance().createUserSettingsModel().getProfilesAsMap(), String.class, org.apache.maven.settings.Profile.class, (boolean)true).keySet());
        return new ArrayList<String>(profileIds);
    }

    @Override
    public List<String> getActiveProfiles(boolean shared) {
        return new ArrayList<String>(shared ? this.sharedProfiles : this.privateProfiles);
    }

    @Override
    public List<String> getMergedActiveProfiles(boolean shared) {
        HashSet<String> profileIds = new HashSet<String>();
        MavenProject mavenProject = this.nmp.getOriginalMavenProject();
        List profiles = mavenProject.getActiveProfiles();
        for (Profile profile : profiles) {
            profileIds.add(profile.getId());
        }
        List profileStrings = MavenSettingsSingleton.getInstance().createUserSettingsModel().getActiveProfiles();
        for (String profile : profileStrings) {
            profileIds.add(profile);
        }
        profileIds.addAll(this.getActiveProfiles(shared));
        return new ArrayList<String>(profileIds);
    }

    @Override
    public void disableProfile(String id, boolean shared) {
        String activeProfiles;
        Element element = this.ac.getConfigurationFragment(PROFILES, NAMESPACE, shared);
        if (element == null) {
            String root = "project-private";
            Document doc = XMLUtil.createDocument((String)root, (String)NAMESPACE, null, null);
            element = doc.createElementNS(NAMESPACE, PROFILES);
        }
        if ((activeProfiles = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES)) != null && activeProfiles.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(activeProfiles, SEPARATOR);
            HashSet<String> set = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                set.add(tokenizer.nextToken());
            }
            set.remove(id);
            StringBuilder buffer = new StringBuilder();
            for (String profle : set) {
                buffer.append(profle).append(SEPARATOR);
            }
            element.setAttributeNS(NAMESPACE, ACTIVEPROFILES, buffer.toString().trim());
        }
        this.ac.putConfigurationFragment(element, shared);
        if (shared) {
            this.sharedProfiles.remove(id);
        } else {
            this.privateProfiles.remove(id);
        }
    }

    @Override
    public void enableProfile(String id, boolean shared) {
        Element element = this.ac.getConfigurationFragment(PROFILES, NAMESPACE, shared);
        if (element == null) {
            String root = "project-private";
            Document doc = XMLUtil.createDocument((String)root, (String)NAMESPACE, null, null);
            element = doc.createElementNS(NAMESPACE, PROFILES);
        }
        String activeProfiles = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES);
        element.setAttributeNS(NAMESPACE, ACTIVEPROFILES, activeProfiles + SEPARATOR + id);
        this.ac.putConfigurationFragment(element, shared);
        if (shared) {
            if (!this.sharedProfiles.contains(id)) {
                this.sharedProfiles.add(id);
            }
        } else if (!this.privateProfiles.contains(id)) {
            this.privateProfiles.add(id);
        }
    }

    private void extractProfiles(Set<String> profileIds) {
        for (Model model : this.getLineage()) {
            for (Profile profile : model.getProfiles()) {
                profileIds.add(profile.getId());
            }
        }
    }

    private List<String> retrieveActiveProfiles(AuxiliaryConfiguration ac, boolean shared) {
        String activeProfiles;
        HashSet<String> prifileides = new HashSet<String>();
        Element element = ac.getConfigurationFragment(PROFILES, NAMESPACE, shared);
        if (element != null && (activeProfiles = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES)) != null && activeProfiles.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(activeProfiles, SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                prifileides.add(tokenizer.nextToken());
            }
        }
        return new ArrayList<String>(prifileides);
    }
}

