/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.util.NbBundle;

public abstract class ComboBoxUpdater<T>
implements ActionListener,
AncestorListener {
    private JComboBox component;
    private JLabel label;
    private boolean inherited = false;

    public ComboBoxUpdater(JComboBox comp, JLabel label) {
        this.component = comp;
        this.component.addAncestorListener(this);
        this.label = label;
    }

    public abstract T getValue();

    public abstract T getDefaultValue();

    public abstract void setValue(T var1);

    private void setModelValue() {
        Object val;
        if (this.inherited) {
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
            this.component.setToolTipText(null);
        }
        this.setValue((val = this.component.getSelectedItem()) == this.getDefaultValue() ? null : val);
        if (val == this.getDefaultValue()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComboBoxUpdater.this.component.removeActionListener(ComboBoxUpdater.this);
                    ComboBoxUpdater.this.setComboValue(ComboBoxUpdater.this.getValue(), ComboBoxUpdater.this.getDefaultValue(), ComboBoxUpdater.this.component);
                    ComboBoxUpdater.this.component.addActionListener(ComboBoxUpdater.this);
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.setModelValue();
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setComboValue(this.getValue(), this.getDefaultValue(), this.component);
        this.component.addActionListener(this);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.component.removeActionListener(this);
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    private void setComboValue(T value, T projectValue, JComboBox field) {
        if (value != null) {
            field.setSelectedItem(value);
            this.component.setToolTipText(null);
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
        } else if (projectValue != null) {
            field.setSelectedItem(projectValue);
            this.label.setFont(this.label.getFont().deriveFont(0));
            this.component.setToolTipText(NbBundle.getMessage(ComboBoxUpdater.class, (String)"HINT_inherited"));
            this.inherited = true;
        } else {
            field.setSelectedItem(field.getModel().getElementAt(0));
            this.component.setToolTipText(null);
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
        }
    }
}

