/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public final class DTDCConfigurationFactory {
    static DTDCConfiguration create(Map map) {
        DTDCConfiguration result = null;
        try {
            String tableLink = DTDCConfigurationFactory.getStringValue(map, "datatable");
            FileObject rootFolder = FileUtil.getConfigRoot();
            FileObject tableFolder = rootFolder.getFileObject(tableLink);
            DataTableMetadata datatable = (DataTableMetadata)tableFolder.getAttribute("instanceCreate");
            result = new DTDCConfiguration(new URL(DTDCConfigurationFactory.getStringValue(map, "script")), Arrays.asList(datatable));
            result.setOutputPrefix(DTDCConfigurationFactory.getStringValue(map, "ouput.prefix"));
            if (map.get("indicator.firing.factor") != null) {
                result.setIndicatorFiringFactor(Integer.valueOf(DTDCConfigurationFactory.getStringValue(map, "indicator.firing.factor")));
            }
            if (map.get("script.args") != null) {
                result.setScriptArgs(DTDCConfigurationFactory.getStringValue(map, "script.args"));
            }
            result.setStackSupportEnabled(Boolean.valueOf(DTDCConfigurationFactory.getStringValue(map, "stack.support")));
            result.setStandalone(Boolean.valueOf(DTDCConfigurationFactory.getStringValue(map, "standalone")));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    private static String getStringValue(Map map, String key) {
        return (String)map.get(key);
    }
}

