/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.datacollector.CpuSamplingSupport;
import org.netbeans.modules.dlight.dtrace.collector.DTraceOutputParser;
import org.netbeans.modules.dlight.dtrace.collector.impl.DTDCConfigurationAccessor;

public final class DTDCConfiguration
implements DataCollectorConfiguration,
IndicatorDataProviderConfiguration {
    public static final String DTRACE_KERNEL = "dtrace_kernel";
    public static final String DTRACE_USER = "dtrace_user";
    public static final String DTRACE_PROC = "dtrace_proc";
    public static final String DSCRIPT_TOOL_PROPERTY = "dtrace.script";
    static final String DTDC_CONFIGURATION_ID = "DtraceDataCollectorConfigurationId";
    private static DTDCConfiguration CPU_SAMPLING;
    private URL scriptUrl;
    private String args;
    private List<DataTableMetadata> datatableMetadata;
    private DTraceOutputParser parser;
    private List<String> requiredPrivileges;
    private boolean stackSupportEnabled = false;
    private int indicatorFiringFactor;
    private boolean standalone;
    private String prefix;

    public DTDCConfiguration(URL scriptUrl, List<DataTableMetadata> dataTableMetadata) {
        this.scriptUrl = scriptUrl;
        this.datatableMetadata = dataTableMetadata;
        this.args = null;
        this.parser = null;
        this.requiredPrivileges = null;
        this.indicatorFiringFactor = 1;
    }

    public void setScriptArgs(String args) {
        this.args = args;
    }

    public void setDtraceParser(DTraceOutputParser parser) {
        this.parser = parser;
    }

    public void setIndicatorFiringFactor(int indicatorFiringFactor) {
        this.indicatorFiringFactor = indicatorFiringFactor;
    }

    public void setRequiredDTracePrivileges(List<String> requiredPrivileges) {
        this.requiredPrivileges = new ArrayList<String>(requiredPrivileges);
    }

    public void setStackSupportEnabled(boolean stackSupportEnabled) {
        this.stackSupportEnabled = stackSupportEnabled;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public void setOutputPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getID() {
        return DTDC_CONFIGURATION_ID;
    }

    public static synchronized DTDCConfiguration createCpuSamplingConfiguration() {
        if (CPU_SAMPLING == null) {
            CPU_SAMPLING = new DTDCConfiguration(CpuSamplingSupport.CPU_SAMPLING_SCRIPT_URL, Arrays.asList(CpuSamplingSupport.CPU_SAMPLE_TABLE));
            CPU_SAMPLING.setStackSupportEnabled(true);
            CPU_SAMPLING.setOutputPrefix("cpu:");
        }
        return CPU_SAMPLING;
    }

    static {
        DTDCConfigurationAccessor.setDefault(new DTDCConfigurationAccessorImpl());
    }

    private static final class DTDCConfigurationAccessorImpl
    extends DTDCConfigurationAccessor {
        private DTDCConfigurationAccessorImpl() {
        }

        @Override
        public String getArgs(DTDCConfiguration conf) {
            return conf.args;
        }

        @Override
        public List<DataTableMetadata> getDatatableMetadata(DTDCConfiguration conf) {
            return conf.datatableMetadata == null ? null : Collections.unmodifiableList(conf.datatableMetadata);
        }

        @Override
        public DTraceOutputParser getParser(DTDCConfiguration conf) {
            return conf.parser;
        }

        @Override
        public List<String> getRequiredPrivileges(DTDCConfiguration conf) {
            return conf.requiredPrivileges == null ? null : Collections.unmodifiableList(conf.requiredPrivileges);
        }

        @Override
        public URL getScriptUrl(DTDCConfiguration conf) {
            return conf.scriptUrl;
        }

        @Override
        public String getID() {
            return DTDCConfiguration.DTDC_CONFIGURATION_ID;
        }

        @Override
        public boolean isStackSupportEnabled(DTDCConfiguration conf) {
            return conf.stackSupportEnabled;
        }

        @Override
        public int getIndicatorFiringFactor(DTDCConfiguration conf) {
            return conf.indicatorFiringFactor;
        }

        @Override
        public boolean isStandalone(DTDCConfiguration conf) {
            return conf.standalone;
        }

        @Override
        public String getOutputPrefix(DTDCConfiguration conf) {
            return conf.prefix;
        }
    }
}

