/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.codegen;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.modules.websvc.manager.WebServiceManager;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.util.ManagerUtil;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class Wsdl2Java {
    private static final String wsImportCompileScriptName = "modules/ext/build-ws.xml";
    private static File wsImportCompileScript;
    private static final String WEBSVC_HOME_PROP = "websvc.home";
    private static final String USER_FILE_PROP = "user.properties.file";
    private static final String JAXWS_ENDORSED_DIR = "jaxws.endorsed.dir";
    private static final String WSDL_NAME_PROP = "serviceName";
    private static final String WSDL_DIRNAME_PROP = "serviceDirName";
    private static final String WSDL_FILE_NAME_PROP = "wsdlFileName";
    private static final String PACKAGE_NAME = "packageName";
    private static final String CONFIG_FILE_PROP = "config.file";
    private static final String PROXY_SERVER = "proxy.server";
    private static final String TEST_URI = "http://schemas.xmlsoap.org/soap/http";
    private static final String CATALOG = "catalog.file";
    private static final String JAXB_ENDORSED_REF = "modules/ext/jaxb/api/jaxb-api.jar";
    private static final String JAXWS_ENDORSED_REF = "modules/ext/jaxws22/api/jaxws-api.jar";
    private final String userDir = System.getProperty("netbeans.user");
    private WebServiceData webServiceData;
    private Properties properties;
    private File catalogFile;

    public Wsdl2Java(WebServiceData webServiceData) {
        this.webServiceData = webServiceData;
        this.properties = new Properties();
        this.catalogFile = new File(webServiceData.getCatalog());
    }

    public boolean createProxyJars() {
        try {
            int n;
            InetSocketAddress inetSocketAddress;
            String string;
            Object object;
            boolean bl = ManagerUtil.isJAXRPCAvailable();
            String string2 = this.webServiceData.getOriginalWsdlUrl();
            String string3 = WsdlUtil.getServiceDirName((String)this.webServiceData.getOriginalWsdlUrl());
            String string4 = this.webServiceData.getName();
            String string5 = this.webServiceData.getPackageName();
            this.properties.put(WEBSVC_HOME_PROP, WebServiceManager.WEBSVC_HOME);
            this.properties.put(USER_FILE_PROP, this.userDir + "/build.properties");
            this.properties.put(WSDL_DIRNAME_PROP, string3);
            this.properties.put(WSDL_NAME_PROP, string4);
            this.properties.put(WSDL_FILE_NAME_PROP, string2);
            this.properties.put(PACKAGE_NAME, string5 == null ? "" : string5);
            File file = InstalledFileLocator.getDefault().locate(JAXB_ENDORSED_REF, null, true).getParentFile();
            File file2 = InstalledFileLocator.getDefault().locate(JAXWS_ENDORSED_REF, null, true).getParentFile();
            this.properties.put(JAXWS_ENDORSED_DIR, file.getAbsolutePath() + ":" + file2.getAbsolutePath());
            this.properties.put(CATALOG, this.catalogFile.getAbsolutePath());
            try {
                ProxySelector proxySelector = ProxySelector.getDefault();
                object = proxySelector.select(new URI(TEST_URI));
                string = "";
                if (object.size() > 0 && (inetSocketAddress = (InetSocketAddress)object.get(0).address()) != null) {
                    String string6 = "http://" + inetSocketAddress.getHostName();
                    String string7 = String.valueOf(inetSocketAddress.getPort());
                    string = string6 + ":" + string7;
                }
                this.properties.put(PROXY_SERVER, string);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getLocalizedMessage(), exception);
            }
            boolean bl2 = this.createJaxWsProxyJars(this.properties);
            if (!bl2) {
                this.webServiceData.setJaxWsEnabled(false);
                object = NbBundle.getMessage(Wsdl2Java.class, (String)"CODEGEN_ERROR_JAXWS");
                string = new NotifyDescriptor.Message(object);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)string);
            } else {
                this.webServiceData.setJaxWsEnabled(true);
            }
            boolean bl3 = false;
            if (bl) {
                bl3 = this.createJaxRpcProxyJars(this.properties);
            }
            if (!bl3) {
                this.webServiceData.setJaxRpcEnabled(false);
                if (bl) {
                    string = NbBundle.getMessage(Wsdl2Java.class, (String)"CODEGEN_ERROR_JAXRPC");
                    inetSocketAddress = new NotifyDescriptor.Message((Object)string);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)inetSocketAddress);
                }
            } else {
                this.webServiceData.setJaxRpcEnabled(true);
            }
            if ((n = string4.lastIndexOf(47)) != -1) {
                string4 = string4.substring(n + 1);
            }
            if (this.webServiceData.isJaxRpcEnabled()) {
                this.webServiceData.setJaxRpcDescriptorPath(string3 + "/jaxrpc/" + string4 + ".xml");
            }
            if (this.webServiceData.isJaxWsEnabled()) {
                this.webServiceData.setJaxWsDescriptorPath(string3 + "/jaxws/" + string4 + ".xml");
            }
            return bl2 || bl3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
            return false;
        }
    }

    private boolean createJaxWsProxyJars(Properties properties) {
        try {
            boolean bl;
            ExecutorTask executorTask = ActionUtils.runTarget((FileObject)FileUtil.toFileObject((File)this.getAntScript()), (String[])new String[]{"wsimport-jar"}, (Properties)properties);
            executorTask.waitFinished();
            boolean bl2 = bl = executorTask.result() == 0;
            if (!bl) {
                try {
                    String string = properties.getProperty(WEBSVC_HOME_PROP) + "/" + properties.getProperty(WSDL_NAME_PROP) + "/jaxws";
                    this.deleteWsDir(string);
                }
                catch (NullPointerException nullPointerException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, nullPointerException.getLocalizedMessage(), nullPointerException);
                }
            }
            return bl;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
    }

    private boolean createJaxRpcProxyJars(Properties properties) {
        try {
            boolean bl;
            String string = new File(this.webServiceData.getURL()).toURI().toURL().toString();
            this.createJaxrpcConfigFile(string, properties);
            ExecutorTask executorTask = ActionUtils.runTarget((FileObject)FileUtil.toFileObject((File)this.getAntScript()), (String[])new String[]{"wscompile-jar"}, (Properties)properties);
            executorTask.waitFinished();
            boolean bl2 = bl = executorTask.result() == 0;
            if (!bl) {
                try {
                    String string2 = properties.getProperty(WEBSVC_HOME_PROP) + "/" + properties.getProperty(WSDL_NAME_PROP) + "/jaxrpc";
                    this.deleteWsDir(string2);
                }
                catch (NullPointerException nullPointerException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, nullPointerException.getLocalizedMessage(), nullPointerException);
                }
            }
            return bl;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
    }

    private void deleteWsDir(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        File file2 = new File(file, "build");
        this.rmDir(file2);
        File file3 = new File(file, "src");
        this.rmDir(file3);
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".jar");
            }
        });
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
        file.delete();
    }

    private void rmDir(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                if (fileArray[i].isFile()) {
                    fileArray[i].delete();
                    continue;
                }
                this.rmDir(fileArray[i]);
            }
            file.delete();
        }
    }

    private File getAntScript() {
        if (wsImportCompileScript == null) {
            wsImportCompileScript = InstalledFileLocator.getDefault().locate(wsImportCompileScriptName, "", false);
        }
        return wsImportCompileScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJaxrpcConfigFile(String string, Properties properties) {
        try {
            File file = File.createTempFile("jaxrpcconfigfile", ".xml");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            String string2 = this.webServiceData.getEffectivePackageName();
            if (string2 == null || string2.trim().length() == 0) {
                String string3 = NbBundle.getMessage(Wsdl2Java.class, (String)"MSG_InvalidPackageName");
                throw new IllegalArgumentException(string3);
            }
            String string4 = "\t<wsdl location=\"" + string + "\" packageName=\"" + string2 + "\"/>";
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            try {
                printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                printWriter.println("<configuration xmlns=\"http://java.sun.com/xml/ns/jax-rpc/ri/config\">");
                printWriter.println(string4);
                printWriter.println("</configuration>");
            }
            finally {
                printWriter.close();
            }
            properties.put(CONFIG_FILE_PROP, file.getAbsolutePath());
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }
}

