/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IntList;
import org.netbeans.core.output2.IntListSimple;
import org.netbeans.core.output2.IntMap;
import org.netbeans.core.output2.LineInfo;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.SparseIntList;
import org.netbeans.core.output2.Storage;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.windows.IOColors;
import org.openide.windows.OutputListener;

abstract class AbstractLines
implements Lines,
Runnable,
ActionListener {
    IntList lineStartList;
    IntListSimple lineCharLengthListWithTabs;
    IntMap lineWithListenerToInfo;
    IntMap linesToInfos;
    private int longestLineLen = 0;
    private int knownCharsPerLine = -1;
    private SparseIntList knownLogicalLineCounts = null;
    private IntList tabCharOffsets = new IntList(100);
    private IntListSimple tabLengthSums = new IntListSimple(100);
    private int lastStorageSize = -1;
    private ChangeListener listener = null;
    private Timer timer = null;
    private final AtomicBoolean newEvent = new AtomicBoolean(false);
    private boolean dirty;
    private IntList importantLines = new IntList(10);
    private boolean lastLineFinished = true;
    private int lastLineLength = -1;
    private int lastCharLengthWithTabs = -1;
    static final Color[] DEF_COLORS;
    Color[] curDefColors;
    private static final int MAX_FIND_SIZE = 16384;
    private Pattern pattern;

    AbstractLines() {
        if (Controller.LOG) {
            Controller.log("Creating a new AbstractLines");
        }
        this.init();
    }

    protected abstract Storage getStorage();

    protected abstract boolean isDisposed();

    protected abstract void handleException(Exception var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getText(int start, int end, char[] chars) {
        if (chars == null) {
            chars = new char[end - start];
        }
        if (end < start || start < 0) {
            throw new IllegalArgumentException("Illogical text range from " + start + " to " + end);
        }
        if (end - start > chars.length) {
            throw new IllegalArgumentException("Array size is too small");
        }
        Object object = this.readLock();
        synchronized (object) {
            if (this.isDisposed()) {
                for (int i = 0; i < end - start; ++i) {
                    chars[i] = '\u0000';
                }
                return chars;
            }
            int fileStart = AbstractLines.toByteIndex(start);
            int byteCount = AbstractLines.toByteIndex(end - start);
            try {
                CharBuffer chb = this.getStorage().getReadBuffer(fileStart, byteCount).asCharBuffer();
                int len = Math.min(end - start, chb.remaining());
                chb.get(chars, 0, len);
                return chars;
            }
            catch (Exception e) {
                this.handleException(e);
                return new char[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharBuffer getCharBuffer(int start, int len) {
        if (len < 0 || start < 0) {
            throw new IllegalArgumentException("Illogical text range from " + start + " to " + (start + len));
        }
        Object object = this.readLock();
        synchronized (object) {
            if (this.isDisposed()) {
                return null;
            }
            int fileStart = AbstractLines.toByteIndex(start);
            int byteCount = AbstractLines.toByteIndex(len);
            int available = this.getStorage().size();
            if (available < fileStart + byteCount) {
                throw new ArrayIndexOutOfBoundsException("Bytes from " + fileStart + " to " + (fileStart + byteCount) + " requested, " + "but storage is only " + available + " bytes long");
            }
            try {
                return this.getStorage().getReadBuffer(fileStart, byteCount).asCharBuffer();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    @Override
    public String getText(int start, int end) {
        CharBuffer cb = this.getCharBuffer(start, end - start);
        return cb != null ? cb.toString() : new String(new char[end - start]);
    }

    void onDispose(int lastStorageSize) {
        this.lastStorageSize = lastStorageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getByteSize() {
        Object object = this.readLock();
        synchronized (object) {
            if (this.lastStorageSize >= 0) {
                return this.lastStorageSize;
            }
            Storage storage = this.getStorage();
            int n = storage == null ? 0 : storage.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ChangeListener cl) {
        this.listener = cl;
        AbstractLines abstractLines = this;
        synchronized (abstractLines) {
            if (this.getLineCount() > 0) {
                this.fire();
            }
        }
    }

    @Override
    public void removeChangeListener(ChangeListener cl) {
        if (this.listener == cl) {
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        this.newEvent.set(false);
        this.fire();
        AtomicBoolean atomicBoolean = this.newEvent;
        synchronized (atomicBoolean) {
            if (!this.newEvent.get()) {
                this.timer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delayedFire() {
        this.newEvent.set(true);
        if (this.listener == null) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer(200, this);
        }
        AtomicBoolean atomicBoolean = this.newEvent;
        synchronized (atomicBoolean) {
            if (this.newEvent.get() && !this.timer.isRunning()) {
                this.timer.start();
            }
        }
    }

    public void fire() {
        if (Controller.LOG) {
            Controller.log(this + ": Writer firing " + this.getStorage().size() + " bytes written");
        }
        if (this.listener != null) {
            Mutex.EVENT.readAccess((Runnable)this);
        }
    }

    @Override
    public void run() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public boolean hasListeners() {
        return this.firstListenerLine() != -1;
    }

    @Override
    public OutputListener getListener(int pos, int[] range) {
        int line = this.getLineAt(pos);
        int lineStart = this.getLineStart(line);
        pos -= lineStart;
        LineInfo info = (LineInfo)this.lineWithListenerToInfo.get(line);
        if (info == null) {
            return null;
        }
        int start = 0;
        for (LineInfo.Segment seg : info.getLineSegments()) {
            if (pos < seg.getEnd()) {
                if (seg.getListener() != null) {
                    if (range != null) {
                        range[0] = lineStart + start;
                        range[1] = lineStart + seg.getEnd();
                    }
                    return seg.getListener();
                }
                return null;
            }
            start = seg.getEnd();
        }
        return null;
    }

    @Override
    public boolean isListener(int start, int end) {
        int[] range = new int[2];
        OutputListener l = this.getListener(start, range);
        return l == null ? false : range[0] == start && range[1] == end;
    }

    private void init() {
        this.knownLogicalLineCounts = null;
        this.lineStartList = new IntList(100);
        this.lineStartList.add(0);
        this.lineCharLengthListWithTabs = new IntListSimple(100);
        this.linesToInfos = new IntMap();
        this.lineWithListenerToInfo = new IntMap();
        this.longestLineLen = 0;
        this.listener = null;
        this.dirty = false;
        this.curDefColors = (Color[])DEF_COLORS.clone();
    }

    @Override
    public boolean checkDirty(boolean clear) {
        if (this.isDisposed()) {
            return false;
        }
        boolean wasDirty = this.dirty;
        if (clear) {
            this.dirty = false;
        }
        return wasDirty;
    }

    @Override
    public int[] getLinesWithListeners() {
        return this.lineWithListenerToInfo.getKeys();
    }

    @Override
    public int getCharCount() {
        return AbstractLines.toCharIndex(this.getByteSize());
    }

    @Override
    public String getLine(int idx) throws IOException {
        int lineStart = this.getCharLineStart(idx);
        int lineEnd = AbstractLines.toCharIndex(idx < this.lineStartList.size() - 1 ? this.lineStartList.get(idx + 1) : this.getByteSize());
        return this.getText(lineStart, lineEnd);
    }

    private int getByteLineLength(int idx) {
        if (idx == this.lineStartList.size() - 1) {
            return Math.max(0, AbstractLines.toByteIndex(this.lastLineLength));
        }
        int lineStart = this.getByteLineStart(idx);
        int lineEnd = idx < this.lineStartList.size() - 1 ? this.lineStartList.get(idx + 1) - 2 * "\n".length() : this.getByteSize();
        return lineEnd - lineStart;
    }

    @Override
    public boolean isLineStart(int chpos) {
        int bpos = AbstractLines.toByteIndex(chpos);
        return this.lineStartList.contains(bpos) || bpos == 0 || bpos == this.getByteSize() && this.lastLineFinished;
    }

    @Override
    public int length(int idx) {
        return AbstractLines.toCharIndex(this.getByteLineLength(idx));
    }

    @Override
    public int lengthWithTabs(int idx) {
        if (idx == this.lineCharLengthListWithTabs.size()) {
            return Math.max(0, this.lastCharLengthWithTabs);
        }
        return this.lineCharLengthListWithTabs.get(idx);
    }

    @Override
    public int getLineStart(int line) {
        return this.getCharLineStart(line);
    }

    private int getByteLineStart(int line) {
        if (line == this.lineStartList.size() && this.lastLineFinished) {
            return this.getByteSize();
        }
        return this.lineStartList.get(line);
    }

    private int getCharLineStart(int line) {
        return AbstractLines.toCharIndex(this.getByteLineStart(line));
    }

    @Override
    public int getLineAt(int position) {
        int bytePos = AbstractLines.toByteIndex(position);
        if (bytePos >= this.getByteSize()) {
            return this.getLineCount() - 1;
        }
        return this.lineStartList.findNearest(bytePos);
    }

    @Override
    public int getLineCount() {
        return this.lineStartList.size();
    }

    @Override
    public Collection<OutputListener> getListenersForLine(int line) {
        LineInfo info = (LineInfo)this.lineWithListenerToInfo.get(line);
        if (info == null) {
            return Collections.emptyList();
        }
        return info.getListeners();
    }

    @Override
    public int firstListenerLine() {
        if (this.isDisposed()) {
            return -1;
        }
        return this.lineWithListenerToInfo.isEmpty() ? -1 : this.lineWithListenerToInfo.first();
    }

    @Override
    public OutputListener nearestListener(int pos, boolean backward, int[] range) {
        int posLine = this.getLineAt(pos);
        int line = this.lineWithListenerToInfo.nearest(posLine, backward);
        if (line < 0) {
            return null;
        }
        LineInfo info = (LineInfo)this.lineWithListenerToInfo.get(line);
        int lineStart = this.getLineStart(line);
        OutputListener l = null;
        int[] lpos = new int[2];
        if (posLine == line) {
            if (backward) {
                info.getFirstListener(lpos);
                if (lpos[0] + lineStart > pos) {
                    line = this.lineWithListenerToInfo.nearest(line - 1, backward);
                    info = (LineInfo)this.lineWithListenerToInfo.get(line);
                    lineStart = this.getLineStart(line);
                    l = info.getLastListener(lpos);
                }
            } else {
                info.getLastListener(lpos);
                if (lpos[1] + lineStart <= pos) {
                    line = this.lineWithListenerToInfo.nearest(line + 1, backward);
                    info = (LineInfo)this.lineWithListenerToInfo.get(line);
                    lineStart = this.getLineStart(line);
                    l = info.getFirstListener(lpos);
                }
            }
        } else {
            pos = lineStart;
            OutputListener outputListener = l = backward ? info.getLastListener(lpos) : info.getFirstListener(lpos);
        }
        if (l == null) {
            OutputListener outputListener = l = backward ? info.getListenerBefore(pos - lineStart, lpos) : info.getListenerAfter(pos - lineStart, lpos);
        }
        if (l != null) {
            range[0] = lpos[0] + lineStart;
            range[1] = lpos[1] + lineStart;
        }
        return l;
    }

    @Override
    public int getLongestLineLength() {
        return this.longestLineLen;
    }

    @Override
    public void toPhysicalLineIndex(int[] info, int charsPerLine) {
        int logicalLineIdx = info[0];
        if (logicalLineIdx <= 0) {
            info[0] = 0;
            info[1] = 0;
            info[2] = AbstractLines.lengthToLineCount(this.lengthWithTabs(0), charsPerLine);
            return;
        }
        if (charsPerLine >= this.longestLineLen || this.getLineCount() < 1) {
            info[1] = 0;
            info[2] = 1;
            return;
        }
        int physLineIdx = Math.min(this.findPhysicalLine(logicalLineIdx, charsPerLine), this.getLineCount() - 1);
        int linesAbove = this.getLogicalLineCountAbove(physLineIdx, charsPerLine);
        int len = this.lengthWithTabs(physLineIdx);
        int wrapCount = AbstractLines.lengthToLineCount(len, charsPerLine);
        info[0] = physLineIdx;
        info[1] = logicalLineIdx - linesAbove;
        info[2] = wrapCount;
    }

    private int findPhysicalLine(int logicalLineIdx, int charsPerLine) {
        if (logicalLineIdx == 0) {
            return 0;
        }
        if (charsPerLine != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
            this.calcLogicalLineCount(charsPerLine);
        }
        return this.knownLogicalLineCounts.getNextKey(logicalLineIdx);
    }

    @Override
    public int getLogicalLineCountAbove(int line, int charsPerLine) {
        if (line == 0) {
            return 0;
        }
        if (charsPerLine >= this.longestLineLen) {
            return line;
        }
        if (charsPerLine != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
            this.calcLogicalLineCount(charsPerLine);
        }
        return this.knownLogicalLineCounts.get(line - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLogicalLineCountIfWrappedAt(int charsPerLine) {
        if (charsPerLine >= this.longestLineLen) {
            return this.getLineCount();
        }
        int lineCount = this.getLineCount();
        if (charsPerLine == 0 || lineCount == 0) {
            return 0;
        }
        Object object = this.readLock();
        synchronized (object) {
            if (charsPerLine != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
                this.calcLogicalLineCount(charsPerLine);
            }
            return this.knownLogicalLineCounts.get(lineCount - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumPhysicalChars(int offset, int logicalLength, int[] tabShiftPtr) {
        Object object = this.readLock();
        synchronized (object) {
            int i;
            int tabSum2;
            int tabIndex1 = this.tabCharOffsets.findNearest(offset);
            int tabSum1 = tabIndex1 > 0 ? (this.tabCharOffsets.get(tabIndex1) < offset ? this.tabLengthSums.get(tabIndex1) : this.tabLengthSums.get(tabIndex1 - 1)) : 0;
            int tabIndex2 = this.tabCharOffsets.findNearest(offset + logicalLength);
            if (tabIndex2 < 0) {
                return logicalLength;
            }
            int n = tabSum2 = tabIndex2 >= 0 ? this.tabLengthSums.get(tabIndex2) : 0;
            if (tabSum1 == tabSum2) {
                return logicalLength;
            }
            int realLength = logicalLength + tabSum1 - tabSum2;
            if (realLength < 0) {
                realLength = 0;
            }
            if ((tabIndex2 = this.tabCharOffsets.findNearest(i = offset + realLength)) < 0) {
                tabIndex2 = -1;
                tabSum2 = 0;
            } else {
                tabSum2 = this.tabLengthSums.get(tabIndex2);
            }
            int n2 = this.tabCharOffsets.size();
            ++tabIndex2;
            while (tabIndex2 < n2) {
                int nextTabOffset;
                if (realLength + tabSum2 - tabSum1 < logicalLength) {
                    nextTabOffset = this.tabCharOffsets.get(tabIndex2);
                    if (nextTabOffset - offset + (tabSum2 = this.tabLengthSums.get(tabIndex2)) - tabSum1 > logicalLength) {
                        tabSum2 = tabIndex2 > 0 ? this.tabLengthSums.get(tabIndex2 - 1) : 0;
                        realLength = logicalLength + tabSum1 - tabSum2;
                        if (realLength <= nextTabOffset - offset) break;
                        realLength = nextTabOffset - offset;
                        break;
                    }
                } else {
                    if (tabShiftPtr == null) break;
                    tabShiftPtr[0] = realLength + tabSum2 - tabSum1 - logicalLength;
                    break;
                }
                realLength = nextTabOffset - offset;
                ++tabIndex2;
            }
            if (realLength < 0) {
                realLength = 0;
            }
            return realLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumLogicalChars(int offset, int physicalLength) {
        Object object = this.readLock();
        synchronized (object) {
            int tabIndex1 = this.tabCharOffsets.findNearest(offset);
            int tabSum1 = tabIndex1 >= 0 && this.tabCharOffsets.get(tabIndex1) < offset ? this.tabLengthSums.get(tabIndex1) : (tabIndex1 > 0 ? this.tabLengthSums.get(tabIndex1 - 1) : 0);
            int tabIndex2 = this.tabCharOffsets.findNearest(offset + physicalLength - 1);
            if (tabIndex2 < 0) {
                return physicalLength;
            }
            int tabSum2 = this.tabLengthSums.get(tabIndex2);
            return physicalLength + tabSum2 - tabSum1;
        }
    }

    private void registerLineWithListener(int line, LineInfo info, boolean important) {
        this.lineWithListenerToInfo.put(line, info);
        if (important) {
            this.importantLines.add(line);
        }
    }

    @Override
    public int firstImportantListenerLine() {
        return this.importantLines.size() == 0 ? -1 : this.importantLines.get(0);
    }

    @Override
    public boolean isImportantLine(int line) {
        return this.importantLines.contains(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcLogicalLineCount(int width) {
        Object object = this.readLock();
        synchronized (object) {
            int lineCount = this.getLineCount();
            this.knownLogicalLineCounts = new SparseIntList(30);
            int val = 0;
            for (int i = 0; i < lineCount; ++i) {
                int len = this.lengthWithTabs(i);
                if (len > width) {
                    this.knownLogicalLineCounts.add(i, val += AbstractLines.lengthToLineCount(len, width));
                    continue;
                }
                ++val;
            }
            this.knownCharsPerLine = width;
        }
    }

    static int lengthToLineCount(int len, int charsPerLine) {
        return len > charsPerLine ? (charsPerLine == 0 ? len : (len + charsPerLine - 1) / charsPerLine) : 1;
    }

    void markDirty() {
        this.dirty = true;
    }

    boolean isLastLineFinished() {
        return this.lastLineFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastLine(int lineIdx, int lineLength) {
        Object object = this.readLock();
        synchronized (object) {
            boolean alreadyAdded;
            this.longestLineLen = Math.max(this.longestLineLen, lineLength);
            if (this.knownLogicalLineCounts == null) {
                return;
            }
            boolean bl = alreadyAdded = this.knownLogicalLineCounts.lastIndex() == lineIdx;
            if (alreadyAdded) {
                assert (!this.lastLineFinished);
                if (lineLength <= this.knownCharsPerLine) {
                    this.knownLogicalLineCounts.removeLast();
                } else {
                    int aboveLineCount = this.knownLogicalLineCounts.lastAdded() - AbstractLines.lengthToLineCount(this.lastCharLengthWithTabs, this.knownCharsPerLine) + AbstractLines.lengthToLineCount(lineLength, this.knownCharsPerLine);
                    this.knownLogicalLineCounts.updateLast(lineIdx, aboveLineCount);
                }
            } else {
                if (lineLength <= this.knownCharsPerLine) {
                    return;
                }
                int aboveLineCount = this.knownLogicalLineCounts.lastIndex() != -1 ? lineIdx - (this.knownLogicalLineCounts.lastIndex() + 1) + this.knownLogicalLineCounts.lastAdded() : Math.max(0, lineIdx - 1);
                this.knownLogicalLineCounts.add(lineIdx, aboveLineCount += AbstractLines.lengthToLineCount(lineLength, this.knownCharsPerLine));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineUpdated(int lineStart, int lineLength, int charLengthWithTabs, boolean isFinished) {
        Object object = this.readLock();
        synchronized (object) {
            int charLineLength = AbstractLines.toCharIndex(lineLength);
            if (isFinished) {
                --charLineLength;
            }
            this.updateLastLine(this.lineStartList.size() - 1, charLengthWithTabs);
            if (isFinished) {
                this.lineStartList.add(lineStart + lineLength);
                this.lineCharLengthListWithTabs.add(charLengthWithTabs);
            }
            this.lastLineFinished = isFinished;
            this.lastLineLength = isFinished ? -1 : charLineLength;
            this.lastCharLengthWithTabs = isFinished ? -1 : charLengthWithTabs;
        }
        this.markDirty();
    }

    static int toByteIndex(int charIndex) {
        return charIndex << 1;
    }

    static int toCharIndex(int byteIndex) {
        assert (byteIndex % 2 == 0) : "bad index: " + byteIndex;
        return byteIndex >> 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAs(String path) throws IOException {
        Storage storage = this.getStorage();
        if (storage == null) {
            throw new IOException("Data has already been disposed");
        }
        FileOutputStream fos = new FileOutputStream(path);
        try {
            String encoding = System.getProperty("file.encoding");
            if (encoding == null) {
                encoding = "UTF-8";
            }
            Charset charset = Charset.forName(encoding);
            CharsetEncoder encoder = charset.newEncoder();
            String ls = System.getProperty("line.separator");
            FileChannel ch = fos.getChannel();
            ByteBuffer lsbb = encoder.encode(CharBuffer.wrap(ls));
            for (int i = 0; i < this.getLineCount(); ++i) {
                int lineStart = this.getCharLineStart(i);
                int lineLength = this.length(i);
                CharBuffer cb = this.getCharBuffer(lineStart, lineLength);
                ByteBuffer bb = encoder.encode(cb);
                ch.write(bb);
                if (i == this.getLineCount() - 1) continue;
                lsbb.rewind();
                ch.write(lsbb);
            }
            ch.close();
        }
        catch (Throwable throwable) {
            fos.close();
            FileUtil.refreshFor((File[])new File[]{new File(path)});
            throw throwable;
        }
        fos.close();
        FileUtil.refreshFor((File[])new File[]{new File(path)});
    }

    @Override
    public void setDefColor(IOColors.OutputType type, Color color) {
        this.curDefColors[type.ordinal()] = color;
    }

    @Override
    public Color getDefColor(IOColors.OutputType type) {
        return this.curDefColors[type.ordinal()];
    }

    @Override
    public LineInfo getLineInfo(int line) {
        LineInfo info = (LineInfo)this.linesToInfos.get(line);
        if (info != null) {
            int lineLength = this.length(line);
            if (lineLength > info.getEnd()) {
                info.addSegment(lineLength, false, null, null, false);
            }
            return info;
        }
        return new LineInfo(this, this.length(line));
    }

    public LineInfo getExistingLineInfo(int line) {
        return (LineInfo)this.linesToInfos.get(line);
    }

    private boolean regExpChanged(String pattern, boolean matchCase) {
        return this.pattern != null && (!this.pattern.toString().equals(pattern) || this.pattern.flags() == 2 == matchCase);
    }

    @Override
    public int[] find(int start, String pattern, boolean regExp, boolean matchCase) {
        Storage storage = this.getStorage();
        if (storage == null) {
            return null;
        }
        if (regExp && this.regExpChanged(pattern, matchCase)) {
            this.pattern = null;
        }
        if (!regExp && !matchCase) {
            pattern = pattern.toLowerCase();
        }
        while (true) {
            int size;
            if ((size = this.getCharCount() - start) > 16384) {
                int l = this.getLineAt(start + 16384);
                size = this.getLineStart(l) + this.length(l) - start;
            } else if (size <= 0) break;
            CharBuffer buff = null;
            try {
                buff = storage.getReadBuffer(AbstractLines.toByteIndex(start), AbstractLines.toByteIndex(size)).asCharBuffer();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (buff == null) break;
            if (regExp) {
                Matcher matcher;
                if (this.pattern == null) {
                    Pattern pattern2 = this.pattern = matchCase ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
                }
                if ((matcher = this.pattern.matcher(buff)).find()) {
                    return new int[]{start + matcher.start(), start + matcher.end()};
                }
            } else {
                int idx;
                int n = idx = matchCase ? buff.toString().indexOf(pattern) : buff.toString().toLowerCase().indexOf(pattern);
                if (idx != -1) {
                    return new int[]{start + idx, start + idx + pattern.length()};
                }
            }
            start += buff.length();
        }
        return null;
    }

    @Override
    public int[] rfind(int start, String pattern, boolean regExp, boolean matchCase) {
        block11: {
            int idx;
            Storage storage = this.getStorage();
            if (storage == null) {
                return null;
            }
            if (regExp && this.regExpChanged(pattern, matchCase)) {
                this.pattern = null;
            }
            if (!regExp && !matchCase) {
                pattern = pattern.toLowerCase();
            }
            while (true) {
                int end;
                if ((start = (end = start) - 16384) < 0) {
                    start = 0;
                } else {
                    int l = this.getLineAt(start);
                    start = this.getLineStart(l);
                }
                if (start == end) break block11;
                CharBuffer buff = null;
                try {
                    buff = storage.getReadBuffer(AbstractLines.toByteIndex(start), AbstractLines.toByteIndex(end - start)).asCharBuffer();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (buff == null) break block11;
                if (regExp) {
                    if (this.pattern == null) {
                        this.pattern = matchCase ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
                    }
                    Matcher matcher = this.pattern.matcher(buff);
                    int mStart = -1;
                    int mEnd = -1;
                    while (matcher.find()) {
                        mStart = matcher.start();
                        mEnd = matcher.end();
                    }
                    if (mStart == -1) continue;
                    return new int[]{start + mStart, start + mEnd};
                }
                idx = matchCase ? buff.toString().lastIndexOf(pattern) : buff.toString().toLowerCase().lastIndexOf(pattern);
                if (idx != -1) break;
            }
            return new int[]{start + idx, start + idx + pattern.length()};
        }
        return null;
    }

    public String toString() {
        return this.lineStartList.toString();
    }

    private int addSegment(CharSequence s, int offset, int lineIdx, int pos, OutputListener l, boolean important, boolean err, Color c) {
        int len = this.length(lineIdx);
        if (len > 0) {
            LineInfo info = (LineInfo)this.linesToInfos.get(lineIdx);
            if (info == null) {
                info = new LineInfo(this);
                this.linesToInfos.put(lineIdx, info);
            }
            int curEnd = info.getEnd();
            if (pos > 0 && pos != curEnd) {
                info.addSegment(pos, false, null, null, false);
                curEnd = pos;
            }
            if (l != null) {
                int trailingCnt;
                int endPos = Math.min(curEnd + s.length() - offset, len);
                int strlen = Math.min(s.length(), offset + len);
                if (s.charAt(strlen - 1) == '\n') {
                    --strlen;
                }
                if (s.charAt(strlen - 1) == '\r') {
                    --strlen;
                }
                int leadingCnt = 0;
                while (leadingCnt + offset < strlen && Character.isWhitespace(s.charAt(offset + leadingCnt))) {
                    ++leadingCnt;
                }
                if (leadingCnt != strlen) {
                    for (trailingCnt = 0; trailingCnt < strlen && Character.isWhitespace(s.charAt(strlen - trailingCnt - 1)); ++trailingCnt) {
                    }
                }
                if (leadingCnt > 0) {
                    info.addSegment(curEnd + leadingCnt, false, null, null, false);
                }
                info.addSegment(endPos - trailingCnt, err, l, c, important);
                if (trailingCnt > 0) {
                    info.addSegment(endPos, false, null, null, false);
                }
                this.registerLineWithListener(lineIdx, info, important);
            } else {
                info.addSegment(len, err, l, c, important);
                if (important) {
                    this.importantLines.add(lineIdx);
                }
            }
        }
        return len;
    }

    void updateLinesInfo(CharSequence s, int startLine, int startPos, OutputListener l, boolean important, boolean err, Color c) {
        int offset = 0;
        int startLinePos = startPos - this.getLineStart(startLine);
        for (int i = startLine; i < this.getLineCount(); ++i) {
            offset += this.addSegment(s, offset, i, startLinePos, l, important, err, c) + 1;
            startLinePos = 0;
        }
    }

    void addLineInfo(int idx, LineInfo info, boolean important) {
        this.linesToInfos.put(idx, info);
        if (!info.getListeners().isEmpty()) {
            this.registerLineWithListener(idx, info, important);
        }
    }

    private int getTabLength(int i) {
        if (i == 0) {
            return this.tabLengthSums.get(0);
        }
        return this.tabLengthSums.get(i) - this.tabLengthSums.get(i - 1) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTabAt(int i, int tabLength) {
        --tabLength;
        Object object = this.readLock();
        synchronized (object) {
            this.tabCharOffsets.add(i);
            int n = this.tabLengthSums.size();
            if (n > 0) {
                tabLength += this.tabLengthSums.get(n - 1);
            }
            this.tabLengthSums.add(tabLength);
        }
    }

    static {
        Color hyperlinkImp;
        Color hyperlink;
        Color err;
        Color out = UIManager.getColor("nb.output.foreground");
        if (out == null && (out = UIManager.getColor("textText")) == null) {
            out = Color.BLACK;
        }
        if ((err = UIManager.getColor("nb.output.err.foreground")) == null) {
            err = new Color(164, 0, 0);
        }
        if ((hyperlink = UIManager.getColor("nb.output.link.foreground")) == null) {
            hyperlink = Color.BLUE.darker();
        }
        if ((hyperlinkImp = UIManager.getColor("nb.output.link.foreground.important")) == null) {
            hyperlinkImp = hyperlink;
        }
        DEF_COLORS = new Color[]{out, err, hyperlink, hyperlinkImp};
    }
}

