/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.TextDetail;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

final class MatchingObject
implements Comparable<MatchingObject>,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(MatchingObject.class.getName());
    private final ResultModel resultModel;
    private final FileObject fileObject;
    private final long timestamp;
    private final Object object;
    private final Charset charset;
    private boolean selected = true;
    private boolean expanded = false;
    private boolean[] matchesSelection;
    private int selectedMatchesCount;
    private boolean childrenSelectionDirty;
    private boolean valid = true;
    private StringBuilder text;
    private static final boolean REALLY_WRITE = true;

    MatchingObject(ResultModel resultModel, Object object, Charset charset) {
        if (resultModel == null) {
            throw new IllegalArgumentException("resultModel = null");
        }
        if (object == null) {
            throw new IllegalArgumentException("object = null");
        }
        this.resultModel = resultModel;
        this.object = object;
        this.charset = charset;
        this.fileObject = this.fileObject();
        this.timestamp = this.fileObject.lastModified().getTime();
        this.valid = this.timestamp != 0L;
        this.setUpDataObjValidityChecking();
    }

    private void setUpDataObjValidityChecking() {
        DataObject dataObj = this.getDataObject();
        if (dataObj != null && dataObj.isValid()) {
            dataObj.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    void cleanup() {
        DataObject dataObj = this.getDataObject();
        if (dataObj != null) {
            dataObj.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("valid".equals(e.getPropertyName()) && Boolean.FALSE.equals(e.getNewValue())) {
            DataObject dataObject = this.getDataObject();
            if (dataObject != null) {
                assert (e.getSource() == dataObject);
                dataObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.resultModel.objectBecameInvalid(this);
        }
    }

    boolean isObjectValid() {
        DataObject data = this.getDataObject();
        return this.valid && data != null ? data.isValid() : false;
    }

    private FileObject fileObject() {
        return this.object instanceof FileObject ? (FileObject)this.object : this.getDataObject().getPrimaryFile();
    }

    FileObject getFileObject() {
        return this.fileObject;
    }

    void setSelected(boolean selected) {
        if (selected == this.selected) {
            return;
        }
        this.selected = selected;
        this.matchesSelection = null;
    }

    boolean isSelected() {
        return this.selected;
    }

    boolean isUniformSelection() {
        return this.matchesSelection == null;
    }

    Boolean checkSubnodesSelection() {
        if (this.matchesSelection == null) {
            return this.selected;
        }
        boolean firstMatchSelection = this.matchesSelection[0];
        for (int i = 1; i < this.matchesSelection.length; ++i) {
            if (this.matchesSelection[i] == firstMatchSelection) continue;
            return null;
        }
        return firstMatchSelection;
    }

    boolean toggleSubnodeSelection(ResultModel resultModel, int index) {
        if (this.matchesSelection == null) {
            int detailsCount = resultModel.getDetailsCount(this);
            if (detailsCount == 1) {
                this.selected = !this.selected;
                return true;
            }
            this.matchesSelection = new boolean[detailsCount];
            Arrays.fill(this.matchesSelection, this.selected);
            this.matchesSelection[index] = !this.selected;
            boolean wasSelected = this.selected;
            this.selectedMatchesCount = wasSelected ? detailsCount - 1 : 1;
            this.selected = true;
            return this.selected != wasSelected;
        }
        assert (this.selected);
        assert (this.selectedMatchesCount > 0 && this.selectedMatchesCount < this.matchesSelection.length);
        boolean wasSubnodeSelected = this.matchesSelection[index];
        if (wasSubnodeSelected) {
            if (--this.selectedMatchesCount == 0) {
                this.matchesSelection = null;
                this.selected = false;
                return true;
            }
        } else if (++this.selectedMatchesCount == this.matchesSelection.length) {
            this.matchesSelection = null;
            return false;
        }
        this.matchesSelection[index] = !wasSubnodeSelected;
        return false;
    }

    boolean isSubnodeSelected(int index) {
        if (this.matchesSelection == null) {
            return this.selected;
        }
        if (index >= 0 && index < this.matchesSelection.length) {
            return this.matchesSelection[index];
        }
        LOG.log(Level.FINE, "Illegal index={0} in the case matchesSelection.length={1}", new Object[]{index, this.matchesSelection.length});
        return false;
    }

    void markChildrenSelectionDirty() {
        this.childrenSelectionDirty = true;
    }

    void markChildrenSelectionClean() {
        this.childrenSelectionDirty = false;
    }

    boolean isChildrenSelectionDirty() {
        return this.childrenSelectionDirty;
    }

    void markExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    boolean isExpanded() {
        return this.expanded;
    }

    String getName() {
        return this.getFileObject().getNameExt();
    }

    String getHtmlDisplayName() {
        String name = null;
        if (this.object instanceof FileObject) {
            return this.getFileObject().getNameExt();
        }
        DataObject data = this.getDataObject();
        if (data != null) {
            name = data.getNodeDelegate().getHtmlDisplayName();
        }
        return name;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    String getDescription() {
        return this.getFileObject().getParent().getPath();
    }

    String getText() throws IOException {
        StringBuilder txt = this.text(false);
        return txt != null ? txt.toString() : null;
    }

    FileLock lock() throws IOException {
        return this.getFileObject().lock();
    }

    private StringBuilder text(boolean refreshCache) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (refreshCache || this.text == null) {
            this.text = new StringBuilder(this.charset == null ? this.getFileObject().asText() : this.getFileObject().asText(this.charset.name()));
        }
        return this.text;
    }

    @Override
    public int compareTo(MatchingObject o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public DataObject getDataObject() {
        try {
            if (this.object instanceof DataObject) {
                return (DataObject)this.object;
            }
            if (this.object instanceof FileObject) {
                return DataObject.find((FileObject)((FileObject)this.object));
            }
            throw new IOException("Unknown object in search: " + this.object);
        }
        catch (IOException ex) {
            this.valid = false;
            return null;
        }
    }

    InvalidityStatus checkValidity() {
        InvalidityStatus status = this.getInvalidityStatus();
        if (status != null) {
            this.valid = false;
        }
        return status;
    }

    String getInvalidityDescription() {
        InvalidityStatus status = this.getInvalidityStatus();
        String descr = status != null ? status.getDescription(this.getFileObject().getPath()) : null;
        return descr;
    }

    private InvalidityStatus getInvalidityStatus() {
        this.log(Level.FINER, "getInvalidityStatus()");
        FileObject f = this.getFileObject();
        if (!f.isValid()) {
            this.log(Level.FINEST, " - DELETED");
            return InvalidityStatus.DELETED;
        }
        if (f.isFolder()) {
            this.log(Level.FINEST, " - BECAME_DIR");
            return InvalidityStatus.BECAME_DIR;
        }
        long stamp = f.lastModified().getTime();
        if (stamp > this.resultModel.getCreationTime()) {
            this.log(Level.SEVERE, "file's timestamp changed since start of the search");
            if (LOG.isLoggable(Level.FINEST)) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(stamp);
                this.log(Level.FINEST, " - file stamp:           " + stamp + " (" + cal.getTime() + ')');
                cal.setTimeInMillis(this.resultModel.getCreationTime());
                this.log(Level.FINEST, " - result model created: " + this.resultModel.getCreationTime() + " (" + cal.getTime() + ')');
            }
            return InvalidityStatus.CHANGED;
        }
        if (f.getSize() > Integer.MAX_VALUE) {
            return InvalidityStatus.TOO_BIG;
        }
        if (!f.canRead()) {
            return InvalidityStatus.CANT_READ;
        }
        return null;
    }

    boolean isValid() {
        return this.valid;
    }

    public InvalidityStatus replace() throws IOException {
        boolean shouldReplaceNone;
        assert (!EventQueue.isDispatchThread());
        assert (this.isSelected());
        Boolean uniformSelection = this.checkSubnodesSelection();
        boolean bl = shouldReplaceNone = uniformSelection == Boolean.FALSE;
        if (shouldReplaceNone) {
            return null;
        }
        StringBuilder content = this.text(true);
        List<TextDetail> textMatches = this.resultModel.basicCriteria.getTextDetails(this.getFileObject());
        int offsetShift = 0;
        for (int i = 0; i < textMatches.size(); ++i) {
            if (this.matchesSelection != null && !this.matchesSelection[i]) continue;
            TextDetail textDetail = textMatches.get(i);
            String matchedSubstring = content.substring(textDetail.getStartOffset() + offsetShift, textDetail.getEndOffset() + offsetShift);
            if (!matchedSubstring.equals(textDetail.getMatchedText())) {
                this.log(Level.SEVERE, "file match part differs from the expected match");
                if (LOG.isLoggable(Level.FINEST)) {
                    this.log(Level.SEVERE, " - expected line: \"" + textDetail.getMatchedText() + '\"');
                    this.log(Level.SEVERE, " - file line:     \"" + matchedSubstring + '\"');
                }
                return InvalidityStatus.CHANGED;
            }
            String replacedString = this.resultModel.basicCriteria.getReplaceExpr();
            if (this.resultModel.basicCriteria.isRegexp()) {
                Matcher m = this.resultModel.basicCriteria.getTextPattern().matcher(matchedSubstring);
                replacedString = m.replaceFirst(this.resultModel.basicCriteria.getReplaceString());
            }
            content.replace(textDetail.getStartOffset() + offsetShift, textDetail.getEndOffset() + offsetShift, replacedString);
            offsetShift += replacedString.length() - matchedSubstring.length();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(FileLock fileLock) throws IOException {
        if (this.text == null) {
            throw new IllegalStateException("Buffer is gone");
        }
        Writer writer = null;
        try {
            writer = new OutputStreamWriter(this.fileObject.getOutputStream(fileLock), this.charset);
            writer.write(this.makeStringToWrite());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String makeStringToWrite() {
        return MatchingObject.makeStringToWrite(this.text);
    }

    static String makeStringToWrite(StringBuilder text) {
        return text.toString();
    }

    private void log(Level logLevel, String msg) {
        String id;
        String string = id = this.getDataObject() instanceof DataObject ? this.getDataObject().getName() : this.getDataObject().toString();
        if (LOG.isLoggable(logLevel)) {
            LOG.log(logLevel, "{0}: {1}", new Object[]{id, msg});
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatchingObject other = (MatchingObject)obj;
        return this.fileObject == other.fileObject || this.fileObject != null && this.fileObject.equals(other.fileObject);
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + (this.fileObject != null ? this.fileObject.hashCode() : 0);
        return hash;
    }

    static enum InvalidityStatus {
        DELETED(true, "Inv_status_Err_deleted"),
        BECAME_DIR(true, "Inv_status_Err_became_dir"),
        CHANGED(false, "Inv_status_Err_changed"),
        TOO_BIG(false, "Inv_status_Err_too_big"),
        CANT_READ(false, "Inv_status_Err_cannot_read");

        private final boolean fatal;
        private final String descrBundleKey;

        private InvalidityStatus(boolean fatal, String descrBundleKey) {
            this.fatal = fatal;
            this.descrBundleKey = descrBundleKey;
        }

        boolean isFatal() {
            return this.fatal;
        }

        String getDescription(String path) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.descrBundleKey, (Object)path);
        }
    }
}

