/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolProvider {
    private static final String propertyName = "sun.tools.ToolProvider";
    private static final String loggerName = "javax.tools";
    private static final String defaultJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
    private static ToolProvider instance;
    private Map<String, Reference<Class<?>>> toolClasses = new HashMap();
    private Reference<ClassLoader> refToolClassLoader = null;
    private static final String[] defaultToolsLocation;

    static <T> T trace(Level level, Object reason) {
        try {
            if (System.getProperty(propertyName) != null) {
                StackTraceElement[] st = Thread.currentThread().getStackTrace();
                String method = "???";
                String cls = ToolProvider.class.getName();
                if (st.length > 2) {
                    StackTraceElement frame = st[2];
                    method = String.format((Locale)null, "%s(%s:%s)", frame.getMethodName(), frame.getFileName(), frame.getLineNumber());
                    cls = frame.getClassName();
                }
                Logger logger = Logger.getLogger(loggerName);
                if (reason instanceof Throwable) {
                    logger.logp(level, cls, method, reason.getClass().getName(), (Throwable)reason);
                } else {
                    logger.logp(level, cls, method, String.valueOf(reason));
                }
            }
        }
        catch (SecurityException ex) {
            System.err.format((Locale)null, "%s: %s; %s%n", ToolProvider.class.getName(), reason, ex.getLocalizedMessage());
        }
        return null;
    }

    public static JavaCompiler getSystemJavaCompiler() {
        return ToolProvider.instance().getSystemTool(JavaCompiler.class, defaultJavaCompilerName);
    }

    public static ClassLoader getSystemToolClassLoader() {
        try {
            Class<JavaCompiler> c = ToolProvider.instance().getSystemToolClass(JavaCompiler.class, defaultJavaCompilerName);
            return c.getClassLoader();
        }
        catch (Throwable e) {
            return (ClassLoader)ToolProvider.trace(Level.WARNING, e);
        }
    }

    private static synchronized ToolProvider instance() {
        if (instance == null) {
            instance = new ToolProvider();
        }
        return instance;
    }

    private ToolProvider() {
    }

    private <T> T getSystemTool(Class<T> clazz, String name) {
        Class<T> c = this.getSystemToolClass(clazz, name);
        try {
            return c.asSubclass(clazz).newInstance();
        }
        catch (Throwable e) {
            ToolProvider.trace(Level.WARNING, e);
            return null;
        }
    }

    private <T> Class<? extends T> getSystemToolClass(Class<T> clazz, String name) {
        Class<?> c;
        Reference<Class<?>> refClass = this.toolClasses.get(name);
        Class<?> clazz2 = c = refClass == null ? null : refClass.get();
        if (c == null) {
            try {
                c = this.findSystemToolClass(name);
            }
            catch (Throwable e) {
                return (Class)ToolProvider.trace(Level.WARNING, e);
            }
            this.toolClasses.put(name, new WeakReference(c));
        }
        return c.asSubclass(clazz);
    }

    private Class<?> findSystemToolClass(String toolClassName) throws MalformedURLException, ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return Class.forName(toolClassName, false, cl);
        }
        catch (ClassNotFoundException e) {
            ClassLoader cl;
            ToolProvider.trace(Level.FINE, e);
            ClassLoader classLoader = cl = this.refToolClassLoader == null ? null : this.refToolClassLoader.get();
            if (cl == null) {
                File file = new File(System.getProperty("java.home"));
                if (file.getName().equalsIgnoreCase("jre")) {
                    file = file.getParentFile();
                }
                for (String name : defaultToolsLocation) {
                    file = new File(file, name);
                }
                if (!file.exists()) {
                    throw e;
                }
                URL[] urls = new URL[]{file.toURI().toURL()};
                ToolProvider.trace(Level.FINE, urls[0].toString());
                cl = URLClassLoader.newInstance(urls);
                this.refToolClassLoader = new WeakReference<ClassLoader>(cl);
            }
            return Class.forName(toolClassName, false, cl);
        }
    }

    static {
        defaultToolsLocation = new String[]{"lib", "tools.jar"};
    }
}

