/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.openide.util.Parameters;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean hasText(String input) {
        return input != null && input.trim().length() > 0;
    }

    public static String implode(List<String> items, String delimiter) {
        Parameters.notNull((CharSequence)"items", items);
        Parameters.notNull((CharSequence)"delimiter", (Object)delimiter);
        if (items.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(200);
        boolean first = true;
        for (String s : items) {
            if (!first) {
                buffer.append(delimiter);
            }
            buffer.append(s);
            first = false;
        }
        return buffer.toString();
    }

    public static List<String> explode(String string, String delimiter) {
        Parameters.notNull((CharSequence)"delimiter", (Object)delimiter);
        if (!StringUtils.hasText(string)) {
            return Collections.emptyList();
        }
        return Arrays.asList(string.split(Pattern.quote(delimiter)));
    }

    public static Pattern getPattern(String text) {
        Parameters.notNull((CharSequence)"text", (Object)text);
        return StringUtils.getPattern0(text, ".*", ".*");
    }

    public static Pattern getExactPattern(String text) {
        Parameters.notNull((CharSequence)"text", (Object)text);
        return StringUtils.getPattern0(text, "^", "$");
    }

    private static Pattern getPattern0(String text, String prefix, String suffix) {
        assert (text != null);
        assert (prefix != null);
        assert (suffix != null);
        if (text.contains("?") || text.contains("*")) {
            String pattern = text.replace("\\", "").replace(".", "\\.").replace("-", "\\-").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("?", ".").replace("*", ".*");
            return Pattern.compile(prefix + pattern + suffix, 2);
        }
        return null;
    }
}

