/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.phpmodule;

import java.util.prefs.Preferences;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public abstract class PhpModule {
    public abstract String getName();

    public abstract String getDisplayName();

    public abstract FileObject getSourceDirectory();

    public abstract FileObject getTestDirectory();

    public abstract PhpModuleProperties getProperties();

    public abstract Preferences getPreferences(Class<?> var1, boolean var2);

    public static PhpModule forFileObject(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return null;
        }
        return PhpModule.lookupPhpModule(project);
    }

    public static PhpModule inferPhpModule() {
        Lookup globalContext;
        PhpModule result;
        Node[] activatedNodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        if (activatedNodes != null) {
            for (Node n : activatedNodes) {
                PhpModule result2 = PhpModule.lookupPhpModule(n.getLookup());
                if (result2 == null) continue;
                return result2;
            }
        }
        if ((result = PhpModule.lookupPhpModule(globalContext = Utilities.actionsGlobalContext())) != null) {
            return result;
        }
        FileObject fo = (FileObject)globalContext.lookup(FileObject.class);
        if (fo != null && (result = PhpModule.forFileObject(fo)) != null) {
            return result;
        }
        OpenProjects projects = OpenProjects.getDefault();
        Project mainProject = projects.getMainProject();
        if (mainProject != null && (result = PhpModule.lookupPhpModule(mainProject)) != null) {
            return result;
        }
        for (Project project : projects.getOpenProjects()) {
            result = PhpModule.lookupPhpModule(project);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static PhpModule lookupPhpModule(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return PhpModule.lookupPhpModule(project.getLookup());
    }

    public static PhpModule lookupPhpModule(Lookup lookup) {
        Parameters.notNull((CharSequence)"lookup", (Object)lookup);
        PhpModule result = (PhpModule)lookup.lookup(PhpModule.class);
        if (result != null) {
            return result;
        }
        Project project = (Project)lookup.lookup(Project.class);
        if (project != null && (result = (PhpModule)project.getLookup().lookup(PhpModule.class)) != null) {
            return result;
        }
        return null;
    }

    public static enum Change {
        SOURCES_CHANGE,
        TESTS_CHANGE,
        SELENIUM_CHANGE,
        IGNORED_FILES_CHANGE;

    }
}

