/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.api.EditableManifest;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.RetoucheUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NbMoveRefactoringPlugin
extends AbstractRefactoringPlugin {
    protected static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.refactoring");
    private static ThreadLocal semafor = new ThreadLocal();
    private Collection manifestRefactorings;
    private boolean firstManifestRefactoring = true;
    private HashMap oldManifests;
    private EditableManifest targetManifest;
    private Map packagePostfix = new HashMap();
    ArrayList<FileObject> filesToMove = new ArrayList();
    HashMap<FileObject, ElementHandle> classes;

    public NbMoveRefactoringPlugin(MoveRefactoring move) {
        super((AbstractRefactoring)move);
        this.manifestRefactorings = new ArrayList();
        this.oldManifests = new HashMap();
        this.setup(move.getRefactoringSource().lookupAll(FileObject.class), "", true);
    }

    public NbMoveRefactoringPlugin(RenameRefactoring rename) {
        super((AbstractRefactoring)rename);
        FileObject fo = (FileObject)rename.getRefactoringSource().lookup(FileObject.class);
        if (fo != null) {
            this.setup(Collections.singletonList(fo), "", true);
        } else {
            this.setup(Collections.singletonList(((NonRecursiveFolder)rename.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder()), "", false);
        }
    }

    @Override
    public Problem preCheck() {
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        Problem problem = null;
        try {
            this.initClasses();
            Object cachedProject = null;
            Object cachedManifest = null;
            Lookup lkp = this.refactoring.getRefactoringSource();
            TreePathHandle handle = (TreePathHandle)lkp.lookup(TreePathHandle.class);
            if (handle != null) {
                AbstractRefactoringPlugin.InfoHolder infoholder = this.examineLookup(lkp);
                Project project = FileOwnerQuery.getOwner((FileObject)handle.getFileObject());
                if (project == null || project.getLookup().lookup(NbModuleProvider.class) == null) {
                    Problem problem2 = null;
                    return problem2;
                }
                if (infoholder.isClass) {
                    this.checkManifest(project, infoholder.fullName, refactoringElements);
                    this.checkLayer(project, infoholder.fullName, refactoringElements);
                }
                if (infoholder.isMethod) {
                    this.checkMethodLayer(infoholder, handle.getFileObject(), refactoringElements);
                }
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            semafor.set(null);
        }
        return problem;
    }

    @Override
    protected RefactoringElementImplementation createManifestRefactoring(String fqname, FileObject manifestFile, String attributeKey, String attributeValue, String section) {
        return null;
    }

    private static String findPackageName(Project project, FileObject fo) {
        Sources srcs = ProjectUtils.getSources((Project)project);
        SourceGroup[] grps = srcs.getSourceGroups("java");
        for (int i = 0; i < grps.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)grps[i].getRootFolder(), (FileObject)fo) || !grps[i].contains(fo)) continue;
            return FileUtil.getRelativePath((FileObject)grps[i].getRootFolder(), (FileObject)fo);
        }
        return null;
    }

    private void setup(Collection fileObjects, String postfix, boolean recursively) {
        for (FileObject fo : fileObjects) {
            if (RetoucheUtils.isJavaFile(fo)) {
                this.packagePostfix.put(fo, postfix.replace('/', '.'));
                this.filesToMove.add(fo);
                continue;
            }
            if (!fo.isFolder()) {
                this.packagePostfix.put(fo, postfix.replace('/', '.'));
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(fo)) continue;
            boolean addDot = !"".equals(postfix);
            ArrayList<FileObject> col = new ArrayList<FileObject>();
            for (FileObject fo2 : fo.getChildren()) {
                col.add(fo2);
            }
            if (!recursively) continue;
            this.setup(col, postfix + (addDot ? "." : "") + fo.getName(), true);
        }
    }

    String getNewPackageName() {
        if (this.refactoring instanceof MoveRefactoring) {
            return RetoucheUtils.getPackageName((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
        }
        return ((RenameRefactoring)this.refactoring).getNewName();
    }

    String getTargetPackageName(FileObject fo) {
        if (this.refactoring instanceof RenameRefactoring) {
            if (this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null) {
                return this.getNewPackageName();
            }
            FileObject folder = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
            FileObject root = cp.findOwnerRoot(folder);
            String prefix = FileUtil.getRelativePath((FileObject)root, (FileObject)folder.getParent()).replace('/', '.');
            String postfix = FileUtil.getRelativePath((FileObject)folder, (FileObject)fo.getParent()).replace('/', '.');
            String t = this.concat(prefix, this.getNewPackageName(), postfix);
            return t;
        }
        if (this.packagePostfix != null) {
            String postfix = (String)this.packagePostfix.get(fo);
            String packageName = this.concat(null, this.getNewPackageName(), postfix);
            return packageName;
        }
        return this.getNewPackageName();
    }

    private String concat(String s1, String s2, String s3) {
        String result = "";
        if (s1 != null && !"".equals(s1)) {
            result = result + s1 + ".";
        }
        result = result + s2;
        if (s3 != null && !"".equals(s3)) {
            result = result + ("".equals(result) ? "" : ".") + s3;
        }
        return result;
    }

    private void initClasses() {
        this.classes = new HashMap();
        for (int i = 0; i < this.filesToMove.size(); ++i) {
            final int j = i;
            try {
                JavaSource source = JavaSource.forFileObject((FileObject)this.filesToMove.get(i));
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void run(CompilationController parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        List<? extends Tree> trees = parameter.getCompilationUnit().getTypeDecls();
                        for (Tree tree : trees) {
                            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !((ClassTree)tree).getSimpleName().toString().equals(NbMoveRefactoringPlugin.this.filesToMove.get(j).getName())) continue;
                            NbMoveRefactoringPlugin.this.classes.put(NbMoveRefactoringPlugin.this.filesToMove.get(j), ElementHandle.create((Element)parameter.getTrees().getElement(TreePath.getPath(parameter.getCompilationUnit(), tree))));
                            return;
                        }
                    }
                }, true);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public final class ManifestMoveRefactoringElement
    extends AbstractRefactoringElement {
        private String clazz;
        private String attrName;
        private String sectionName;
        private FileObject movedFile;

        public ManifestMoveRefactoringElement(String clazz, FileObject parentFile, String attributeValue, String attributeName) {
            super(parentFile);
            this.sectionName = null;
            this.movedFile = null;
            this.name = attributeValue;
            this.clazz = clazz;
            this.attrName = attributeName;
        }

        public ManifestMoveRefactoringElement(String clazz, FileObject parentFile, String attributeValue, String attributeName, String secName) {
            this(clazz, parentFile, attributeValue, attributeName);
            this.sectionName = secName;
        }

        public ManifestMoveRefactoringElement(FileObject parentFile, String attributeValue, String attributeName, FileObject movedFile) {
            super(parentFile);
            this.sectionName = null;
            this.movedFile = null;
            this.name = attributeValue;
            this.attrName = attributeName;
            this.movedFile = movedFile;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage(NbMoveRefactoringPlugin.class, (String)"TXT_ManifestSectionRename", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage(NbMoveRefactoringPlugin.class, (String)"TXT_ManifestRename", (Object)this.name, (Object)this.attrName);
        }

        @Override
        public void performChange() {
        }
    }
}

