/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.indexing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.netbeans.lib.editor.util.CharSubSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.css.gsf.CssGSFParser;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.indexing.CssIndex;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.css.parser.Token;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class CssFileModel {
    private static final Logger LOGGER = Logger.getLogger(CssIndex.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final Pattern URI_PATTERN = Pattern.compile("url\\(\\s*(.*)\\s*\\)");
    private Collection<Entry> classes;
    private Collection<Entry> ids;
    private Collection<Entry> htmlElements;
    private Collection<Entry> imports;
    private Collection<Entry> colors;
    private final Snapshot snapshot;
    private final Snapshot topLevelSnapshot;
    private SimpleNode parseTreeRoot;

    public static CssFileModel create(Source source) throws ParseException {
        final AtomicReference result = new AtomicReference();
        final AtomicReference snapshot = new AtomicReference();
        ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                ResultIterator cssRi = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/x-css");
                snapshot.set(resultIterator.getSnapshot());
                result.set(cssRi == null ? null : (CssParserResult)cssRi.getParserResult());
            }
        });
        assert (snapshot.get() != null);
        return result.get() == null ? new CssFileModel((Snapshot)snapshot.get()) : new CssFileModel((CssParserResult)((Object)result.get()), (Snapshot)snapshot.get());
    }

    public static CssFileModel create(CssParserResult result) {
        return new CssFileModel(result, null);
    }

    private CssFileModel(Snapshot topLevelSnapshot) {
        this.snapshot = this.topLevelSnapshot = topLevelSnapshot;
    }

    private CssFileModel(CssParserResult parserResult, Snapshot topLevelSnapshot) {
        this.snapshot = parserResult.getSnapshot();
        this.parseTreeRoot = parserResult.root();
        this.topLevelSnapshot = topLevelSnapshot;
        if (this.parseTreeRoot != null) {
            SimpleNodeUtil.visitChildren(this.parseTreeRoot, new AstVisitor());
        }
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public Snapshot getTopLevelSnapshot() {
        return this.topLevelSnapshot;
    }

    public FileObject getFileObject() {
        return this.getSnapshot().getSource().getFileObject();
    }

    public Collection<Entry> get(RefactoringElementType type) {
        switch (type) {
            case CLASS: {
                return this.getClasses();
            }
            case ID: {
                return this.getIds();
            }
            case COLOR: {
                return this.getColors();
            }
            case ELEMENT: {
                return this.htmlElements;
            }
            case IMPORT: {
                return this.imports;
            }
        }
        return null;
    }

    public Collection<Entry> getClasses() {
        return this.classes == null ? Collections.emptyList() : this.classes;
    }

    public Collection<Entry> getIds() {
        return this.ids == null ? Collections.emptyList() : this.ids;
    }

    public Collection<Entry> getHtmlElements() {
        return this.htmlElements == null ? Collections.emptyList() : this.htmlElements;
    }

    public Collection<Entry> getImports() {
        return this.imports == null ? Collections.emptyList() : this.imports;
    }

    public Collection<Entry> getColors() {
        return this.colors == null ? Collections.emptyList() : this.colors;
    }

    public boolean isEmpty() {
        return null == this.classes && null == this.ids && null == this.htmlElements && null == this.imports && null == this.colors;
    }

    private Collection<Entry> getClassesCollectionInstance() {
        if (this.classes == null) {
            this.classes = new ArrayList<Entry>();
        }
        return this.classes;
    }

    private Collection<Entry> getIdsCollectionInstance() {
        if (this.ids == null) {
            this.ids = new ArrayList<Entry>();
        }
        return this.ids;
    }

    private Collection<Entry> getHtmlElementsCollectionInstance() {
        if (this.htmlElements == null) {
            this.htmlElements = new ArrayList<Entry>();
        }
        return this.htmlElements;
    }

    private Collection<Entry> getImportsCollectionInstance() {
        if (this.imports == null) {
            this.imports = new ArrayList<Entry>();
        }
        return this.imports;
    }

    private Collection<Entry> getColorsCollectionInstance() {
        if (this.colors == null) {
            this.colors = new ArrayList<Entry>();
        }
        return this.colors;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(":");
        for (Entry c : this.getImports()) {
            buf.append(" imports=");
            buf.append(c);
            buf.append(',');
        }
        for (Entry c : this.getClasses()) {
            buf.append('.');
            buf.append(c);
            buf.append(',');
        }
        for (Entry c : this.getIds()) {
            buf.append('#');
            buf.append(c);
            buf.append(',');
        }
        for (Entry c : this.getHtmlElements()) {
            buf.append(c);
            buf.append(',');
        }
        return buf.toString();
    }

    private Entry createEntry(String name, OffsetRange range, boolean isVirtual) {
        return this.createEntry(name, range, null, isVirtual);
    }

    private Entry createEntry(String name, OffsetRange range, OffsetRange bodyRange, boolean isVirtual) {
        if (CssGSFParser.containsGeneratedCode(name)) {
            return null;
        }
        return new LazyEntry(name, range, bodyRange, isVirtual);
    }

    private static int[] getTextWSPreAndPostLens(String text) {
        char c;
        int i;
        int preWSlen = 0;
        int postWSlen = 0;
        for (i = 0; i < text.length() && Character.isWhitespace(c = text.charAt(i)); ++i) {
            ++preWSlen;
        }
        for (i = text.length() - 1; i >= 0 && Character.isWhitespace(c = text.charAt(i)); --i) {
            ++postWSlen;
        }
        return new int[]{preWSlen, postWSlen};
    }

    public class LazyEntry
    implements Entry {
        private final String name;
        private final OffsetRange range;
        private final OffsetRange bodyRange;
        private final boolean isVirtual;
        private OffsetRange documentRange;
        private OffsetRange documentBodyRange;
        private CharSequence elementText;
        private CharSequence elementLineText;
        private int lineOffset;

        public LazyEntry(String name, OffsetRange range, OffsetRange bodyRange, boolean isVirtual) {
            this.name = name;
            this.range = range;
            this.bodyRange = bodyRange;
            this.isVirtual = isVirtual;
        }

        @Override
        public boolean isVirtual() {
            return this.isVirtual;
        }

        @Override
        public boolean isValidInSourceDocument() {
            return this.getDocumentRange() != OffsetRange.NONE;
        }

        @Override
        public synchronized int getLineOffset() {
            if (this.lineOffset == -1 && CssFileModel.this.topLevelSnapshot != null && this.isValidInSourceDocument()) {
                try {
                    this.lineOffset = LexerUtils.getLineOffset((CharSequence)CssFileModel.this.topLevelSnapshot.getText(), (int)this.getDocumentRange().getStart());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return this.lineOffset;
        }

        @Override
        public synchronized CharSequence getText() {
            if (this.elementText == null) {
                this.elementText = new CharSubSequence(CssFileModel.this.getSnapshot().getText(), this.range.getStart(), this.range.getEnd());
            }
            return this.elementText;
        }

        @Override
        public synchronized CharSequence getLineText() {
            if (this.elementLineText == null) {
                try {
                    int astLineStart = GsfUtilities.getRowStart((CharSequence)CssFileModel.this.getSnapshot().getText(), (int)this.range.getStart());
                    int astLineEnd = GsfUtilities.getRowEnd((CharSequence)CssFileModel.this.getSnapshot().getText(), (int)this.range.getStart());
                    this.elementLineText = astLineStart != -1 && astLineEnd != -1 ? CssFileModel.this.getSnapshot().getText().subSequence(astLineStart, astLineEnd) : null;
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.elementLineText;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public synchronized OffsetRange getDocumentRange() {
            if (this.documentRange == null) {
                int documentFrom = CssFileModel.this.getSnapshot().getOriginalOffset(this.range.getStart());
                int documentTo = CssFileModel.this.getSnapshot().getOriginalOffset(this.range.getEnd());
                this.documentRange = documentFrom != -1 && documentTo != -1 ? new OffsetRange(documentFrom, documentTo) : OffsetRange.NONE;
            }
            return this.documentRange;
        }

        @Override
        public OffsetRange getRange() {
            return this.range;
        }

        @Override
        public OffsetRange getBodyRange() {
            return this.bodyRange;
        }

        @Override
        public synchronized OffsetRange getDocumentBodyRange() {
            if (this.documentBodyRange == null && this.bodyRange != null) {
                int bodyDocFrom = CssFileModel.this.getSnapshot().getOriginalOffset(this.bodyRange.getStart());
                int bodyDocTo = CssFileModel.this.getSnapshot().getOriginalOffset(this.bodyRange.getEnd());
                this.documentBodyRange = bodyDocFrom != -1 && bodyDocTo != -1 ? new OffsetRange(bodyDocFrom, bodyDocTo) : OffsetRange.NONE;
            }
            return this.documentBodyRange;
        }

        public String toString() {
            return "Entry[" + (!this.isValidInSourceDocument() ? "INVALID! " : "") + this.getName() + "; " + this.getRange().getStart() + " - " + this.getRange().getEnd() + "]";
        }
    }

    private class AstVisitor
    implements NodeVisitor {
        private AstVisitor() {
        }

        @Override
        public void visit(SimpleNode node) {
            if (node.kind() == 6) {
                Entry entry = this.getImportedEntry(node);
                if (entry != null) {
                    CssFileModel.this.getImportsCollectionInstance().add(entry);
                }
            } else if (node.kind() == 23 || node.kind() == 27 || node.kind() == 24) {
                int start_offset_diff;
                Collection collection;
                SimpleNode styleRuleNode = SimpleNodeUtil.getAncestorByType(node, 19);
                OffsetRange body = null;
                if (styleRuleNode != null) {
                    int to;
                    Token first = styleRuleNode.jjtGetFirstToken();
                    Token last = styleRuleNode.jjtGetLastToken();
                    int from = -1;
                    do {
                        if (first.kind != 8) continue;
                        from = first.offset + 1;
                        break;
                    } while ((first = first.next) != last);
                    int n = to = last.kind == 9 ? last.offset : -1;
                    if (from != -1 && to != -1) {
                        body = new OffsetRange(from, to);
                    }
                }
                switch (node.kind()) {
                    case 23: {
                        collection = CssFileModel.this.getClassesCollectionInstance();
                        start_offset_diff = 1;
                        break;
                    }
                    case 27: {
                        collection = CssFileModel.this.getIdsCollectionInstance();
                        start_offset_diff = 1;
                        break;
                    }
                    case 24: {
                        collection = CssFileModel.this.getHtmlElementsCollectionInstance();
                        start_offset_diff = 0;
                        break;
                    }
                    default: {
                        collection = null;
                        start_offset_diff = 0;
                    }
                }
                String image = node.image().substring(start_offset_diff);
                OffsetRange range = new OffsetRange(node.startOffset() + start_offset_diff, node.endOffset());
                boolean isVirtual = CssFileModel.this.getSnapshot().getOriginalOffset(node.startOffset()) == -1;
                Entry e = CssFileModel.this.createEntry(image, range, body, isVirtual);
                if (e != null) {
                    collection.add(e);
                }
            } else if (node.kind() == 35) {
                OffsetRange range;
                String image = SimpleNodeUtil.getNodeImage(node);
                int[] wsLens = CssFileModel.getTextWSPreAndPostLens(image);
                Entry e = CssFileModel.this.createEntry(image = image.substring(wsLens[0], image.length() - wsLens[1]), range = new OffsetRange(node.startOffset() + wsLens[0], node.endOffset() - wsLens[1]), false);
                if (e != null) {
                    CssFileModel.this.getColorsCollectionInstance().add(e);
                }
            }
        }

        private Entry getImportedEntry(SimpleNode node) {
            Matcher m;
            Token token = SimpleNodeUtil.getNodeToken(node, 23);
            if (token != null) {
                String image = token.image;
                boolean quoted = WebUtils.isValueQuoted((CharSequence)image);
                return CssFileModel.this.createEntry(WebUtils.unquotedValue((CharSequence)image), new OffsetRange(token.offset + (quoted ? 1 : 0), token.offset + image.length() - (quoted ? 1 : 0)), false);
            }
            token = SimpleNodeUtil.getNodeToken(node, 26);
            if (token != null && (m = URI_PATTERN.matcher(token.image)).matches()) {
                int groupIndex = 1;
                String content = m.group(groupIndex);
                boolean quoted = WebUtils.isValueQuoted((CharSequence)content);
                int from = token.offset + m.start(groupIndex) + (quoted ? 1 : 0);
                int to = token.offset + m.end(groupIndex) - (quoted ? 1 : 0);
                return CssFileModel.this.createEntry(WebUtils.unquotedValue((CharSequence)content), new OffsetRange(from, to), false);
            }
            return null;
        }
    }
}

