/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.formatting.api.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.css.formatting.api.LexUtilities;
import org.netbeans.modules.css.formatting.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.css.formatting.api.support.AbstractIndenter;
import org.netbeans.modules.css.formatting.api.support.IndentCommand;
import org.netbeans.modules.css.formatting.api.support.IndenterContextData;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.web.common.api.LexerUtils;

public abstract class MarkupAbstractIndenter<T1 extends TokenId>
extends AbstractIndenter<T1> {
    private Stack<MarkupItem> stack = null;
    private List<EliminatedTag> eliminatedTags;
    private boolean inOpeningTagAttributes;
    private boolean inUnformattableTagContent;
    private CharSequence unformattableTagName = null;
    private int attributesIndent;
    private int firstPreservedLineIndent = -1;

    public MarkupAbstractIndenter(Language<T1> language, Context context) {
        super(language, context);
    }

    protected abstract boolean isOpenTagNameToken(Token<T1> var1);

    protected abstract boolean isCloseTagNameToken(Token<T1> var1);

    protected abstract boolean isStartTagSymbol(Token<T1> var1);

    protected abstract boolean isStartTagClosingSymbol(Token<T1> var1);

    protected abstract boolean isEndTagSymbol(Token<T1> var1);

    protected abstract boolean isEndTagClosingSymbol(Token<T1> var1);

    protected abstract boolean isTagArgumentToken(Token<T1> var1);

    protected abstract boolean isBlockCommentToken(Token<T1> var1);

    protected abstract boolean isTagContentToken(Token<T1> var1);

    protected abstract boolean isClosingTagOptional(CharSequence var1);

    protected abstract boolean isOpeningTagOptional(CharSequence var1);

    protected abstract Boolean isEmptyTag(CharSequence var1);

    protected abstract boolean isTagContentUnformattable(CharSequence var1);

    protected abstract Set<String> getTagChildren(CharSequence var1);

    protected abstract boolean isPreservedLine(Token<T1> var1, IndenterContextData<T1> var2);

    protected abstract int getPreservedLineInitialIndentation(JoinedTokenSequence<T1> var1) throws BadLocationException;

    protected boolean isStableFormattingStartToken(Token<T1> token, JoinedTokenSequence<T1> ts) {
        return false;
    }

    protected abstract boolean isForeignLanguageStartToken(Token<T1> var1, JoinedTokenSequence<T1> var2);

    protected abstract boolean isForeignLanguageEndToken(Token<T1> var1, JoinedTokenSequence<T1> var2);

    private Stack<MarkupItem> getStack() {
        return this.stack;
    }

    @Override
    protected void reset() {
        this.stack = new Stack();
        this.inOpeningTagAttributes = false;
        this.inUnformattableTagContent = false;
        this.attributesIndent = 0;
        this.eliminatedTags = new ArrayList<EliminatedTag>();
    }

    @Override
    protected int getFormatStableStart(JoinedTokenSequence<T1> ts, int startOffset, int endOffset, AbstractIndenter.OffsetRanges rangesToIgnore) throws BadLocationException {
        Token<T1> tk;
        Token<T1> tk2;
        ts.move(endOffset, false);
        while (ts.movePrevious() && (!this.isStableFormattingStartToken(tk2 = ts.token(), ts) || ts.offset() > startOffset)) {
            if (this.isCloseTagNameToken(tk2) && !this.isClosingTagOptional(this.getTokenName(tk2)) && !this.isOpeningTagOptional(this.getTokenName(tk2))) {
                this.moveToOpeningTag(ts);
                continue;
            }
            if (!this.isOpenTagNameToken(tk2) || this.isClosingTagOptional(this.getTokenName(tk2)) || ts.offset() >= startOffset) continue;
            break;
        }
        int foundOffset = -1;
        while ((tk = ts.token()) != null) {
            int firstNonWhite;
            if ((this.isStartTagSymbol(tk) || this.isStableFormattingStartToken(tk, ts)) && (firstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)this.getDocument(), (int)ts.offset())) != -1 && firstNonWhite == ts.offset()) {
                foundOffset = ts.offset();
                break;
            }
            if (ts.movePrevious()) continue;
        }
        if (foundOffset == -1) {
            foundOffset = LexUtilities.getTokenSequenceStartOffset(ts);
        }
        this.eliminateUnnecessaryTags(ts, startOffset, foundOffset, rangesToIgnore);
        return foundOffset;
    }

    private void eliminateUnnecessaryTags(JoinedTokenSequence<T1> ts, int from, int to, AbstractIndenter.OffsetRanges rangesToIgnore) throws BadLocationException {
        ts.move(from, false);
        while (ts.movePrevious()) {
            int endLine;
            int startLine;
            int rangeStart;
            int rangeEnd;
            Token<T1> tk = ts.token();
            if (ts.offset() < to) break;
            if (!this.isCloseTagNameToken(tk) || this.isClosingTagOptional(this.getTokenName(tk)) || this.isOpeningTagOptional(this.getTokenName(tk))) continue;
            CharSequence tag = this.getTokenName(tk);
            if (ts.moveNext() && this.isEndTagSymbol(ts.token())) {
                assert (this.isEndTagSymbol(ts.token())) : "token=" + ts.token() + " ts=" + ts;
                rangeEnd = ts.offset() + this.getTokenName(ts.token()).length();
                ts.movePrevious();
            } else {
                rangeEnd = ts.offset() + this.getTokenName(ts.token()).length();
            }
            if (!this.moveToOpeningTag(ts)) continue;
            assert (LexerUtils.equals((CharSequence)this.getTokenName(ts.token()), (CharSequence)tag, (boolean)true, (boolean)false)) : "tag=" + tag + " token=" + ts.token();
            if (ts.movePrevious() && this.isStartTagSymbol(ts.token())) {
                assert (this.isStartTagSymbol(ts.token())) : "token=" + ts.token() + " ts=" + ts;
                rangeStart = ts.offset();
            } else {
                rangeStart = ts.offset();
            }
            if (rangeStart >= rangeEnd || (startLine = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)rangeStart)) == (endLine = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)rangeEnd))) continue;
            rangesToIgnore.add(rangeStart, rangeEnd);
            this.eliminatedTags.add(0, new EliminatedTag(rangeStart, rangeEnd, tag));
        }
    }

    private MarkupItem createMarkupItem(Token<T1> token, boolean openingTag, int indentation) {
        return this.createMarkupItem(token, openingTag, indentation, false);
    }

    private MarkupItem createMarkupItem(Token<T1> token, boolean openingTag, int indentation, boolean foreign) {
        CharSequence tagName = this.getTokenName(token);
        if (openingTag) {
            boolean optionalEnd = this.isClosingTagOptional(this.getTokenName(token));
            Set<String> children = null;
            Boolean empty = this.isEmptyTag(tagName);
            if (optionalEnd && empty != null && !empty.booleanValue()) {
                children = this.getTagChildren(tagName);
            }
            return new MarkupItem(tagName, true, indentation, optionalEnd, children, empty != null ? empty : false, false, false, foreign);
        }
        Boolean empty = this.isEmptyTag(tagName);
        return new MarkupItem(tagName, false, indentation, false, null, empty != null ? empty : false, false, false, foreign);
    }

    private static MarkupItem createVirtualMarkupItem(CharSequence tagName, boolean empty) {
        return new MarkupItem(tagName, false, -1, false, null, empty, true, false, false);
    }

    private static MarkupItem createEliminatedMarkupItem(CharSequence tagName, boolean openingTag) {
        return new MarkupItem(tagName, openingTag, -1, false, null, false, false, true, false);
    }

    private boolean moveToOpeningTag(JoinedTokenSequence<T1> tokenSequence) {
        int[] originalIndex = tokenSequence.index();
        CharSequence searchedTagName = this.getTokenName(tokenSequence.token());
        int balance = 0;
        while (tokenSequence.movePrevious()) {
            Token<T1> tk = tokenSequence.token();
            if (!this.isOpenTagNameToken(tk) && !this.isCloseTagNameToken(tk) || !LexerUtils.equals((CharSequence)searchedTagName, (CharSequence)this.getTokenName(tk), (boolean)true, (boolean)false)) continue;
            if (this.isOpenTagNameToken(tk)) {
                if (balance == 0) {
                    return true;
                }
                --balance;
                continue;
            }
            if (!this.isCloseTagNameToken(tk)) continue;
            ++balance;
        }
        tokenSequence.moveIndex(originalIndex);
        tokenSequence.movePrevious();
        return false;
    }

    private void getIndentFromState(List<IndentCommand> iis, boolean updateState, int lineStartOffset) {
        Stack<MarkupItem> fileStack = this.getStack();
        int lastUnprocessedItem = fileStack.size();
        int i = fileStack.size() - 1;
        while (i >= 0 && !((MarkupItem)fileStack.get((int)i)).processed) {
            lastUnprocessedItem = i--;
        }
        ArrayList<MarkupItem> prevItems = new ArrayList<MarkupItem>();
        for (int i2 = lastUnprocessedItem; i2 < fileStack.size(); ++i2) {
            MarkupItem item = (MarkupItem)fileStack.get(i2);
            assert (!item.processed) : item;
            boolean addToPrevItems = true;
            if (i2 + 1 == fileStack.size() && this.inOpeningTagAttributes) break;
            if (!item.empty || item.foreignLanguageTag) {
                IndentCommand ic = new IndentCommand(item.openingTag ? IndentCommand.Type.INDENT : IndentCommand.Type.RETURN, lineStartOffset);
                addToPrevItems = this.addIndentationCommand(iis, ic, item, prevItems);
            }
            if (updateState) {
                item.processed = true;
            }
            if (!addToPrevItems) continue;
            prevItems.add(item);
        }
        if (this.inOpeningTagAttributes) {
            IndentCommand ii = new IndentCommand(IndentCommand.Type.CONTINUE, lineStartOffset);
            if (this.getAttributesIndent() != -1) {
                ii.setFixedIndentSize(this.getAttributesIndent());
            }
            iis.add(ii);
        }
        if (updateState) {
            this.removeFullyProcessedTags();
        }
    }

    private String dumpMoreDiagnosticToResolveIssue162700(Stack<MarkupItem> fileStack) {
        int index = fileStack.size() - 6;
        if (index < 0) {
            index = 0;
        }
        StringBuilder sb = new StringBuilder("diagnostic dump: ");
        ListIterator it = fileStack.listIterator(index);
        while (it.hasNext()) {
            MarkupItem im = (MarkupItem)it.next();
            sb.append(im.toString() + " ");
        }
        return sb.toString();
    }

    private boolean addIndentationCommand(List<IndentCommand> iis, IndentCommand ic, MarkupItem item, List<MarkupItem> prevItems) {
        IndentCommand prev;
        MarkupItem prevItem;
        MarkupItem markupItem = prevItem = prevItems.size() > 0 ? prevItems.get(prevItems.size() - 1) : null;
        if (ic.getType() == IndentCommand.Type.RETURN && iis.size() > 0 && prevItem != null && (prev = iis.get(iis.size() - 1)).getType() == IndentCommand.Type.INDENT && prevItem.tagName.equals(item.tagName) && prevItem.openingTag && !item.openingTag) {
            iis.remove(iis.size() - 1);
            prevItems.remove(prevItems.size() - 1);
            return false;
        }
        iis.add(ic);
        return true;
    }

    @Override
    protected List<IndentCommand> getLineIndent(IndenterContextData<T1> context, List<IndentCommand> preliminaryNextLineIndent) throws BadLocationException {
        Token<T1> token;
        this.processEliminatedTags(context.getLineStartOffset());
        Stack<MarkupItem> fileStack = this.getStack();
        ArrayList<IndentCommand> iis = new ArrayList<IndentCommand>();
        this.getIndentFromState(iis, true, context.getLineStartOffset());
        JoinedTokenSequence<T1> ts = context.getJoinedTokenSequences();
        ts.move(context.getLineStartOffset());
        ArrayList<MarkupItem> lineItems = new ArrayList<MarkupItem>();
        CharSequence lastOpenTagName = null;
        boolean unformattableTagContent = this.isInUnformattableTagContent();
        while (!context.isBlankLine() && ts.moveNext() && (ts.isCurrentTokenSequenceVirtual() && ts.offset() < context.getLineEndOffset() || ts.offset() <= context.getLineEndOffset())) {
            token = ts.token();
            if (token == null || ts.embedded() != null) continue;
            if (this.isOpenTagNameToken(token)) {
                boolean foreign = this.isForeignLanguageStartToken(token, ts);
                lineItems.add(this.createMarkupItem(token, true, this.getIndentationSize(), foreign));
                this.setInOpeningTagAttributes(true);
                lastOpenTagName = this.getTokenName(token);
            } else if (this.isTagArgumentToken(token) && this.getAttributesIndent() == -1) {
                int[] index = ts.index();
                int offset = ts.offset();
                ts.movePrevious();
                Token<T1> tk = this.findPreviousNonWhiteSpaceToken(ts);
                if (this.isOpenTagNameToken(tk)) {
                    this.setAttributesIndent(offset - context.getLineNonWhiteStartOffset());
                }
                ts.moveIndex(index);
                ts.moveNext();
            } else if (this.isCloseTagNameToken(token)) {
                boolean foreign = this.isForeignLanguageEndToken(token, ts);
                lineItems.add(this.createMarkupItem(token, false, this.getIndentationSize(), foreign));
                CharSequence tokenName = this.getTokenName(token);
                if (this.isTagContentUnformattable(tokenName) && tokenName.equals(this.unformattableTagName)) {
                    this.setInUnformattableTagContent(false);
                    if (unformattableTagContent && context.getLineStartOffset() + 2 == ts.offset()) {
                        unformattableTagContent = false;
                    }
                }
                lastOpenTagName = null;
            } else if (this.isEndTagSymbol(token) || this.isEndTagClosingSymbol(token)) {
                if (this.isInOpeningTagAttributes()) {
                    this.setInOpeningTagAttributes(false);
                }
                if (this.isEndTagClosingSymbol(token)) {
                    MarkupItem item = null;
                    if (lineItems.size() > 0) {
                        item = (MarkupItem)lineItems.get(lineItems.size() - 1);
                    } else if (fileStack.size() > 0) {
                        item = fileStack.peek();
                    }
                    if (item != null) {
                        lineItems.add(MarkupAbstractIndenter.createVirtualMarkupItem(item.tagName, item.empty));
                    } else assert (false) : "token:" + token + " ts=" + ts;
                } else if (lastOpenTagName != null && !this.isInUnformattableTagContent() && this.isTagContentUnformattable(lastOpenTagName)) {
                    this.setInUnformattableTagContent(true, lastOpenTagName);
                }
            }
            if (this.isPreservedLine(token, context)) {
                if (this.firstPreservedLineIndent == -1) {
                    this.firstPreservedLineIndent = this.getPreservedLineInitialIndentation(ts);
                }
                IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
                ic.setFixedIndentSize(this.firstPreservedLineIndent);
                iis.add(ic);
            } else {
                this.firstPreservedLineIndent = -1;
            }
            if (this.isForeignLanguageStartToken(token, ts)) {
                iis.add(new IndentCommand(IndentCommand.Type.BLOCK_START, context.getLineStartOffset()));
                continue;
            }
            if (!this.isForeignLanguageEndToken(token, ts)) continue;
            iis.add(new IndentCommand(IndentCommand.Type.BLOCK_END, context.getLineStartOffset()));
        }
        if (context.isBlankLine() && iis.isEmpty() && ts.moveNext() && (token = ts.token()) != null && ts.embedded() == null && this.isPreservedLine(token, context)) {
            IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
            if (this.firstPreservedLineIndent == -1) {
                this.firstPreservedLineIndent = this.getPreservedLineInitialIndentation(ts);
            }
            ic.setFixedIndentSize(this.firstPreservedLineIndent);
            iis.add(ic);
        }
        if (unformattableTagContent) {
            iis.add(new IndentCommand(IndentCommand.Type.DO_NOT_INDENT_THIS_LINE, context.getLineStartOffset()));
        }
        int index = fileStack.size();
        this.addTags(lineItems);
        if (!context.isBlankLine()) {
            ts.move(context.getLineNonWhiteStartOffset());
            if (ts.moveNext() && (this.isStartTagSymbol(ts.token()) || this.isStartTagClosingSymbol(ts.token()))) {
                boolean closingTag = this.isStartTagClosingSymbol(ts.token());
                if (ts.moveNext()) {
                    CharSequence tokenName = this.getTokenName(ts.token());
                    ArrayList iis2 = new ArrayList();
                    for (int i = index; i < fileStack.size(); ++i) {
                        MarkupItem item = (MarkupItem)fileStack.get(i);
                        if (item.empty && !item.foreignLanguageTag) continue;
                        assert (!item.processed) : item;
                        if (item.virtual) {
                            assert (!item.openingTag) : "only closing tag item is expected: " + item;
                            iis.add(new IndentCommand(IndentCommand.Type.RETURN, context.getLineStartOffset()));
                            item.processed = true;
                            continue;
                        }
                        if (!closingTag || !LexerUtils.equals((CharSequence)item.tagName, (CharSequence)tokenName, (boolean)true, (boolean)false) || !context.isIndentThisLine()) break;
                        iis.add(new IndentCommand(IndentCommand.Type.RETURN, context.getLineStartOffset()));
                        item.processed = true;
                        break;
                    }
                    if (iis2.size() > 0) {
                        iis.addAll(iis2);
                    }
                }
            }
        }
        if (iis.isEmpty()) {
            iis.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getLineStartOffset()));
        }
        if (context.getNextLineStartOffset() != -1) {
            this.getIndentFromState(preliminaryNextLineIndent, false, context.getNextLineStartOffset());
            if (preliminaryNextLineIndent.size() == 0) {
                preliminaryNextLineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getNextLineStartOffset()));
            }
        }
        return iis;
    }

    private void processEliminatedTags(int lineStartOffset) {
        ArrayList<MarkupItem> items = new ArrayList<MarkupItem>();
        this.generateVirtualMarkupItemsForEliminatedTags(items, lineStartOffset);
        if (items.size() > 0) {
            this.addTags(items);
        }
    }

    private void generateVirtualMarkupItemsForEliminatedTags(List<MarkupItem> lineItems, int lineStartOffset) {
        EliminatedTag et;
        Iterator<EliminatedTag> it = this.eliminatedTags.iterator();
        while (it.hasNext() && (et = it.next()).end <= lineStartOffset) {
            lineItems.add(MarkupAbstractIndenter.createEliminatedMarkupItem(et.tag, true));
            it.remove();
        }
    }

    private CharSequence getTokenName(Token<T1> token) {
        return CharSequenceUtilities.trim((CharSequence)token.text());
    }

    private Token<T1> findPreviousNonWhiteSpaceToken(JoinedTokenSequence<T1> ts) {
        while (this.isWhiteSpaceToken(ts.token()) && ts.movePrevious()) {
        }
        return ts.token();
    }

    private void addTags(List<MarkupItem> lineItems) {
        for (MarkupItem newItem : lineItems) {
            if (!newItem.virtual) {
                if (newItem.openingTag) {
                    this.getStack().addAll(this.calculateAllVirtualCloseTagsForOpenTag(newItem));
                } else {
                    this.getStack().addAll(this.calculateAllVirtualCloseTagsForCloseTag(newItem));
                }
            }
            if (newItem.eliminated) continue;
            this.getStack().push(newItem);
        }
    }

    private List<MarkupItem> eliminateTagsOpenedAndClosedOnOneLine(List<MarkupItem> lineItems) {
        ArrayList<MarkupItem> newItems = new ArrayList<MarkupItem>();
        for (int i = lineItems.size() - 1; i >= 0; --i) {
            int index;
            MarkupItem item = lineItems.get(i);
            if (!item.openingTag && (index = MarkupAbstractIndenter.indexOfOpenTag(lineItems, item, i)) != -1) {
                i = index;
                continue;
            }
            newItems.add(0, item);
        }
        return newItems;
    }

    private List<MarkupItem> calculateAllVirtualCloseTagsForOpenTag(MarkupItem newItem) {
        ArrayList<MarkupItem> newItems = new ArrayList<MarkupItem>();
        block0: for (int i = this.getStack().size() - 1; i >= 0; --i) {
            MarkupItem item = (MarkupItem)this.getStack().get(i);
            if (!item.openingTag) {
                int index = MarkupAbstractIndenter.indexOfOpenTag(this.getStack(), item, i);
                if (index != -1) {
                    i = index;
                    continue;
                }
                if (!DEBUG) continue;
                System.err.println("WARNING: cannot find open tag for " + item + " before index " + i + ": " + (this.getStack().size() < 30 ? this.getStack() : "[too many items]"));
                continue;
            }
            if (!item.optionalClosingTag) break;
            if (item.children != null) {
                if (item.children.contains(((Object)newItem.tagName).toString().toUpperCase())) break;
                for (String s : item.children) {
                    if (!this.isOpeningTagOptional(s)) continue;
                    break block0;
                }
                newItems.add(MarkupAbstractIndenter.createVirtualMarkupItem(item.tagName, item.empty));
                continue;
            }
            newItems.add(MarkupAbstractIndenter.createVirtualMarkupItem(item.tagName, item.empty));
        }
        return newItems;
    }

    private List<MarkupItem> calculateAllVirtualCloseTagsForCloseTag(MarkupItem newItem) {
        int lastFailureSize = -1;
        ArrayList<MarkupItem> newItems = new ArrayList<MarkupItem>();
        for (int i = this.getStack().size() - 1; i >= 0; --i) {
            MarkupItem item = (MarkupItem)this.getStack().get(i);
            if (!item.openingTag) {
                int index = MarkupAbstractIndenter.indexOfOpenTag(this.getStack(), item, i);
                if (index != -1) {
                    i = index;
                    continue;
                }
                if (!AbstractIndenter.DEBUG) continue;
                System.err.println("WARNING: cannot find open tag for " + item + " before index " + i + ": " + (this.getStack().size() < 30 ? this.getStack() : "[too many items]"));
                continue;
            }
            if (LexerUtils.equals((CharSequence)item.tagName, (CharSequence)newItem.tagName, (boolean)true, (boolean)false)) {
                lastFailureSize = -1;
                break;
            }
            if (item.optionalClosingTag) {
                if (lastFailureSize == -1) {
                    lastFailureSize = newItems.size();
                }
                newItems.add(MarkupAbstractIndenter.createVirtualMarkupItem(item.tagName, item.empty));
                continue;
            }
            if (lastFailureSize == -1) {
                lastFailureSize = newItems.size();
                newItems.add(MarkupAbstractIndenter.createVirtualMarkupItem(item.tagName, item.empty));
                continue;
            }
            if (AbstractIndenter.DEBUG) {
                System.err.println("WARNING: cannot find opening tag for " + newItem + ": " + this.getStack() + " stopped searching at " + item);
            }
            newItem.eliminated = true;
            break;
        }
        if (lastFailureSize != -1) {
            while (newItems.size() > lastFailureSize) {
                newItems.remove(newItems.size() - 1);
            }
        }
        return newItems;
    }

    private static int indexOfOpenTag(List<MarkupItem> list, MarkupItem closeTag, int i) {
        assert (!closeTag.openingTag) : closeTag;
        int balance = 0;
        for (int index = i - 1; index >= 0; --index) {
            MarkupItem item = list.get(index);
            if (!LexerUtils.equals((CharSequence)item.tagName, (CharSequence)closeTag.tagName, (boolean)true, (boolean)false)) continue;
            if (item.openingTag) {
                if (balance == 0) {
                    return index;
                }
                --balance;
                continue;
            }
            ++balance;
        }
        return -1;
    }

    private void removeFullyProcessedTags() {
        Stack<MarkupItem> fileStack = this.getStack();
        for (int i = fileStack.size() - 1; i >= 0; --i) {
            int index;
            MarkupItem item = (MarkupItem)this.getStack().get(i);
            if (item.openingTag || !item.processed || (index = MarkupAbstractIndenter.indexOfOpenTag(this.getStack(), item, i)) == -1) continue;
            this.discardProcessedMarkupItems(fileStack, index, i);
            i = index;
        }
    }

    private void discardProcessedMarkupItems(Stack<MarkupItem> stack, int startIndex, int endIndex) {
        for (int index = endIndex; index >= startIndex; --index) {
            MarkupItem item = (MarkupItem)stack.get(index);
            assert (item.processed || item.virtual) : "assumption here is that a tag within process tag must be either processed or perhaps virtual: item=" + item + " stack=" + (this.getStack().size() < 30 ? this.getStack() : "[too many items]");
            stack.remove(index);
        }
    }

    private boolean isInOpeningTagAttributes() {
        return this.inOpeningTagAttributes;
    }

    private void setInOpeningTagAttributes(boolean inOpeningTagAttributes) {
        this.inOpeningTagAttributes = inOpeningTagAttributes;
        this.attributesIndent = -1;
    }

    private int getAttributesIndent() {
        return this.attributesIndent;
    }

    private void setAttributesIndent(int attributesIndent) {
        this.attributesIndent = attributesIndent;
    }

    private boolean isInUnformattableTagContent() {
        return this.inUnformattableTagContent;
    }

    private void setInUnformattableTagContent(boolean inUnformattableTagContent, CharSequence unformattableTagName) {
        this.inUnformattableTagContent = inUnformattableTagContent;
        this.unformattableTagName = unformattableTagName;
    }

    private void setInUnformattableTagContent(boolean inUnformattableTagContent) {
        this.inUnformattableTagContent = inUnformattableTagContent;
        this.unformattableTagName = null;
    }

    private static class EliminatedTag {
        private int start;
        private int end;
        private CharSequence tag;

        public EliminatedTag(int start, int end, CharSequence tag) {
            this.start = start;
            this.end = end;
            this.tag = tag;
        }

        public String toString() {
            return "EliminatedTag[" + this.tag + " at " + this.start + "-" + this.end + "]";
        }
    }

    private static class MarkupItem {
        public CharSequence tagName;
        public boolean openingTag;
        public int indentLevel;
        public boolean processed;
        public boolean optionalClosingTag;
        public Set<String> children;
        public boolean virtual;
        public boolean empty;
        public boolean eliminated;
        public boolean foreignLanguageTag;

        public MarkupItem(CharSequence tagName, boolean openingTag, int indentLevel, boolean optionalClosingTag, Set<String> children, boolean empty, boolean virtual, boolean eliminated, boolean foreignLanguageTag) {
            this.tagName = tagName;
            this.openingTag = openingTag;
            this.indentLevel = indentLevel;
            this.optionalClosingTag = optionalClosingTag;
            this.processed = false;
            this.children = children;
            this.empty = empty;
            this.virtual = virtual;
            this.eliminated = eliminated;
            this.foreignLanguageTag = foreignLanguageTag;
        }

        public String toString() {
            return "HtmlStackItem[" + (this.openingTag ? "<" : "</") + "tagName=" + this.tagName + "," + "indent=" + this.indentLevel + "," + "optionalClosingTag=" + this.optionalClosingTag + "," + "processed=" + this.processed + "," + "virtual=" + this.virtual + "," + "foreign=" + this.foreignLanguageTag + "," + "empty=" + this.empty + "]";
        }
    }
}

