/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.projectsupport.utilities;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.utilities.OutputParameter;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class SourceUtils {
    private static final Logger LOGGER = Logger.getLogger(SourceUtils.class.getName());
    private static final FileObject[] NOFILES = new FileObject[0];
    private static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String VM_CONSTRUCTUR_SIG = "<init>";
    private static final String VM_INITIALIZER_SIG = "<clinit>";
    private static final String[] APPLET_CLASSES = new String[]{"java.applet.Applet", "javax.swing.JApplet"};
    private static final String[] TEST_CLASSES = new String[]{"junit.framework.TestCase", "junit.framework.TestSuite"};
    private static final String[] TEST_ANNOTATIONS = new String[]{"org.junit.Test", "org.testng.annotations.Test"};

    public static boolean isApplet(FileObject javaFile) {
        return SourceUtils.isJavaFile(javaFile) && SourceUtils.isInstanceOf(javaFile, APPLET_CLASSES, false);
    }

    public static ClientUtils.SourceCodeSelection[] getClassConstructors(FileObject classFile) {
        HashSet constructors = new HashSet();
        JavaSource js = JavaSource.forFileObject((FileObject)classFile);
        if (js == null) {
            return null;
        }
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(final CompilationController controller) throws Exception {
                    if (controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(){

                        @Override
                        public Void visitMethod(MethodTree node, Void p) {
                            ExecutableElement method = (ExecutableElement)controller.getTrees().getElement(this.getCurrentPath());
                            Void retValue = (Void)super.visitMethod(node, p);
                            return retValue;
                        }
                    };
                    scanner.scan(controller.getCompilationUnit(), null);
                }
            }, true);
        }
        catch (IOException e) {
            ProfilerLogger.log((Exception)e);
            e.printStackTrace();
        }
        return constructors.toArray(new ClientUtils.SourceCodeSelection[constructors.size()]);
    }

    public static FileObject getCurrentFileInEditor() {
        TopComponent tc = TopComponent.getRegistry().getActivated();
        if (tc != null) {
            return (FileObject)tc.getLookup().lookup(FileObject.class);
        }
        return null;
    }

    public static int getCurrentLineInEditor() {
        return SourceUtils.getLineForOffsetInEditor(SourceUtils.getCurrentOffsetInEditor());
    }

    public static int getCurrentOffsetInEditor() {
        JTextComponent mostActiveEditor = EditorRegistry.lastFocusedComponent();
        if (mostActiveEditor != null && mostActiveEditor.getCaret() != null) {
            return mostActiveEditor.getCaretPosition();
        }
        return -1;
    }

    public static boolean isCurrentOffsetValid() {
        return SourceUtils.isOffsetValid(SourceUtils.getCurrentFileInEditor(), SourceUtils.getCurrentOffsetInEditor());
    }

    public static Project getCurrentProjectInEditor() {
        TopComponent tc = TopComponent.getRegistry().getActivated();
        if (tc != null) {
            return (Project)tc.getLookup().lookup(Project.class);
        }
        return null;
    }

    public static JavaSource getCurrentSourceInEditor() {
        FileObject fileObject = SourceUtils.getCurrentFileInEditor();
        if (fileObject != null) {
            return JavaSource.forFileObject((FileObject)fileObject);
        }
        return null;
    }

    public static Collection<String> getDefaultPackageClassNames(Project project) {
        ArrayList<String> classNames = new ArrayList<String>();
        JavaSource js = SourceUtils.getSources(project);
        Set<ElementHandle<TypeElement>> types = SourceUtils.getProjectTypes(project, js);
        for (ElementHandle<TypeElement> typeHandle : types) {
            int firstPkgSeparIndex = typeHandle.getQualifiedName().indexOf(46);
            if (firstPkgSeparIndex > 0) continue;
            classNames.add(typeHandle.getQualifiedName().substring(firstPkgSeparIndex + 1));
        }
        return classNames;
    }

    public static String getEnclosingClassName(FileObject profiledClassFile, final int position) {
        final OutputParameter result = new OutputParameter(null);
        if (SourceUtils.isJavaFile(profiledClassFile)) {
            JavaSource js = JavaSource.forFileObject((FileObject)profiledClassFile);
            if (js == null) {
                return null;
            }
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController controller) throws Exception {
                        if (controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            return;
                        }
                        TypeElement parentClass = controller.getTreeUtilities().scopeFor(position).getEnclosingClass();
                        if (parentClass != null) {
                            result.setValue((Object)ElementUtilities.getBinaryName((TypeElement)parentClass));
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return (String)result.getValue();
    }

    public static String getEnclosingMethodName(FileObject profiledClassFile, final int position) {
        final OutputParameter result = new OutputParameter(null);
        if (SourceUtils.isJavaFile(profiledClassFile)) {
            JavaSource js = JavaSource.forFileObject((FileObject)profiledClassFile);
            if (js == null) {
                return null;
            }
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController controller) throws Exception {
                        if (controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            return;
                        }
                        ExecutableElement parentMethod = controller.getTreeUtilities().scopeFor(position).getEnclosingMethod();
                        if (parentMethod != null) {
                            result.setValue((Object)SourceUtils.getVMMethodName(parentMethod));
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return (String)result.getValue();
    }

    public static boolean isExecutableMethod(ExecutableElement method) {
        if (method == null) {
            return false;
        }
        Set<Modifier> modifiers = method.getModifiers();
        return !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.NATIVE);
    }

    public static boolean isInstanceOf(FileObject fo, String className) {
        return SourceUtils.isInstanceOf(fo, new String[]{className}, true);
    }

    public static boolean hasAnnotation(FileObject fo, final String[] annotationNames) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean result = new AtomicBoolean(false);
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return false;
        }
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(final CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(){

                        @Override
                        public Void visitAnnotation(AnnotationTree annTree, Void p) {
                            TypeElement annType;
                            if (result.get()) {
                                return null;
                            }
                            TypeMirror tm = controller.getTrees().getTypeMirror(this.getCurrentPath());
                            if (tm != null && (annType = (TypeElement)controller.getTypes().asElement(tm)) != null) {
                                boolean res = result.get();
                                if (!res) {
                                    for (String ann : annotationNames) {
                                        if (!ann.equals(ElementUtilities.getBinaryName((TypeElement)annType))) continue;
                                        res = true;
                                        break;
                                    }
                                }
                                result.set(res);
                            }
                            return null;
                        }
                    };
                    scanner.scan(controller.getCompilationUnit(), null);
                    latch.countDown();
                }
            }, true);
            latch.await();
            return result.get();
        }
        catch (IOException e) {
            ProfilerLogger.log((Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public static boolean isInstanceOf(FileObject fo, final String[] classNames, final boolean allRequired) {
        final boolean[] result = new boolean[]{false};
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return false;
        }
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    if (controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                        return;
                    }
                    Elements elements = controller.getElements();
                    Trees trees = controller.getTrees();
                    Types types = controller.getTypes();
                    ArrayList<TypeElement> classElements = new ArrayList<TypeElement>();
                    for (String string : classNames) {
                        TypeElement resolvedElement = elements.getTypeElement(string);
                        if (resolvedElement == null) continue;
                        classElements.add(resolvedElement);
                    }
                    if (classElements.isEmpty()) {
                        result[0] = false;
                        return;
                    }
                    CompilationUnitTree cu = controller.getCompilationUnit();
                    List<? extends Tree> topLevels = cu.getTypeDecls();
                    for (Tree tree : topLevels) {
                        TypeElement classElement;
                        Set<Modifier> modifiers;
                        TypeElement type;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || (type = (TypeElement)trees.getElement(TreePath.getPath(cu, tree))) == null || !(modifiers = type.getModifiers()).contains((Object)Modifier.PUBLIC) || classElements == null) continue;
                        boolean rslt = allRequired;
                        Iterator i$ = classElements.iterator();
                        while (i$.hasNext() && ((classElement = (TypeElement)i$.next()) == null || !(allRequired ? !(rslt = rslt && types.isSubtype(type.asType(), classElement.asType())) : (rslt = rslt || types.isSubtype(type.asType(), classElement.asType()))))) {
                        }
                        result[0] = rslt;
                        if (!rslt) continue;
                        break;
                    }
                }
            }, true);
        }
        catch (IOException e) {
            ProfilerLogger.log((Exception)e);
            e.printStackTrace();
        }
        return result[0];
    }

    public static boolean isJavaClass(Node aNode) {
        if (aNode == null) {
            return false;
        }
        DataObject dObject = (DataObject)aNode.getLookup().lookup(DataObject.class);
        if (dObject != null) {
            return SourceUtils.isJavaFile(dObject.getPrimaryFile());
        }
        return false;
    }

    public static boolean isJavaFile(FileObject f) {
        return JAVA_MIME_TYPE.equals(f.getMIMEType());
    }

    public static int getLineForOffsetInEditor(int offset) {
        EditorCookie ec;
        if (offset == -1) {
            return -1;
        }
        TopComponent tc = TopComponent.getRegistry().getActivated();
        if (tc != null && (ec = (EditorCookie)tc.getLookup().lookup(EditorCookie.class)) != null) {
            return NbDocument.findLineNumber((StyledDocument)ec.getDocument(), (int)offset);
        }
        return -1;
    }

    public static boolean isOffsetValid(FileObject editorFile, int offset) {
        if (editorFile == null) {
            return false;
        }
        return SourceUtils.validateOffset(editorFile, offset) != -1;
    }

    public static boolean isRunnable(FileObject javaFile) {
        if (SourceUtils.isTest(javaFile) || SourceUtils.isApplet(javaFile)) {
            return true;
        }
        if (SourceUtils.isJavaFile(javaFile)) {
            return !org.netbeans.api.java.source.SourceUtils.getMainClasses((FileObject)javaFile).isEmpty();
        }
        return false;
    }

    public static int[] getSelectionOffsets() {
        EditorCookie ec;
        int[] indexes = new int[]{-1, -1};
        TopComponent tc = TopComponent.getRegistry().getActivated();
        if (tc != null && (ec = (EditorCookie)tc.getLookup().lookup(EditorCookie.class)) != null) {
            for (JEditorPane pane : ec.getOpenedPanes()) {
                int selStart = pane.getSelectionStart();
                if (selStart <= -1) continue;
                indexes[0] = selStart;
                indexes[1] = pane.getSelectionEnd();
                break;
            }
        }
        return indexes;
    }

    public static String[] getSubclassesNames(final String className, Project project) {
        final HashSet subclasses = new HashSet();
        final JavaSource js = SourceUtils.getSources(project);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    if (controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                        return;
                    }
                    TypeElement superClass = SourceUtils.resolveClassByName(className, controller);
                    if (superClass != null && superClass.getKind() == ElementKind.INTERFACE) {
                        subclasses.addAll(SourceUtils.findImplementorsResolved(js.getClasspathInfo(), className));
                    }
                }
            }, false);
        }
        catch (IOException ex) {
            ProfilerLogger.log((Exception)ex);
        }
        int index = 0;
        String[] subclassesNames = new String[subclasses.size()];
        for (TypeElement subclass : subclasses) {
            subclassesNames[index++] = SourceUtils.getVMClassName(subclass);
        }
        return subclassesNames;
    }

    public static boolean isTest(FileObject fo) {
        return SourceUtils.isJavaFile(fo) && (SourceUtils.hasAnnotation(fo, TEST_ANNOTATIONS) || SourceUtils.isInstanceOf(fo, TEST_CLASSES, false));
    }

    public static String getToplevelClassName(FileObject profiledClassFile) {
        final String[] result = new String[1];
        if (SourceUtils.isJavaFile(profiledClassFile)) {
            JavaSource js = JavaSource.forFileObject((FileObject)profiledClassFile);
            if (js == null) {
                return null;
            }
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(final CompilationController controller) throws Exception {
                        if (controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            return;
                        }
                        TreePathScanner<String, Void> scanner = new TreePathScanner<String, Void>(){

                            @Override
                            public String visitClass(ClassTree node, Void p) {
                                try {
                                    return ElementUtilities.getBinaryName((TypeElement)((TypeElement)controller.getTrees().getElement(this.getCurrentPath())));
                                }
                                catch (NullPointerException e) {
                                    ProfilerLogger.log((Exception)e);
                                    return "";
                                }
                            }
                        };
                        result[0] = (String)scanner.scan(controller.getCompilationUnit(), null);
                    }
                }, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result[0];
    }

    public static String getVMClassName(TypeElement jClass) {
        if (jClass.getSimpleName().length() == 0) {
            String userClassName = jClass.toString();
            String className = userClassName.substring(0, userClassName.length() - 1);
            int classNameStart = className.lastIndexOf(" ");
            className = className.substring(classNameStart + 1);
            return className;
        }
        TypeElement currentClass = jClass;
        StringBuffer vmClassName = new StringBuffer();
        while (SourceUtils.isEnclosingElement(currentClass.getEnclosingElement())) {
            vmClassName.insert(0, "$" + currentClass.getSimpleName().toString());
            currentClass = (TypeElement)currentClass.getEnclosingElement();
        }
        vmClassName.insert(0, currentClass.getQualifiedName().toString());
        return vmClassName.toString();
    }

    public static String getVMMethodName(ExecutableElement method) {
        return method.getSimpleName().toString();
    }

    public static String getVMMethodSignature(ExecutableElement method, CompilationInfo ci) {
        return SourceUtils.getSignature(method, ci);
    }

    public static String getVMMethodSignature(final ExecutableElement method, ClasspathInfo cpInfo) {
        final OutputParameter signature = new OutputParameter((Object)"");
        FileObject file = org.netbeans.api.java.source.SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)method), (ClasspathInfo)cpInfo);
        JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{file});
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    signature.setValue((Object)SourceUtils.getSignature(method, (CompilationInfo)controller));
                }
            }, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return (String)signature.getValue();
    }

    public static FileObject findFileObjectByClassName(final String className, Project project) {
        if (className == null) {
            return null;
        }
        final OutputParameter resolvedFileObject = new OutputParameter(null);
        JavaSource js = SourceUtils.getSources(project);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    TypeElement resolvedClass = SourceUtils.resolveClassByName(className, controller);
                    if (resolvedClass != null) {
                        resolvedFileObject.setValue((Object)org.netbeans.api.java.source.SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)resolvedClass), (ClasspathInfo)controller.getClasspathInfo()));
                    }
                }
            }, false);
        }
        catch (IOException ex) {
            ProfilerLogger.log((Exception)ex);
        }
        return (FileObject)resolvedFileObject.getValue();
    }

    public static Set<ElementHandle<TypeElement>> findImplementors(ClasspathInfo cpInfo, final String superType) {
        final HashSet<ClassIndex.SearchKind> kind = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
        final HashSet<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        final OutputParameter implementors = new OutputParameter(new HashSet());
        JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    TypeElement superElement = controller.getElements().getTypeElement(superType);
                    if (!superElement.getModifiers().contains((Object)Modifier.FINAL)) {
                        implementors.setValue((Object)controller.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)superElement), kind, scope));
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return (Set)implementors.getValue();
    }

    public static Set<TypeElement> findImplementorsResolved(ClasspathInfo cpInfo, final String superType) {
        final HashSet<ClassIndex.SearchKind> kind = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
        final HashSet<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        final HashSet<TypeElement> implementors = new HashSet<TypeElement>();
        JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    if (controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                        return;
                    }
                    TypeElement superElement = controller.getElements().getTypeElement(superType);
                    if (!superElement.getModifiers().contains((Object)Modifier.FINAL)) {
                        for (ElementHandle handle : controller.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)superElement), kind, scope)) {
                            implementors.add(handle.resolve((CompilationInfo)controller));
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return implementors;
    }

    public static Collection<String> findMainClasses(FileObject[] roots) {
        ArrayList<String> classNames = new ArrayList<String>();
        Collection mainElements = org.netbeans.api.java.source.SourceUtils.getMainClasses((FileObject[])roots);
        for (ElementHandle mainElement : mainElements) {
            classNames.add(mainElement.getQualifiedName());
        }
        return classNames;
    }

    public static boolean hasMainMethod(FileObject javaFile) {
        if (!SourceUtils.isJavaFile(javaFile)) {
            return false;
        }
        return !org.netbeans.api.java.source.SourceUtils.getMainClasses((FileObject)javaFile).isEmpty();
    }

    public static ResolvedClass resolveClassAtPosition(FileObject fo, final int position, final boolean resolveField) {
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        final OutputParameter resolvedClass = new OutputParameter(null);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController ci) throws Exception {
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePath path = ci.getTreeUtilities().pathFor(position);
                    if (path == null) {
                        return;
                    }
                    Element element = ci.getTrees().getElement(path);
                    if (element == null) {
                        return;
                    }
                    if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.ENUM) {
                        TypeElement jclass = (TypeElement)element;
                        String vmClassName = ElementUtilities.getBinaryName((TypeElement)jclass);
                        resolvedClass.setValue((Object)new ResolvedClass(jclass, vmClassName));
                        return;
                    }
                    if (resolveField && (element.getKind() == ElementKind.FIELD || element.getKind() == ElementKind.LOCAL_VARIABLE) && element.asType().getKind() == TypeKind.DECLARED) {
                        TypeMirror jclassMirror = ci.getTypes().erasure(element.asType());
                        TypeElement jclass = (TypeElement)ci.getTypes().asElement(jclassMirror);
                        String vmClassName = ElementUtilities.getBinaryName((TypeElement)jclass);
                        resolvedClass.setValue((Object)new ResolvedClass(jclass, vmClassName));
                        return;
                    }
                }
            }, true);
        }
        catch (IOException ioex) {
            ProfilerLogger.log((Exception)ioex);
            ioex.printStackTrace();
            return null;
        }
        return (ResolvedClass)resolvedClass.getValue();
    }

    public static TypeElement resolveClassByName(final String className, Project project) {
        if (className == null || project == null) {
            return null;
        }
        JavaSource js = SourceUtils.getSources(project);
        final TypeElement[] rslt = new TypeElement[1];
        if (js != null) {
            try {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        rslt[0] = SourceUtils.resolveClassByName(className, cc);
                    }
                }, false);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
        return rslt[0];
    }

    public static TypeElement resolveClassByName(String className, CompilationController controller) {
        TypeElement mainClass;
        block9: {
            if (className == null || controller == null) {
                return null;
            }
            mainClass = controller.getElements().getTypeElement(className.replace('$', '.'));
            if (mainClass == null) {
                try {
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    int innerSeparatorIndex = className.indexOf(36);
                    if (innerSeparatorIndex <= 0) break block9;
                    final String origClassName = className;
                    className = className.substring(0, innerSeparatorIndex);
                    mainClass = controller.getElements().getTypeElement(className);
                    if (mainClass == null) break block9;
                    FileObject fo = org.netbeans.api.java.source.SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)mainClass), (ClasspathInfo)controller.getClasspathInfo());
                    final OutputParameter mainClassElement = new OutputParameter((Object)mainClass);
                    try {
                        JavaSource.forFileObject((FileObject)fo).runUserActionTask((Task)new CancellableTask<CompilationController>(){
                            private volatile boolean isCancelled = false;

                            public void cancel() {
                                this.isCancelled = true;
                            }

                            public void run(final CompilationController cc) throws Exception {
                                cc.toPhase(JavaSource.Phase.RESOLVED);
                                TreePathScanner<Void, String> scanner = new TreePathScanner<Void, String>(){

                                    @Override
                                    public Void visitClass(ClassTree node, String p) {
                                        if (isCancelled) {
                                            return null;
                                        }
                                        Element classElement = cc.getTrees().getElement(this.getCurrentPath());
                                        if (classElement != null && classElement.getKind() == ElementKind.CLASS && ElementUtilities.getBinaryName((TypeElement)((TypeElement)classElement)).equals(p)) {
                                            mainClassElement.setValue((Object)((TypeElement)classElement));
                                            return null;
                                        }
                                        return (Void)super.visitClass(node, p);
                                    }
                                };
                                scanner.scan(cc.getCompilationUnit(), origClassName);
                            }
                        }, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    mainClass = (TypeElement)mainClassElement.getValue();
                }
                catch (IOException e) {
                    ProfilerLogger.log((Exception)e);
                }
            }
        }
        if (mainClass != null) {
            ProfilerLogger.debug((String)("Resolved: " + mainClass));
        } else {
            ProfilerLogger.debug((String)("Could not resolve: " + className));
        }
        if (mainClass == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SourceUtils.class, (String)"MDRUtils_ClassNotResolvedMessage", (Object)className));
        }
        return mainClass;
    }

    public static ResolvedMethod resolveMethodAtPosition(FileObject fo, final int position) {
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        final OutputParameter resolvedMethod = new OutputParameter(null);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController ci) throws Exception {
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePath path = ci.getTreeUtilities().pathFor(position);
                    if (path == null) {
                        return;
                    }
                    Element element = ci.getTrees().getElement(path);
                    if (element != null && (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR || element.getKind() == ElementKind.STATIC_INIT)) {
                        ExecutableElement method = (ExecutableElement)element;
                        String vmClassName = ElementUtilities.getBinaryName((TypeElement)((TypeElement)method.getEnclosingElement()));
                        String vmMethodName = SourceUtils.getVMMethodName(method);
                        String vmMethodSignature = SourceUtils.getVMMethodSignature(method, (CompilationInfo)ci);
                        resolvedMethod.setValue((Object)new ResolvedMethod(method, vmClassName, vmMethodName, vmMethodSignature));
                    }
                }
            }, true);
        }
        catch (IOException ioex) {
            ProfilerLogger.log((Exception)ioex);
            ioex.printStackTrace();
            return null;
        }
        return (ResolvedMethod)resolvedMethod.getValue();
    }

    private static boolean isEnclosingElement(Element element) {
        if (element == null) {
            return false;
        }
        ElementKind kind = element.getKind();
        return kind == ElementKind.CLASS || kind == ElementKind.ENUM || kind == ElementKind.INTERFACE;
    }

    private static boolean isMainMethod(ExecutableElement method) {
        return org.netbeans.api.java.source.SourceUtils.isMainMethod((ExecutableElement)method);
    }

    private static String getParamsSignature(List<? extends VariableElement> params, CompilationInfo ci) {
        StringBuffer ret = new StringBuffer();
        Iterator<? extends VariableElement> it = params.iterator();
        while (it.hasNext()) {
            TypeMirror type = it.next().asType();
            String realTypeName = SourceUtils.getRealTypeName(ci, type);
            String typeVMSignature = VMUtils.typeToVMSignature((String)realTypeName);
            ret.append(typeVMSignature);
        }
        return ret.toString();
    }

    private static Set<ElementHandle<TypeElement>> getProjectTypes(FileObject[] roots, JavaSource js) {
        HashSet<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>();
        scope.add(ClassIndex.SearchScope.SOURCE);
        if (js != null) {
            return js.getClasspathInfo().getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, scope);
        }
        return null;
    }

    private static Set<ElementHandle<TypeElement>> getProjectTypes(Project project, JavaSource js) {
        return SourceUtils.getProjectTypes(ProjectUtilities.getSourceRoots(project, true), js);
    }

    private static String getRealTypeName(CompilationInfo ci, TypeMirror type) {
        return ((Object)ci.getTypes().erasure(type)).toString();
    }

    private static String getSignature(ExecutableElement method, CompilationInfo ci) {
        try {
            switch (method.getKind()) {
                case METHOD: 
                case CONSTRUCTOR: 
                case STATIC_INIT: {
                    String paramsVMSignature = SourceUtils.getParamsSignature(method.getParameters(), ci);
                    String retTypeVMSignature = VMUtils.typeToVMSignature((String)SourceUtils.getRealTypeName(ci, method.getReturnType()));
                    return "(" + paramsVMSignature + ")" + retTypeVMSignature;
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning(e.getMessage());
            return null;
        }
    }

    public static JavaSource getSources(Project project) {
        if (project == null) {
            return SourceUtils.getSources((FileObject[])null);
        }
        return SourceUtils.getSources(ProjectUtilities.getSourceRoots(project, true));
    }

    private static JavaSource getSources(FileObject[] roots) {
        ClassPath compilePath;
        ClassPath bootPath;
        ClassPath srcPath;
        if (roots == null || roots.length == 0) {
            srcPath = ClassPathSupport.createProxyClassPath((ClassPath[])GlobalPathRegistry.getDefault().getPaths("classpath/source").toArray(new ClassPath[0]));
            bootPath = JavaPlatform.getDefault().getBootstrapLibraries();
            compilePath = ClassPathSupport.createProxyClassPath((ClassPath[])GlobalPathRegistry.getDefault().getPaths("classpath/compile").toArray(new ClassPath[0]));
        } else {
            srcPath = ClassPathSupport.createClassPath((FileObject[])roots);
            bootPath = ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/boot");
            compilePath = ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/compile");
        }
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)bootPath, (ClassPath)compilePath, (ClassPath)srcPath);
        return JavaSource.create((ClasspathInfo)cpInfo, Collections.emptyList());
    }

    private static boolean methodNameMatch(String vmName, ExecutableElement ee) {
        switch (ee.getKind()) {
            case METHOD: {
                return ee.getSimpleName().contentEquals(vmName);
            }
            case CONSTRUCTOR: {
                return vmName.equals(VM_CONSTRUCTUR_SIG);
            }
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                return vmName.equals(VM_INITIALIZER_SIG);
            }
        }
        return false;
    }

    private static boolean methodSignatureMatch(CompilationInfo ci, String vmSig, ExecutableElement ee) {
        return SourceUtils.getVMMethodSignature(ee, ci).equals(vmSig);
    }

    public static ExecutableElement resolveMethodByName(CompilationInfo ci, TypeElement parentClass, String methodName, String signature) {
        if (parentClass == null || methodName == null) {
            return null;
        }
        ExecutableElement foundMethod = null;
        boolean found = false;
        List<ExecutableElement> methods = null;
        methods = methodName.equals(VM_CONSTRUCTUR_SIG) ? ElementFilter.constructorsIn(ci.getElements().getAllMembers(parentClass)) : ElementFilter.methodsIn(ci.getElements().getAllMembers(parentClass));
        for (ExecutableElement method : methods) {
            if (!SourceUtils.methodNameMatch(methodName, method)) continue;
            if (signature != null && SourceUtils.methodSignatureMatch(ci, signature, method)) {
                foundMethod = method;
                found = true;
                break;
            }
            foundMethod = method;
        }
        if (!found) {
            ProfilerLogger.debug((String)("Could not find exact signature match, opening at first method with same name: " + foundMethod));
        }
        return foundMethod;
    }

    private static int validateOffset(FileObject editorDoc, final int toValidate) {
        final OutputParameter validated = new OutputParameter((Object)-1);
        JavaSource js = JavaSource.forFileObject((FileObject)editorDoc);
        if (js != null) {
            try {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.RESOLVED);
                        validated.setValue((Object)-1);
                        Scope sc = controller.getTreeUtilities().scopeFor(toValidate);
                        if (sc.getEnclosingClass() != null) {
                            validated.setValue((Object)toValidate);
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return (Integer)validated.getValue();
    }

    public static class ResolvedMethod {
        private ExecutableElement method;
        private String vmClassName;
        private String vmMethodName;
        private String vmMethodSignature;

        ResolvedMethod(ExecutableElement method, String className, String methodName, String methodSignature) {
            this.method = method;
            this.vmClassName = className;
            this.vmMethodName = methodName;
            this.vmMethodSignature = methodSignature;
        }

        public ExecutableElement getMethod() {
            return this.method;
        }

        public String getVMClassName() {
            return this.vmClassName;
        }

        public String getVMMethodName() {
            return this.vmMethodName;
        }

        public String getVMMethodSignature() {
            return this.vmMethodSignature;
        }
    }

    public static class ResolvedClass {
        private String vmClassName;
        private TypeElement jclass;

        ResolvedClass(TypeElement jclass, String className) {
            this.jclass = jclass;
            this.vmClassName = className;
        }

        public TypeElement getJClass() {
            return this.jclass;
        }

        public String getVMClassName() {
            return this.vmClassName;
        }
    }
}

