/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.EventListener;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.ColoringMap;
import org.openide.ErrorManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class GlyphGutter
extends JComponent
implements Annotations.AnnotationsListener,
Accessible,
SideBarFactory {
    private static final Logger LOG = Logger.getLogger(GlyphGutter.class.getName());
    private EditorUI editorUI;
    private Annotations annos;
    private Image gutterButton;
    private Color backgroundColor;
    private Color foreColor;
    private Font font;
    private boolean init;
    private int glyphGutterWidth;
    private static final int glyphWidth = 16;
    private static final int glyphButtonWidth = 9;
    private static final int leftGap = 10;
    private static final int rightGap = 4;
    private boolean showLineNumbers = true;
    private static final int ENLARGE_GUTTER_HEIGHT = 300;
    private int highestLineNumber = 0;
    private boolean drawOverLineNumbers = false;
    private volatile int cachedCountOfAnnos = -1;
    private int cachedCountOfAnnosForLine = -1;
    private PropertyChangeListener annoTypesListener;
    private PropertyChangeListener editorUIListener;
    private GlyphGutterFoldHierarchyListener glyphGutterFoldHierarchyListener;
    private GutterMouseListener gutterMouseListener;
    private FoldHierarchy foldHierarchy;
    private ColoringMap coloringMap;
    private final PropertyChangeListener coloringMapListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || "ColoringMap.PROP_COLORING_MAP".equals(evt.getPropertyName())) {
                GlyphGutter.this.update();
            }
        }
    };
    private Preferences prefs = null;
    private final PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            Rectangle rect;
            EditorUI eui = GlyphGutter.this.editorUI == null ? null : GlyphGutter.this.editorUI;
            JTextComponent c = eui == null ? null : eui.getComponent();
            Rectangle rectangle = rect = c == null ? null : c.getVisibleRect();
            if (rect != null && rect.width == 0) {
                if (SwingUtilities.isEventDispatchThread()) {
                    GlyphGutter.this.resize();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GlyphGutter.this.resize();
                        }
                    });
                }
            }
        }
    };
    private static final Color DEFAULT_GUTTER_LINE = new Color(184, 184, 184);
    private Rectangle toRepaint = null;
    private final Object toRepaintLock = new Object();
    private static final int REPAINT_TASK_DELAY = 50;
    private final RequestProcessor.Task repaintTask = new RequestProcessor(GlyphGutter.class.getName(), 1, false, false).create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Rectangle repaint;
            Object object = GlyphGutter.this.toRepaintLock;
            synchronized (object) {
                repaint = GlyphGutter.this.toRepaint;
                GlyphGutter.this.toRepaint = null;
            }
            if (repaint != null) {
                GlyphGutter.this.doRepaint(repaint);
            }
        }
    });

    public GlyphGutter() {
    }

    public GlyphGutter(EditorUI editorUI) {
        this.editorUI = editorUI;
        this.init = false;
        this.annos = editorUI.getDocument().getAnnotations();
        this.annos.addAnnotationsListener(this);
        this.init();
        this.update();
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)editorUI.getComponent());
        this.glyphGutterFoldHierarchyListener = new GlyphGutterFoldHierarchyListener();
        this.foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this.glyphGutterFoldHierarchyListener);
        this.editorUIListener = new EditorUIListener();
        editorUI.addPropertyChangeListener(this.editorUIListener);
        editorUI.getComponent().addPropertyChangeListener(this.editorUIListener);
        this.setOpaque(true);
        String mimeType = DocumentUtilities.getMimeType((JTextComponent)editorUI.getComponent());
        this.coloringMap = ColoringMap.get(mimeType);
        this.coloringMap.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.coloringMapListener, (Object)this.coloringMap));
        this.prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
        this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs));
        this.prefsListener.preferenceChange(null);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    protected void init() {
        if (this.editorUI == null) {
            return;
        }
        this.gutterButton = ImageUtilities.loadImage((String)"org/netbeans/editor/resources/glyphbutton.gif");
        this.setToolTipText("");
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(BaseKit.class).getString("ACSN_Glyph_Gutter"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BaseKit.class).getString("ACSD_Glyph_Gutter"));
        this.gutterMouseListener = new GutterMouseListener();
        this.addMouseListener(this.gutterMouseListener);
        this.addMouseMotionListener(this.gutterMouseListener);
        this.annoTypesListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().equals("glyphsOverLineNumbers") || evt.getPropertyName().equals("showGlyphGutter")) {
                    GlyphGutter.this.update();
                }
            }
        };
        AnnotationTypes.getTypes().addPropertyChangeListener(this.annoTypesListener);
    }

    public void update() {
        if (this.editorUI == null) {
            return;
        }
        Coloring lineColoring = this.editorUI.getColoringMap().get("line-number");
        Coloring defaultColoring = this.editorUI.getDefaultColoring();
        if (lineColoring == null) {
            return;
        }
        Color backColor = lineColoring.getBackColor();
        this.backgroundColor = org.openide.util.Utilities.isMac() ? backColor : UIManager.getColor("NbEditorGlyphGutter.background");
        if (null == this.backgroundColor) {
            this.backgroundColor = backColor != null ? backColor : defaultColoring.getBackColor();
        }
        this.foreColor = lineColoring.getForeColor() != null ? lineColoring.getForeColor() : defaultColoring.getForeColor();
        if (lineColoring.getFont() != null) {
            Font lineFont = lineColoring.getFont();
            this.font = lineFont != null ? lineFont.deriveFont((float)lineFont.getSize() - 1.0f) : null;
        } else {
            this.font = defaultColoring.getFont();
            this.font = new Font("Monospaced", 0, this.font.getSize() - 1);
        }
        this.showLineNumbers = this.editorUI.lineNumberVisibleSetting;
        this.drawOverLineNumbers = AnnotationTypes.getTypes().isGlyphsOverLineNumbers();
        this.init = true;
        this.highestLineNumber = this.getLineCount();
        this.repaint();
        this.resize();
    }

    protected void resize() {
        EditorUI eui = this.editorUI;
        if (eui != null) {
            Dimension dim = new Dimension();
            dim.width = this.glyphGutterWidth = this.getWidthDimension();
            dim.height = this.getHeightDimension();
            dim.height += 300 * eui.getLineHeight();
            this.setPreferredSize(dim);
            this.revalidate();
            this.putDimensionForPrinting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLineCount() {
        int lineCnt;
        block6: {
            try {
                BaseDocument document;
                BaseDocument baseDocument = document = this.editorUI != null ? this.editorUI.getDocument() : null;
                if (document != null) {
                    document.readLock();
                    try {
                        lineCnt = Utilities.getLineOffset(document, document.getLength()) + 1;
                        break block6;
                    }
                    finally {
                        document.readUnlock();
                    }
                }
                lineCnt = 1;
            }
            catch (BadLocationException e) {
                lineCnt = 1;
            }
        }
        return lineCnt;
    }

    protected int getDigitCount(int number) {
        return Integer.toString(number).length();
    }

    protected int getLineNumberWidth() {
        int newWidth = 0;
        if (this.editorUI != null) {
            newWidth += this.getDigitCount(this.highestLineNumber) * this.editorUI.getLineNumberDigitWidth();
        }
        return newWidth;
    }

    protected int getWidthDimension() {
        int newWidth = 0;
        if (this.showLineNumbers) {
            int lineNumberWidth = this.getLineNumberWidth();
            newWidth = 10 + lineNumberWidth + 4;
        } else if (this.editorUI != null) {
            if (this.annos.isGlyphColumn() || AnnotationTypes.getTypes().isShowGlyphGutter().booleanValue()) {
                newWidth += 16;
            }
            if (this.annos.isGlyphButtonColumn()) {
                newWidth += 9;
            }
        }
        return newWidth;
    }

    protected int getHeightDimension() {
        if (this.editorUI == null) {
            return 0;
        }
        JTextComponent comp = this.editorUI.getComponent();
        if (comp == null) {
            return 0;
        }
        return this.highestLineNumber * this.editorUI.getLineHeight() + (int)comp.getSize().getHeight();
    }

    void paintGutterForView(Graphics g, View view, int y) {
        Image annoGlyph;
        if (this.editorUI == null) {
            return;
        }
        JTextComponent component = this.editorUI.getComponent();
        if (component == null) {
            return;
        }
        BaseTextUI textUI = (BaseTextUI)component.getUI();
        g.setFont(this.font);
        g.setColor(this.foreColor);
        FontMetrics fm = FontMetricsCache.getFontMetrics(this.font, this);
        Element rootElem = textUI.getRootView(component).getElement();
        int line = rootElem.getElementIndex(view.getStartOffset());
        int lineWithAnno = this.annos.getNextLineWithAnnotation(line);
        int lineNumberWidth = fm.stringWidth(String.valueOf(line + 1));
        int count = this.annos.getNumberOfAnnotations(line);
        AnnotationDesc anno = this.annos.getActiveAnnotation(line);
        Image image = annoGlyph = anno != null ? anno.getGlyph() : null;
        if (this.showLineNumbers) {
            boolean glyphHasIcon = false;
            if (!(line != lineWithAnno || anno == null || anno.isDefaultGlyph() && count == 1 || annoGlyph == null)) {
                glyphHasIcon = true;
            }
            if (!glyphHasIcon || !this.drawOverLineNumbers || this.drawOverLineNumbers && line != lineWithAnno) {
                g.drawString(String.valueOf(line + 1), this.glyphGutterWidth - lineNumberWidth - 4, y + this.editorUI.getLineAscent());
            }
        }
        if (line == lineWithAnno) {
            int xPos;
            int n = xPos = this.showLineNumbers ? this.getLineNumberWidth() : 0;
            if (this.drawOverLineNumbers) {
                xPos = this.getWidth() - 16;
                if (count > 1) {
                    xPos -= 9;
                }
            }
            if (annoGlyph != null) {
                int lineHeight = this.editorUI.getLineHeight();
                int glyphHeight = annoGlyph.getHeight(null);
                if (count != 1 || !anno.isDefaultGlyph()) {
                    g.drawImage(annoGlyph, xPos, y + (lineHeight - glyphHeight) / 2 + 1, null);
                }
                if (count > 1) {
                    g.drawImage(this.gutterButton, xPos + 16 - 1, y + (lineHeight - glyphHeight) / 2, null);
                }
            }
            lineWithAnno = this.annos.getNextLineWithAnnotation(line + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        block15: {
            super.paintComponent(g);
            if (this.editorUI == null) {
                return;
            }
            String mimeType = DocumentUtilities.getMimeType((JTextComponent)this.editorUI.getComponent());
            FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)mimeType).lookup(FontColorSettings.class);
            Map hints = (Map)fcs.getFontColors("default").getAttribute(EditorStyleConstants.RenderingHints);
            if (!hints.isEmpty()) {
                ((Graphics2D)g).setRenderingHints(hints);
            }
            if (!this.init) {
                return;
            }
            Rectangle clip = g.getClipBounds();
            JTextComponent component = this.editorUI.getComponent();
            if (component == null) {
                return;
            }
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            View rootView = Utilities.getDocumentView(component);
            if (rootView == null) {
                return;
            }
            g.setColor(this.backgroundColor);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            g.setColor(DEFAULT_GUTTER_LINE);
            g.drawLine(this.glyphGutterWidth - 1, clip.y, this.glyphGutterWidth - 1, clip.height + clip.y);
            AbstractDocument dd = (AbstractDocument)component.getDocument();
            dd.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int startPos = textUI.getPosFromY(clip.y);
                    int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                    int rootViewCount = rootView.getViewCount();
                    if (startViewIndex < 0 || startViewIndex >= rootViewCount) break block15;
                    int clipEndY = clip.y + clip.height;
                    for (int i = startViewIndex; i < rootViewCount; ++i) {
                        View view = rootView.getView(i);
                        int y = textUI.getYFromPos(view.getStartOffset());
                        if (y >= clipEndY) {
                            break;
                        }
                        this.paintGutterForView(g, view, y);
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
            finally {
                dd.readUnlock();
            }
        }
    }

    private void doRepaint(Rectangle r) {
        this.repaint(r);
        this.checkSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedLine(int line) {
        block11: {
            JTextComponent component;
            if (!this.init || this.editorUI == null) {
                return;
            }
            this.cachedCountOfAnnos = -1;
            if (line > 0) {
                --line;
            }
            if ((component = this.editorUI.getComponent()) != null) {
                BaseTextUI textUI = (BaseTextUI)component.getUI();
                try {
                    Element rootElem = component.getDocument().getDefaultRootElement();
                    if (line >= rootElem.getElementCount()) {
                        return;
                    }
                    Element lineElem = rootElem.getElement(line);
                    if (lineElem == null) {
                        return;
                    }
                    int lineOffset = lineElem.getStartOffset();
                    int y = textUI.getYFromPos(lineOffset);
                    Rectangle r = new Rectangle(0, y, (int)this.getSize().getWidth(), 3 * this.editorUI.getLineHeight());
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.doRepaint(r);
                        break block11;
                    }
                    Object object = this.toRepaintLock;
                    synchronized (object) {
                        this.toRepaint = this.toRepaint != null ? this.toRepaint.union(r) : r;
                        this.repaintTask.schedule(50);
                    }
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify((Throwable)ble);
                }
            }
        }
    }

    @Override
    public void changedAll() {
        if (!this.init || this.editorUI == null) {
            return;
        }
        this.cachedCountOfAnnos = -1;
        Utilities.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                GlyphGutter.this.repaint();
                GlyphGutter.this.checkSize();
            }
        });
    }

    protected void checkSize() {
        int count = this.getLineCount();
        if (count != this.highestLineNumber) {
            this.highestLineNumber = count;
        }
        Dimension dim = this.getPreferredSize();
        if (this.getWidthDimension() != dim.width || this.getHeightDimension() > dim.height) {
            this.resize();
        }
        this.putDimensionForPrinting();
    }

    private void putDimensionForPrinting() {
        this.putClientProperty("print.size", new Dimension(this.getWidthDimension(), this.getHeightDimension()));
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.editorUI == null) {
            return null;
        }
        int line = this.getLineFromMouseEvent(e);
        if (this.annos.getNumberOfAnnotations(line) == 0) {
            return null;
        }
        if (this.isMouseOverCycleButton(e) && this.annos.getNumberOfAnnotations(line) > 1) {
            return MessageFormat.format(NbBundle.getBundle(BaseKit.class).getString("cycling-glyph_tooltip"), new Integer(this.annos.getNumberOfAnnotations(line)));
        }
        if (this.isMouseOverGlyph(e)) {
            return this.annos.getActiveAnnotation(line).getShortDescription();
        }
        return null;
    }

    private int getXPosOfGlyph(int line) {
        if (this.editorUI == null) {
            return -1;
        }
        if (this.cachedCountOfAnnos == -1 || this.cachedCountOfAnnosForLine != line) {
            this.cachedCountOfAnnos = this.annos.getNumberOfAnnotations(line);
            this.cachedCountOfAnnosForLine = line;
        }
        if (this.cachedCountOfAnnos > 0) {
            int xPos;
            int n = xPos = this.showLineNumbers ? this.getLineNumberWidth() : 0;
            if (this.drawOverLineNumbers) {
                xPos = this.getWidth() - 16;
                if (this.cachedCountOfAnnos > 1) {
                    xPos -= 9;
                }
            }
            return xPos;
        }
        return -1;
    }

    private boolean isMouseOverGlyph(MouseEvent e) {
        int line = this.getLineFromMouseEvent(e);
        int xPos = this.getXPosOfGlyph(line);
        return xPos != -1 && e.getX() >= xPos && e.getX() <= xPos + 16;
    }

    private boolean isMouseOverCycleButton(MouseEvent e) {
        int line = this.getLineFromMouseEvent(e);
        int xPos = this.getXPosOfGlyph(line);
        return xPos != -1 && e.getX() >= xPos + 16 && e.getX() <= xPos + 16 + 9;
    }

    @Override
    public JComponent createSideBar(JTextComponent target) {
        EditorUI eui = Utilities.getEditorUI(target);
        if (eui == null) {
            return null;
        }
        GlyphGutter glyph = new GlyphGutter(eui);
        eui.setGlyphGutter(glyph);
        return glyph;
    }

    private int getLineFromMouseEvent(MouseEvent e) {
        int line = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent component = this.editorUI.getComponent();
                BaseDocument document = this.editorUI.getDocument();
                BaseTextUI textUI = (BaseTextUI)component.getUI();
                int clickOffset = textUI.viewToModel(component, new Point(0, e.getY()));
                line = Utilities.getLineOffset(document, clickOffset);
            }
            catch (BadLocationException ble) {
                LOG.log(Level.WARNING, null, ble);
            }
        }
        return line;
    }

    class EditorUIListener
    implements PropertyChangeListener {
        EditorUIListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof EditorUI) {
                if ((evt.getPropertyName() == null || "component".equals(evt.getPropertyName())) && evt.getNewValue() == null) {
                    GlyphGutter.this.editorUI.removePropertyChangeListener(this);
                    if (evt.getOldValue() instanceof JTextComponent) {
                        ((JTextComponent)evt.getOldValue()).removePropertyChangeListener(this);
                    }
                    GlyphGutter.this.annos.removeAnnotationsListener(GlyphGutter.this);
                    GlyphGutter.this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)GlyphGutter.this.glyphGutterFoldHierarchyListener);
                    if (GlyphGutter.this.gutterMouseListener != null) {
                        GlyphGutter.this.removeMouseListener(GlyphGutter.this.gutterMouseListener);
                        GlyphGutter.this.removeMouseMotionListener(GlyphGutter.this.gutterMouseListener);
                    }
                    if (GlyphGutter.this.annoTypesListener != null) {
                        AnnotationTypes.getTypes().removePropertyChangeListener(GlyphGutter.this.annoTypesListener);
                    }
                    GlyphGutter.this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)GlyphGutter.this.glyphGutterFoldHierarchyListener);
                    GlyphGutter.this.foldHierarchy = null;
                    GlyphGutter.this.editorUI = null;
                    GlyphGutter.this.annos = null;
                }
            } else if (evt.getSource() instanceof JTextComponent && (evt.getPropertyName() == null || "document".equals(evt.getPropertyName()))) {
                GlyphGutter.this.annos.removeAnnotationsListener(GlyphGutter.this);
                GlyphGutter.this.annos = GlyphGutter.this.editorUI.getDocument().getAnnotations();
                GlyphGutter.this.annos.addAnnotationsListener(GlyphGutter.this);
                GlyphGutter.this.update();
            }
        }
    }

    class GlyphGutterFoldHierarchyListener
    implements FoldHierarchyListener,
    Runnable {
        public void foldHierarchyChanged(FoldHierarchyEvent evt) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            GlyphGutter.this.repaint();
        }
    }

    class GutterMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private int dragStartOffset = -1;
        private int dragEndOffset;

        GutterMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (GlyphGutter.this.editorUI == null) {
                return;
            }
            if (e.getModifiers() == 16) {
                if (GlyphGutter.this.isMouseOverCycleButton(e)) {
                    int line = GlyphGutter.this.getLineFromMouseEvent(e);
                    e.consume();
                    GlyphGutter.this.annos.activateNextAnnotation(line);
                } else {
                    Action[] actions = ImplementationProvider.getDefault().getGlyphGutterActions(GlyphGutter.this.editorUI.getComponent());
                    if (actions != null && actions.length > 0) {
                        Action a = actions[0];
                        if (a != null && a.isEnabled()) {
                            int currentLine = -1;
                            int line = GlyphGutter.this.getLineFromMouseEvent(e);
                            if (line == -1) {
                                return;
                            }
                            BaseDocument document = GlyphGutter.this.editorUI.getDocument();
                            try {
                                currentLine = Utilities.getLineOffset(document, GlyphGutter.this.editorUI.getComponent().getCaret().getDot());
                            }
                            catch (BadLocationException ex) {
                                return;
                            }
                            if (line != currentLine) {
                                int offset = Utilities.getRowStartFromLineOffset(document, line);
                                JumpList.checkAddEntry();
                                GlyphGutter.this.editorUI.getComponent().getCaret().setDot(offset);
                            }
                            e.consume();
                            a.actionPerformed(new ActionEvent(GlyphGutter.this.editorUI.getComponent(), 0, ""));
                            GlyphGutter.this.repaint();
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }

        private void showPopup(MouseEvent e) {
            if (GlyphGutter.this.editorUI == null) {
                return;
            }
            if (e.isPopupTrigger()) {
                int offset;
                int line = GlyphGutter.this.getLineFromMouseEvent(e);
                if (GlyphGutter.this.annos.getActiveAnnotation(line) != null) {
                    offset = GlyphGutter.this.annos.getActiveAnnotation(line).getOffset();
                } else {
                    BaseDocument document = GlyphGutter.this.editorUI.getDocument();
                    offset = Utilities.getRowStartFromLineOffset(document, line);
                }
                if (GlyphGutter.this.editorUI.getComponent().getCaret().getDot() != offset) {
                    JumpList.checkAddEntry();
                }
                GlyphGutter.this.editorUI.getComponent().getCaret().setDot(offset);
                JPopupMenu pm = GlyphGutter.this.annos.createPopupMenu(Utilities.getKit(GlyphGutter.this.editorUI.getComponent()), line);
                if (pm != null) {
                    e.consume();
                    pm.show(GlyphGutter.this, e.getX(), e.getY());
                    pm.addPopupMenuListener(new PopupMenuListener(){

                        @Override
                        public void popupMenuCanceled(PopupMenuEvent e2) {
                            GlyphGutter.this.editorUI.getComponent().requestFocus();
                        }

                        @Override
                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
                            GlyphGutter.this.editorUI.getComponent().requestFocus();
                        }

                        @Override
                        public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                        }
                    });
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
            if (!e.isConsumed() && (GlyphGutter.this.isMouseOverGlyph(e) || GlyphGutter.this.isMouseOverCycleButton(e))) {
                e.consume();
            }
            this.dragStartOffset = -1;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
            if (!e.isConsumed() && (GlyphGutter.this.isMouseOverGlyph(e) || GlyphGutter.this.isMouseOverCycleButton(e))) {
                e.consume();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent e) {
            JTextComponent component = GlyphGutter.this.editorUI.getComponent();
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            AbstractDocument aDoc = (AbstractDocument)component.getDocument();
            aDoc.readLock();
            try {
                Element rootElement = aDoc.getDefaultRootElement();
                int lineStartOffset = textUI.getPosFromY(e.getY());
                boolean updateDragEndOffset = false;
                if (this.dragStartOffset == -1) {
                    this.dragStartOffset = lineStartOffset;
                    this.dragEndOffset = lineStartOffset;
                } else if (this.dragStartOffset == this.dragEndOffset) {
                    if (lineStartOffset != this.dragStartOffset) {
                        updateDragEndOffset = true;
                    }
                } else {
                    updateDragEndOffset = true;
                }
                if (updateDragEndOffset) {
                    Caret caret = component.getCaret();
                    if (lineStartOffset >= this.dragStartOffset) {
                        if (caret.getMark() != this.dragStartOffset) {
                            caret.setDot(this.dragStartOffset);
                        }
                        this.dragEndOffset = Math.min(Utilities.getRowEnd((BaseDocument)aDoc, lineStartOffset) + 1, aDoc.getLength());
                    } else {
                        if (caret.getMark() == this.dragStartOffset) {
                            caret.setDot(Utilities.getRowEnd((BaseDocument)aDoc, this.dragStartOffset) + 1);
                        }
                        this.dragEndOffset = lineStartOffset;
                    }
                    component.moveCaretPosition(this.dragEndOffset);
                }
            }
            catch (BadLocationException ble) {
            }
            finally {
                aDoc.readUnlock();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

