/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.values;

import org.netbeans.modules.cnd.debugger.common2.values.Catalog;

public final class CountLimit {
    public static final String Keyword_INFINITY;
    public static final String Action_INFINITY;
    public static final String Action_DISABLE;
    public static final String Action_CURRENT;
    public static final CountLimit infinity;
    private static final long limit = 0xFFFFFFFEL;
    private final boolean enable;
    private final long count;
    private final String errorMessage;

    public CountLimit(long count) {
        boolean good = true;
        this.count = count;
        if (count == -2L) {
            this.enable = true;
        } else if (count == -1L) {
            this.enable = true;
        } else if (count == -3L) {
            this.enable = false;
        } else {
            this.enable = true;
            if (count < 0L) {
                good = false;
            } else if (count > 0xFFFFFFFEL) {
                good = false;
            }
        }
        this.errorMessage = !good ? Catalog.format("FMT_CountLimit_ERROR", count, 0, 0xFFFFFFFEL) : null;
    }

    public CountLimit(String text) {
        boolean good = true;
        if (text.equalsIgnoreCase(Action_INFINITY)) {
            text = "infinity";
        } else if (text.equals(Action_CURRENT)) {
            text = "current";
        } else if (text.equals(Action_DISABLE) || text.trim().equals("")) {
            text = null;
        }
        if (text == null) {
            this.enable = false;
            this.count = -3L;
        } else if (text.equals("infinity")) {
            this.enable = true;
            this.count = -1L;
        } else if (text.equals("current")) {
            this.enable = true;
            this.count = -2L;
        } else {
            this.enable = true;
            long preCount = 0L;
            try {
                preCount = Long.parseLong(text);
                if (preCount < 0L) {
                    good = false;
                } else if (preCount > 0xFFFFFFFEL) {
                    good = false;
                }
            }
            catch (NumberFormatException x) {
                good = false;
            }
            this.count = preCount;
        }
        this.errorMessage = !good ? Catalog.format("FMT_CountLimit_ERROR", text, 0, 0xFFFFFFFEL) : null;
    }

    public CountLimit possiblySetToCurrentCount(int currentCount) {
        if (this.count == -2L) {
            return new CountLimit(currentCount);
        }
        return this;
    }

    public long count() {
        return this.count;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        if (this.count == -3L) {
            return null;
        }
        if (this.count == -1L) {
            return Keyword_INFINITY;
        }
        return Long.toString(this.count);
    }

    static {
        Action_INFINITY = Keyword_INFINITY = Catalog.get("CountLimitKeyword_INFINITY");
        Action_DISABLE = Catalog.get("CountLimitAction_DISABLE");
        Action_CURRENT = Catalog.get("CountLimitAction_CURRENT");
        infinity = new CountLimit(Action_INFINITY);
    }
}

