/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlyweightAction
extends AbstractAction
implements HelpCtx.Provider,
Presenter.Toolbar,
Presenter.Popup {
    private Shared shared;
    private static final MouseInputAdapter sharedMouseListener = new MouseInputAdapter(){

        public void mouseEntered(MouseEvent evt) {
            JButton btn = (JButton)evt.getSource();
            if (btn.isEnabled()) {
                btn.setBorderPainted(true);
                btn.setContentAreaFilled(true);
            }
        }

        public void mouseExited(MouseEvent evt) {
            JButton btn = (JButton)evt.getSource();
            if (btn.isEnabled()) {
                btn.setBorderPainted(false);
                btn.setContentAreaFilled(false);
            }
        }
    };

    protected Shared shared() {
        return this.shared;
    }

    protected FlyweightAction(Class<? extends Shared> sharedClass) {
        this.shared = (Shared)SharedClassObject.findObject(sharedClass, (boolean)true);
        this.setEnabled(false);
    }

    @Override
    public final void putValue(String name, Object value) {
        this.shared.putValue(name, value);
    }

    @Override
    public Object getValue(String key) {
        return this.shared.getValue(key);
    }

    public final HelpCtx getHelpCtx() {
        return this.shared.getHelpCtx();
    }

    private Component fixButtonLF(Component c) {
        if (c instanceof JButton) {
            JButton b = (JButton)c;
            b.setBorderPainted(false);
            b.setContentAreaFilled(false);
            b.setFocusable(false);
            b.addMouseListener(sharedMouseListener);
        }
        return c;
    }

    public Component getToolbarPresenter() {
        JButton button = new JButton();
        this.fixButtonLF(button);
        if (this.shared.iconResource() != null) {
            button.putClientProperty("hideActionText", Boolean.TRUE);
        }
        button.setAction(this);
        if (this.getAccelerator() != null) {
            String ttt = button.getToolTipText();
            KeyStroke ks = this.getAccelerator();
            String ksText = " (";
            int modifiers = ks.getModifiers();
            if (modifiers > 0) {
                ksText = ksText + KeyEvent.getKeyModifiersText(modifiers);
                ksText = ksText + "+";
            }
            ksText = ksText + KeyEvent.getKeyText(ks.getKeyCode());
            ksText = ksText + ")";
            ttt = ttt + ksText;
            button.setToolTipText(ttt);
            button.setMnemonic(0);
        }
        return button;
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem menuItem = new JMenuItem();
        menuItem.setAction(this);
        if (this.shared.iconResource() != null) {
            menuItem.setIcon(null);
        }
        return menuItem;
    }

    public final Icon getIcon() {
        return this.shared.getIcon(false);
    }

    public String getName() {
        return (String)this.shared.getValue("Name");
    }

    public KeyStroke getAccelerator() {
        return this.shared.getAccelerator();
    }

    public void update() {
    }

    protected static abstract class Shared
    extends SharedClassObject {
        private static final String BLANK_ICON = "org/openide/resources/actions/empty.gif";
        private static ImageIcon blankIcon;
        private Icon image;

        protected Shared() {
            this.initialize();
        }

        protected abstract String iconResource();

        public abstract HelpCtx getHelpCtx();

        protected void initialize() {
            super.initialize();
        }

        protected void setMnemonic(char mnemonic) {
            this.putValue("MnemonicKey", new Integer(mnemonic));
        }

        protected void setAccelerator(String acceleratorStr) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(acceleratorStr));
        }

        public final void putValue(String name, Object value) {
            this.putProperty(name, value, true);
        }

        public Object getValue(String key) {
            if ("SmallIcon".equals(key)) {
                return this.getIcon(false);
            }
            return this.getProperty(key);
        }

        private static ImageIcon getBlankIcon() {
            if (blankIcon == null) {
                blankIcon = new ImageIcon(ImageUtilities.loadImage((String)BLANK_ICON, (boolean)true));
            }
            return blankIcon;
        }

        final Icon getIcon(boolean createLabel) {
            if (this.image == null) {
                String ir = this.iconResource();
                if (ir != null) {
                    Image i = ImageUtilities.loadImage((String)ir, (boolean)true);
                    if (i != null) {
                        this.image = new ImageIcon(i);
                    }
                } else assert (!createLabel);
            }
            return this.image;
        }

        public KeyStroke getAccelerator() {
            return (KeyStroke)this.getValue("AcceleratorKey");
        }
    }
}

