/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Platform;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.options.CatalogDynamic;
import org.netbeans.modules.cnd.debugger.common2.utils.options.Option;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionValue;
import org.netbeans.modules.cnd.debugger.common2.utils.options.Validity;

public class HostOption
extends Option {
    static CatalogDynamic catalog = new CatalogDynamic(HostOption.class);
    private static String default_platform = Platform.local().name();
    public static final HostOption HOST_PROP_PLATFORM = new HostOption("platform", new String[]{Platform.Solaris_Sparc.name(), Platform.Solaris_x86.name(), Platform.Linux_x86.name()}, default_platform, false, 3, true);
    public static final HostOption HOST_PROP_LOCATION = new HostOption("studio_location", null, false, 1, true);
    private static String username = System.getProperty("user.name");
    public static final HostOption HOST_PROP_LOGINNAME = new HostOption("login_name", username, false, 1, true);
    public static final HostOption HOST_PROP_REMEMBER_PASSWORD = new HostOption("remember_password", "off", false, 4, true){

        protected boolean canWrite(OptionSet optionSet) {
            return !"localhost".equals(HOST_PROP_HOSTNAME.getCurrValue(optionSet));
        }
    };
    public static final HostOption HOST_PROP_SSH_PORT = new HostOption("ssh_port", "22", false, 1, true){

        public Validity getValidity(String text) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                String err = Catalog.format("ERROR_BADPORT", new Object[0]);
                return Validity.FALSE(err);
            }
            return Validity.TRUE;
        }
    };
    public static final HostOption HOST_PROP_HOSTNAME = new HostOption("host_name", null, false, 1, true){

        public Validity getValidity(String text) {
            if (IpeUtils.isEmpty(text)) {
                String err = Catalog.get("ERROR_NOEMPTYHOSTNAME");
                return Validity.FALSE(Catalog.get("ERROR_NOEMPTYHOSTNAME"));
            }
            if ("localhost".equals(text)) {
                String err = Catalog.format("ERROR_NOLOCALHOST", "localhost");
                return Validity.FALSE(err);
            }
            return Validity.TRUE;
        }

        protected boolean canWrite(OptionSet optionSet) {
            return !"localhost".equals(this.getCurrValue(optionSet));
        }
    };

    public HostOption(String inName, String[] inValues, String inDefaultValue, boolean inIsEngineOption, int inType, boolean hasTooltip) {
        super(inName, catalog, inValues, inDefaultValue, inIsEngineOption, inType, hasTooltip, false);
    }

    public HostOption(String inName, String inDefaultValue, boolean inIsEngineOption, int inType, boolean hasTip) {
        super(inName, catalog, null, inDefaultValue, inIsEngineOption, inType, hasTip, false);
    }

    public Option getSubOption(String value) {
        return null;
    }

    public boolean verticalLayout() {
        return false;
    }

    public boolean overrideHasLabel() {
        return true;
    }

    public Option getSubOption() {
        return null;
    }

    public boolean isSubOption() {
        return false;
    }

    public Validity getValidity(String text) {
        return Validity.TRUE;
    }

    protected boolean canWrite(OptionSet optionSet) {
        return true;
    }

    public boolean isTrim() {
        return false;
    }

    public boolean persist(OptionValue value) {
        return true;
    }
}

