/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Platform;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.SecuritySettings;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.AuthenticationUtils;

class ExecHost
extends Host {
    private final ExecutionEnvironment exEnv;
    private final String hostName;
    private final String platform;

    public ExecHost(ExecutionEnvironment exEnv) {
        this.exEnv = exEnv;
        this.hostName = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)exEnv);
        PlatformInfo platformInfo = PlatformInfo.getDefault((ExecutionEnvironment)exEnv);
        int platformx = platformInfo.getPlatform();
        this.platform = ExecHost.platformByCNDId(platformx).name();
    }

    public ExecutionEnvironment executionEnvironment() {
        return this.exEnv;
    }

    public String getHostLogin() {
        return this.exEnv.getUser();
    }

    public String getHostName() {
        return this.exEnv.getHost();
    }

    public SecuritySettings getSecuritySettings() {
        return new SecuritySettings(this.exEnv.getSSHPort(), AuthenticationUtils.getSSHKeyFileFor((ExecutionEnvironment)this.exEnv));
    }

    public String getPlatformName() {
        return this.platform;
    }

    public int getPortNum() {
        return this.exEnv.getSSHPort();
    }

    public String getRemoteStudioLocation() {
        CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)this.exEnv);
        CompilerSet cs = csm.getCompilerSet("OracleSolarisStudio");
        if (cs == null) {
            cs = csm.getCompilerSet("SunStudio");
        }
        if (cs == null) {
            cs = csm.getDefaultCompilerSet();
        }
        if (cs != null) {
            String base = cs.getDirectory();
            if (Log.Remote.host) {
                System.out.printf("hostFromName() base %s\n", base);
            }
            return base + "/..";
        }
        return null;
    }

    public boolean isRemote() {
        return this.exEnv.isRemote();
    }

    private static Platform platformByCNDId(int id) {
        switch (id) {
            case 2: {
                return Platform.Linux_x86;
            }
            case 1: {
                return Platform.Solaris_x86;
            }
            case 0: {
                return Platform.Solaris_Sparc;
            }
            case 4: {
                return Platform.MacOSX_x86;
            }
            case 3: {
                return Platform.Windows_x86;
            }
        }
        return Platform.Unknown;
    }

    public String toString() {
        return "ExecHost: " + this.hostName;
    }
}

