/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import java.beans.PropertyChangeSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Exceptions;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Pathmap;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.ProfileSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Signals;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSetOwner;

public abstract class DbgProfile
extends ProfileSupport
implements OptionSetOwner {
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_INTERCEPTLIST = "interceptlist";
    public static final String PROP_SIGNALS = "signals";
    public static final String PROP_PATHMAP = "pathmap";
    protected OptionSet options;
    protected boolean savedBuildFirst;
    protected boolean buildFirstOverriden;
    protected Signals signals;
    protected Exceptions exceptions;
    protected Pathmap pathmap;
    protected String redirection;
    protected String host;

    public DbgProfile() {
    }

    protected DbgProfile(PropertyChangeSupport pcs) {
        super(pcs);
    }

    public void initialize() {
    }

    public OptionSet getOptions() {
        return this.options;
    }

    protected final void notifyOptionsChange() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_OPTIONS, null, null);
        }
        this.needSave = true;
    }

    public Pathmap pathmap() {
        return this.pathmap;
    }

    public Exceptions exceptions() {
        return this.exceptions;
    }

    public Signals signals() {
        return this.signals;
    }

    public String getRedirection() {
        return this.redirection;
    }

    public void setRedirection(String infile, String outfile, boolean append) {
        boolean in;
        StringBuffer sb = new StringBuffer();
        boolean bl = in = infile != null && infile.length() != 0;
        if (in) {
            sb.append("< ");
            sb.append(infile);
        }
        if (outfile != null && outfile.length() != 0) {
            if (in) {
                sb.append(" ");
            }
            if (append) {
                sb.append(">> ");
            } else {
                sb.append("> ");
            }
            sb.append(outfile);
        }
        if (sb.length() != 0) {
            this.redirection = sb.toString();
            this.needSave = true;
        }
    }

    public String getDefaultHost() {
        return "localhost";
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.needSave = true;
    }

    public boolean isDefaultHost() {
        return this.getHost().equals(this.getDefaultHost());
    }

    public void setBuildFirstOverriden(boolean buildFirstOverriden) {
        this.buildFirstOverriden = buildFirstOverriden;
        this.needSave = true;
    }

    public boolean isBuildFirstOverriden() {
        return this.buildFirstOverriden;
    }

    public boolean isSavedBuildFirst() {
        return this.savedBuildFirst;
    }

    public void setSavedBuildFirst(boolean savedBuildFirst) {
        this.savedBuildFirst = savedBuildFirst;
        this.needSave = true;
    }
}

