/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.Catalog;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminalProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class DebuggerExternalTerminal {
    private final String tty;
    private final long pid;
    private File gdbHelperLog = null;
    private File gdbHelperScript = null;
    private NativeProcess process = null;
    private final ExecutionEnvironment exEnv;
    private static final Logger log = Logger.getLogger(DebuggerExternalTerminal.class.toString());
    private static final int RETRY_LIMIT = 200;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DebuggerExternalTerminal(String termPath) {
        this.initGdbHelpers();
        this.exEnv = ExecutionEnvironmentFactory.getLocal();
        String termBaseName = CndPathUtilitities.getBaseName((String)termPath);
        if (ExternalTerminalProvider.getSupportedTerminalIDs().contains(termBaseName)) {
            NativeProcessBuilder npb = NativeProcessBuilder.newLocalProcessBuilder();
            ExternalTerminal terminal = ExternalTerminalProvider.getTerminal((ExecutionEnvironment)this.exEnv, (String)termBaseName);
            terminal = terminal.setTitle(Catalog.get("Title_Debugger_External_Terminal"));
            npb.useExternalTerminal(terminal);
            npb.setExecutable(this.gdbHelperScript.getAbsolutePath());
            npb.redirectError();
            try {
                this.process = npb.call();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        int count = 0;
        String tty_line = null;
        String pid_line = null;
        try {
            while (count++ < 200) {
                BufferedReader fromTerm = new BufferedReader(new FileReader(this.gdbHelperLog));
                tty_line = fromTerm.readLine();
                pid_line = fromTerm.readLine();
                fromTerm.close();
                if (pid_line != null) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                }
            }
            if (count >= 200) {
                log.warning("Retry limit reached for " + this.gdbHelperLog + ", giving up");
            }
        }
        catch (IOException ioe) {
            log.warning("Failed to read external terminal helper");
        }
        this.tty = tty_line;
        log.finest("ExternalTerminal: tty=" + this.tty);
        long pidTemp = 0L;
        try {
            pidTemp = Long.valueOf(pid_line);
        }
        catch (Exception ex) {
            log.warning("Error parsing pid: " + pid_line);
        }
        this.pid = pidTemp;
        log.finest("ExternalTerminal: pid=" + this.pid);
    }

    private void initGdbHelpers() {
        try {
            this.gdbHelperLog = File.createTempFile("gdb_helper_", ".log");
            this.gdbHelperScript = File.createTempFile("gdb_helper_", ".sh");
        }
        catch (IOException ex) {
            this.gdbHelperLog = new File("/tmp/gdb_helper.log");
            this.gdbHelperScript = new File("/tmp/gdb_helper.sh");
        }
        String content = NbBundle.getMessage(DebuggerExternalTerminal.class, (String)"GdbHelperScript", (Object)this.gdbHelperLog.getAbsolutePath());
        this.gdbHelperLog.deleteOnExit();
        this.gdbHelperScript.deleteOnExit();
        try {
            FileWriter fw = new FileWriter(this.gdbHelperScript);
            fw.write(content);
            fw.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            CommonTasksSupport.chmod((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal(), (String)this.gdbHelperScript.getAbsolutePath(), (int)493, null).get(30L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    String getTty() {
        return this.tty;
    }

    void finish() {
        this.gdbHelperScript.delete();
        this.gdbHelperLog.delete();
    }
}

