/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordList;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DebugTargetXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private RecordList<DebugTarget> model;
    private DebugTarget currentDT;
    private Collection<XMLDecoder> currentDTAuxDecoders;
    private int index;
    private static final String TAG_DEBUGTARGET = "debugtarget";
    private static final String ATTR_ID = "id";
    private static final String PROFILE_ID = "runprofile";
    private static final String TARGET_SETTINGS_ID = "settings";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    private static final String ENVIRONMENT_ELEMENT = "environment";
    private static final String CORE_ELEMENT = "core";
    private static final String EXEC_ELEMENT = "exec";
    private static final String ARGS_ELEMENT = "args";
    private static final String HOST_ELEMENT = "host";
    private static final String ENGINE_ELEMENT = "engine";
    private static final String RUNDIR_ELEMENT = "rundir";
    private static final String VARIABLE_ELEMENT = "variable";

    DebugTargetXMLCodec(RecordList<DebugTarget> model) {
        this.model = model;
    }

    DebugTargetXMLCodec(DebugTarget debugtarget, int index) {
        this.index = index;
        this.currentDT = debugtarget;
    }

    protected String tag() {
        return TAG_DEBUGTARGET;
    }

    public void start(Attributes atts) throws VersionException {
        String id = atts.getValue(ATTR_ID);
        if (Log.XML.debug) {
            System.out.println(" DebugTargetXMLCodec start: id " + id);
        }
        this.currentDT = new DebugTarget(id);
        this.model.appendRecord(this.currentDT);
        this.currentDTAuxDecoders = new ArrayList<XMLDecoder>();
        for (ConfigurationAuxObject configurationAuxObject : this.currentDT.getAuxProfiles()) {
            XMLDecoder decoder = configurationAuxObject.getXMLDecoder();
            this.registerXMLDecoder(decoder);
            this.currentDTAuxDecoders.add(decoder);
        }
    }

    public void end() {
        for (XMLDecoder decoder : this.currentDTAuxDecoders) {
            this.deregisterXMLDecoder(decoder);
        }
    }

    public void startElement(String element, Attributes atts) {
        if (Log.XML.debug) {
            System.out.println(" DebugTargetXMLCodec startElement: element " + element);
            System.out.println(" DebugTargetXMLCodec startElement: atts " + atts);
        }
        if (!element.equals(PROFILE_ID) && element.equals(VARIABLE_ELEMENT)) {
            this.currentDT.getRunProfile().getEnvironment().putenv(atts.getValue(0), atts.getValue(1));
        }
    }

    public void endElement(String element, String currentText) {
        if (Log.XML.debug) {
            System.out.println(" DebugTargetXMLCodec endElement: element " + element);
            System.out.println(" DebugTargetXMLCodec endElement: currentText " + currentText);
        }
        if (element.equals(CORE_ELEMENT)) {
            this.currentDT.setCorefile(currentText);
        } else if (element.equals(EXEC_ELEMENT)) {
            this.currentDT.setExecutable(currentText);
        } else if (element.equals(ARGS_ELEMENT)) {
            this.currentDT.getRunProfile().setArgs(currentText);
        } else if (element.equals(RUNDIR_ELEMENT)) {
            this.currentDT.getRunProfile().setRunDir(currentText);
        } else if (element.equals(HOST_ELEMENT)) {
            this.currentDT.setHostName(currentText);
        } else if (element.equals(ENGINE_ELEMENT)) {
            this.currentDT.setEngineByID(currentText);
        } else if (!element.equals(ENVIRONMENT_ELEMENT)) {
            try {
                int idx = Integer.parseInt(currentText);
            }
            catch (NumberFormatException ex) {
                boolean bl = false;
            }
        }
    }

    private static void encode(XMLEncoderStream xes, String[] pair) {
        xes.element(VARIABLE_ELEMENT, new AttrValuePair[]{new AttrValuePair(NAME_ATTR, "" + pair[0]), new AttrValuePair(VALUE_ATTR, "" + pair[1])});
    }

    private static void encode(XMLEncoderStream xes, Env env) {
        String[][] environment = env.getenvAsPairs();
        xes.elementOpen(ENVIRONMENT_ELEMENT);
        for (int i = 0; i < environment.length; ++i) {
            DebugTargetXMLCodec.encode(xes, environment[i]);
        }
        xes.elementClose(ENVIRONMENT_ELEMENT);
    }

    public void encode(XMLEncoderStream xes) {
        AttrValuePair[] id_attr = new AttrValuePair[]{new AttrValuePair(ATTR_ID, this.index + " " + this.currentDT.displayName())};
        xes.elementOpen(TAG_DEBUGTARGET, id_attr);
        this.encodeTargetSettings(xes);
        for (ConfigurationAuxObject configurationAuxObject : this.currentDT.getAuxProfiles()) {
            XMLEncoder auxProfileEncoder = configurationAuxObject.getXMLEncoder();
            auxProfileEncoder.encode(xes);
        }
        xes.elementClose(TAG_DEBUGTARGET);
    }

    private void encodeTargetSettings(XMLEncoderStream xes) {
        String engine = this.currentDT.getEngine().getDebuggerID();
        xes.element(ENGINE_ELEMENT, engine);
        xes.elementOpen(TARGET_SETTINGS_ID);
        if (this.currentDT.getCorefile() != null) {
            xes.element(CORE_ELEMENT, this.currentDT.getCorefile());
        }
        xes.element(EXEC_ELEMENT, this.currentDT.getExecutable());
        xes.element(ARGS_ELEMENT, this.currentDT.getRunProfile().getArgsFlat());
        String host = this.currentDT.getHostName();
        if (host == null) {
            host = "";
        }
        xes.element(HOST_ELEMENT, host);
        String fullpath = this.currentDT.getRunProfile().getRunDir();
        xes.element(RUNDIR_ELEMENT, fullpath);
        DebugTargetXMLCodec.encode(xes, this.currentDT.getRunProfile().getEnvironment());
        xes.elementClose(TARGET_SETTINGS_ID);
    }
}

