/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;

public final class Gen {
    private final int gen;
    private final boolean spread;
    private final NativeBreakpoint origin;

    private Gen(int gen, boolean spread, NativeBreakpoint origin) {
        this.gen = gen;
        this.spread = spread;
        this.origin = origin;
    }

    public String toString() {
        String sprd = this.spread ? "s" : "";
        return "<" + this.gen + this.spread + ">";
    }

    public static Gen primary(NativeBreakpoint origin) {
        return new Gen(1, true, origin);
    }

    public static Gen secondary(NativeBreakpoint origin) {
        return new Gen(2, false, origin);
    }

    public final Gen second() {
        assert (this.isPrimary()) : "can only get a second Gen from first Gen";
        return new Gen(2, false, this.origin);
    }

    final Gen third() {
        assert (!this.isTertiary()) : "cannot get a third gen from third gen";
        return new Gen(3, false, this.origin);
    }

    public final boolean isPrimary() {
        return this.gen == 1;
    }

    public final boolean isSecondary() {
        return this.gen == 2;
    }

    public final boolean isTertiary() {
        return this.gen == 3;
    }

    public final NativeBreakpoint origin() {
        return this.origin;
    }
}

