/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.assembly;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Location;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerImpl;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Disassembly;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisassemblyUtils;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.util.Exceptions;

public class DisInfoPanel
extends JPanel {
    private static DisInfoPanel INSTANCE;
    private final JComboBox addressText;
    private final JTextField fileText;

    public DisInfoPanel() {
        this.setLayout(new GridBagLayout());
        this.setToolTipText(Catalog.get("TIP_DisStatus"));
        JLabel addressLabel = new JLabel(Catalog.get("LBL_Address"));
        addressLabel.setToolTipText(Catalog.get("TIP_DisAddress"));
        this.addressText = new JComboBox();
        this.addressText.setEditable(true);
        addressLabel.setLabelFor(this.addressText);
        int gridx = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)addressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.addressText, gridBagConstraints);
        JLabel fileLabel = new JLabel();
        fileLabel.setText(Catalog.get("LBL_File"));
        fileLabel.setToolTipText(Catalog.get("TIP_DisFile"));
        this.fileText = new JTextField();
        this.fileText.setColumns(15);
        this.fileText.setHorizontalAlignment(2);
        this.fileText.setEditable(false);
        fileLabel.setLabelFor(this.fileText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)fileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.fileText, gridBagConstraints);
        this.addressText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DisInfoPanel.this.addressChanged();
            }
        });
    }

    private void addressChanged() {
        String selectedItem = (String)this.addressText.getSelectedItem();
        boolean found = false;
        for (int i = 0; i < this.addressText.getItemCount(); ++i) {
            if (!this.addressText.getItemAt(i).equals(selectedItem)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addressText.addItem(selectedItem);
        }
        DisassemblyUtils.showLine(1);
        NativeDebugger debugger = DebuggerManager.get().currentDebugger();
        if (debugger instanceof NativeDebuggerImpl) {
            ((NativeDebuggerImpl)debugger).disController().requestDis(selectedItem, 100, true);
        }
    }

    public static void setLocation(Location location) {
        if (INSTANCE != null) {
            String src = location.src();
            src = src != null ? CndPathUtilitities.getBaseName((String)src) : "";
            DisInfoPanel.INSTANCE.fileText.setText(src);
        }
    }

    public static final class Factory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent target) {
            try {
                if (Disassembly.isDisasm(NbEditorUtilities.getDataObject((Document)target.getDocument()).getPrimaryFile().getURL().toString())) {
                    if (INSTANCE == null) {
                        INSTANCE = new DisInfoPanel();
                    }
                    return INSTANCE;
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            return null;
        }
    }
}

