/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.util.ArrayList;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeWatch;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchVariable;
import org.netbeans.modules.cnd.debugger.common2.utils.UserdirFile;

public class WatchBag {
    private ArrayList<NativeWatch> watches = new ArrayList();
    private boolean dirty;
    private boolean initialized;
    private boolean isRestoring;
    private static final String moduleFolderName = "DbxGui";
    private static final String folderName = "DbxDebugWatches";
    private static final String filename = "Watches";
    private static final UserdirFile userdirFile = new UserdirFile("DbxGui", "DbxDebugWatches", "Watches");

    private static DebuggerManager manager() {
        return DebuggerManager.get();
    }

    public boolean isRestoring() {
        return this.isRestoring;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        if (Log.Watch.pathway) {
            System.out.printf("WatchBag.initialize() initializing\n", new Object[0]);
        }
        this.isRestoring = true;
        WatchBag.manager().getWatches();
        this.isRestoring = false;
        this.initialized = true;
    }

    ModelChangeDelegator watchUpdater() {
        return WatchBag.manager().watchUpdater();
    }

    public NativeWatch[] getWatches() {
        this.initialize();
        NativeWatch[] wa = new NativeWatch[this.watches.size()];
        return this.watches.toArray(wa);
    }

    public WatchVariable[] watchesFor(NativeDebugger debugger) {
        this.initialize();
        ArrayList<WatchVariable> ws = new ArrayList<WatchVariable>();
        for (NativeWatch w : this.watches) {
            WatchVariable dw = w.findByDebugger(debugger);
            if (dw == null) continue;
            ws.add(dw);
        }
        return ws.toArray(new WatchVariable[ws.size()]);
    }

    public void postDeleteAllWatches() {
        NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
        for (NativeWatch w : this.getWatches()) {
            WatchVariable dw = w.findByDebugger(debugger);
            if (dw == null) continue;
            w.postDelete(false);
        }
    }

    public void restore(NativeWatch newWatch) {
        assert (!this.watches.contains(newWatch)) : "WB.restore(): watch added redundantly";
        this.watches.add(newWatch);
        newWatch.setUpdater(this.watchUpdater());
    }

    public void add(NativeWatch newWatch) {
        assert (!this.watches.contains(newWatch)) : "WB.add(): watch added redundantly";
        this.watches.add(newWatch);
        newWatch.setUpdater(this.watchUpdater());
        this.watchUpdater().treeChanged();
        this.dirty = true;
    }

    public void remove(NativeWatch oldWatch) {
        if (oldWatch == null) {
            return;
        }
        oldWatch.cleanup();
        boolean removed = this.watches.remove(oldWatch);
        assert (removed) : "WB.remove(): watch to be removed not in bag";
        assert (!this.watches.contains(oldWatch)) : "WB.remove(): watch still there after removal";
        this.watchUpdater().treeChanged();
        this.dirty = true;
    }

    public void restore() {
    }

    public void save() {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }
}

