/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.FormatOption;
import org.netbeans.spi.viewmodel.Models;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class EvaluationWindow
extends TopComponent
implements ActionListener {
    private static final String preferredID = "EvaluationWindow";
    private static EvaluationWindow DEFAULT;
    private transient JComponent tree = null;
    private String name = Catalog.get("TITLE_EvaluationWindow");
    private String view_name = Catalog.get("TITLE_EvaluationView");
    private NativeDebugger debugger = null;
    private JMenuItem menuItemClear;
    private JPopupMenu popup;
    private JTextArea ta;
    private JScrollPane ta_sp;
    private JPanel hp;
    private JPanel cp;
    private PopupListener popupListener;
    private String expr;
    private JComboBox format_jcb;
    private FormatListener format_listener;
    private FormatOption format;
    private JComboBox exprList;
    private String selected_text = null;

    public static synchronized EvaluationWindow getDefault() {
        if (DEFAULT == null && (DEFAULT = (EvaluationWindow)WindowManager.getDefault().findTopComponent(preferredID)) == null) {
            DEFAULT = new EvaluationWindow();
        }
        return DEFAULT;
    }

    public EvaluationWindow() {
        super.setName(this.name);
        String iconDir = "org/netbeans/modules/cnd/debugger/common2/icons/";
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/debugger/common2/icons/evaluate_expression.png"));
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    protected void componentHidden() {
        if (this.exprList != null) {
            this.exprList.setSelectedIndex(0);
        }
        if (this.debugger != null) {
            this.debugger.registerEvaluationWindow(null);
        }
    }

    public void componentShowing() {
        super.componentShowing();
        boolean update = this.connectToDebugger(DebuggerManager.get().currentDebugger());
        if (update) {
            this.updateWindow();
            this.updateFormats();
        }
    }

    protected void componentClosed() {
        super.componentClosed();
        if (this.debugger != null) {
            this.debugger.registerEvaluationWindow(null);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
            this.exprList.setSelectedIndex(0);
            this.invalidate();
        }
    }

    private boolean connectToDebugger(NativeDebugger debugger) {
        boolean res = this.debugger != debugger;
        this.debugger = debugger;
        if (debugger != null) {
            debugger.registerEvaluationWindow(this);
        }
        return res;
    }

    private void updateFormats() {
        FormatOption[] evalFormats = this.debugger.getEvalFormats();
        if (evalFormats != null) {
            this.format_jcb.setModel(new DefaultComboBoxModel<FormatOption>(this.debugger.getEvalFormats()));
            this.format_jcb.setEnabled(true);
        } else {
            this.format_jcb.setModel(new DefaultComboBoxModel<FormatOption>(new FormatOption[]{FormatOption.EMPTY}));
            this.format_jcb.setEnabled(false);
        }
        this.updateSelectedFormat();
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.view_name;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox cb;
        String ac = actionEvent.getActionCommand();
        if (ac != null && ac.equals("comboBoxChanged") && (cb = (JComboBox)actionEvent.getSource()) != null) {
            this.expr = (String)cb.getSelectedItem();
            if (this.expr != null && !this.expr.equals("")) {
                this.exprEval();
            }
        }
    }

    private void exprEval() {
        this.format = (FormatOption)this.format_jcb.getSelectedItem();
        if (this.expr != null && !this.expr.equals("") && this.format != null) {
            this.debugger.exprEval(this.format, this.expr);
        }
    }

    private int exprMap(String expr) {
        for (int i = 0; i < this.exprList.getItemCount(); ++i) {
            if (!expr.equals((String)this.exprList.getItemAt(i))) continue;
            return i;
        }
        return -1;
    }

    public void evalResult(String result) {
        int index;
        int i;
        if (result == null) {
            return;
        }
        if (result.length() == 0) {
            result = " ";
        }
        if ((i = result.indexOf(" =")) == -1) {
            i = result.length() - 1;
        }
        if ((index = this.exprMap(this.expr)) == -1) {
            this.exprList.addItem(this.expr);
        }
        this.ta.append(result);
        this.updateWindow();
    }

    private void updateWindow() {
        if (this.tree == null) {
            this.ta = new JTextArea();
            this.ta_sp = new JScrollPane(this.ta);
            this.setLayout(new BorderLayout());
            this.tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
            this.tree.setName(this.view_name);
            this.ta.setEditable(false);
            this.ta.setWrapStyleWord(false);
            Font f = this.ta.getFont();
            this.ta.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
            this.hp = new JPanel(new BorderLayout());
            this.expr = "";
            this.cp = new JPanel(new GridBagLayout());
            this.cp.setToolTipText("Control panel to specify Expression. Use pop-up menu to specify output format.");
            JLabel cp_text1 = new JLabel(Catalog.get("LBL_Expression"));
            cp_text1.setToolTipText(Catalog.get("HINT_Expression"));
            this.exprList = new JComboBox();
            this.exprList.setMaximumSize(this.cp.getPreferredSize());
            this.exprList.addItem(this.expr);
            this.exprList.setEditable(true);
            this.exprList.addActionListener(this);
            JLabel cp_text3 = new JLabel(Catalog.get("LBL_Format"));
            cp_text3.setToolTipText(Catalog.get("HINT_Output_format"));
            this.format_listener = new FormatListener();
            this.format_jcb = new JComboBox();
            this.updateFormats();
            this.format_jcb.addActionListener(this.format_listener);
            int gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 0, 8, 0);
            this.cp.add((Component)cp_text1, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            gridBagConstraints.weightx = 1.0;
            this.cp.add((Component)this.exprList, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.cp.add((Component)cp_text3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.cp.add((Component)this.format_jcb, gridBagConstraints);
            this.tree.add((Component)this.hp, "North");
            this.tree.add((Component)this.ta_sp, "Center");
            this.tree.add((Component)this.cp, "South");
            AccessibleContext ac = this.tree.getAccessibleContext();
            ac.setAccessibleDescription("Window to view  expression");
            ac.setAccessibleName(Catalog.get("TITLE_EvaluationView"));
            this.add(this.tree, "Center");
            this.popup = new JPopupMenu();
            this.popupListener = new PopupListener(this.popup);
            this.menuItemClear = new JMenuItem(new ClearBufferAction());
            this.popup.add(this.menuItemClear);
            this.ta.addMouseListener(this.popupListener);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
        }
        this.invalidate();
    }

    private void updateSelectedFormat() {
        if (this.format != null) {
            this.format_jcb.setSelectedItem(this.format);
            if (this.format_jcb.getSelectedItem() != null) {
                return;
            }
        }
        this.format_jcb.setSelectedIndex(0);
    }

    protected void FollowSelectedPointer(String s) {
        int i;
        for (i = 0; i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t'); ++i) {
        }
        if (i > 0 && i < s.length()) {
            s = s.substring(i);
        }
        for (i = 0; i < s.length() && s.charAt(i) != ':' && s.charAt(i) != ';' && s.charAt(i) != ' ' && s.charAt(i) != '\t'; ++i) {
        }
        if (i > 0 && i < s.length()) {
            s = s.substring(0, i);
        }
        if (s.length() > 0) {
            this.expr = s;
        }
        this.exprEval();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(preferredID);
    }

    class FollowSelectedPointerAction
    extends AbstractAction {
        public FollowSelectedPointerAction() {
            super("Follow Selected Pointer", new ImageIcon("paste.gif"));
        }

        public void actionPerformed(ActionEvent ev) {
            EvaluationWindow.this.FollowSelectedPointer(EvaluationWindow.this.selected_text);
        }
    }

    class ClearBufferAction
    extends AbstractAction {
        public ClearBufferAction() {
            super("Clear", new ImageIcon("org/netbeans/modules/cnd/debugger/common2/icons/Pointers.gif"));
        }

        public void actionPerformed(ActionEvent ev) {
            EvaluationWindow.this.ta.setText(null);
            EvaluationWindow.this.ta.setCaretPosition(0);
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                EvaluationWindow.this.menuItemClear.setEnabled(true);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class FormatListener
    implements ActionListener {
        private FormatListener() {
        }

        public void actionPerformed(ActionEvent ev) {
            String ac = ev.getActionCommand();
            if (ac.equals("comboBoxChanged")) {
                EvaluationWindow.this.exprEval();
            }
        }
    }
}

