/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerSettings;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.GlobalOptionSet;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Pathmap;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.ProfileOptionSet;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Signals;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionLayers;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.openide.ErrorManager;

public abstract class DebuggerSettingsBridge
implements PropertyChangeListener {
    protected NativeDebugger debugger;
    private DebuggerSettings tentativeSettings;
    private String tentativeTarget;
    private final DebuggerSettings defaultSettings;
    private DebuggerSettings mainSettings;
    private DebuggerSettings lastAppliedSettings;
    private final OptionSet defaultGlobalOptionSet = new GlobalOptionSet();
    private final OptionSet defaultProfileOptionSet = new ProfileOptionSet();
    protected boolean ignoreSettingsChange = false;
    protected boolean ignoreClassPath = false;
    protected boolean ignoreJavaSrcPath = false;
    private static final int DIRTY_ARGS = 1;
    private static final int DIRTY_DIR = 2;
    private static final int DIRTY_ENVVARS = 4;
    private static final int DIRTY_PRELOAD = 8;
    private static final int DIRTY_PATHMAP = 16;
    private static final int DIRTY_BREAKPOINTS = 32;
    private static final int DIRTY_SIGNALS = 64;
    private static final int DIRTY_EXCEPTIONS = 128;
    private static final int DIRTY_CLASSPATH = 256;
    private static final int DIRTY_WATCHES = 512;
    private static final int DIRTY_PROG_APPLY = -1;
    private static final int DIRTY_COREFILE_APPLY = -1;
    private static final int DIRTY_ATTACH_APPLY = -1;
    private NativeDebuggerInfo info;
    Env savedEnv;

    protected DebuggerSettingsBridge(NativeDebugger debugger, DebuggerSettings defaultSettings) {
        this.debugger = debugger;
        this.defaultSettings = defaultSettings;
    }

    public final DebuggerSettings getMainSettings() {
        return this.mainSettings;
    }

    protected final DebuggerSettings getTentativeSettings() {
        return this.tentativeSettings;
    }

    protected final DebuggerSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    public final DebuggerSettings getCurrentSettings() {
        if (this.mainSettings != null) {
            return this.mainSettings;
        }
        if (this.tentativeSettings != null) {
            return this.tentativeSettings;
        }
        return this.defaultSettings;
    }

    private RunProfile currentRunProfile() {
        return this.getCurrentSettings().runProfile();
    }

    protected final DbgProfile currentDbgProfile() {
        return this.getCurrentSettings().dbgProfile();
    }

    protected abstract void setTentativeSettings(NativeDebuggerInfo var1);

    protected final void assignTentativeSettings(DebuggerSettings tentative, String tentativeTarget) {
        this.tentativeSettings = tentative;
        this.tentativeTarget = tentativeTarget;
    }

    private void commitToTentativeSettings() {
        this.setSettingsImpl(this.tentativeSettings, this.tentativeTarget);
    }

    private void commitToAltSettings(DebuggerSettings altSettings, String altTarget) {
        if (altSettings != null) {
            this.tentativeSettings = altSettings;
            this.tentativeTarget = altTarget;
        }
        this.setSettingsImpl(altSettings, altTarget);
    }

    private void setSettingsImpl(DebuggerSettings newSettings, String target) {
        if (this.mainSettings == newSettings) {
            return;
        }
        if (this.mainSettings != null) {
            this.mainSettings.detachBridge(this);
        }
        this.mainSettings = newSettings;
        if (this.mainSettings != null) {
            this.mainSettings.attachBridge(this);
        }
        if (this.mainSettings != null) {
            DbgProfile mainDbgProfile = this.mainSettings.dbgProfile();
            RunProfile mainRunProfile = this.mainSettings.runProfile();
            if (mainDbgProfile != null && mainRunProfile != null && mainDbgProfile.isBuildFirstOverriden()) {
                boolean oldBuildFirst = mainDbgProfile.isSavedBuildFirst();
                mainRunProfile.setBuildFirst(oldBuildFirst);
                mainDbgProfile.setBuildFirstOverriden(false);
            }
        }
    }

    protected final String getArgsFlatEx() {
        RunProfile mainRunProfile = this.mainSettings.runProfile();
        DbgProfile mainDbgProfile = this.mainSettings.dbgProfile();
        String args = mainRunProfile.getArgsFlat();
        return args;
    }

    public void setup(NativeDebuggerInfo info) {
        this.info = info;
        DbgProfile newDbgProfile = info.getDbgProfile();
        if (newDbgProfile.signals().count() == 0) {
            newDbgProfile.signals().assign(this.currentDbgProfile().signals());
        }
        this.getDefaultSettings().dbgProfile().getOptions().assignNonClient(newDbgProfile.getOptions());
        this.setupExtra(info);
        this.setTentativeSettings(info);
    }

    protected void setupExtra(NativeDebuggerInfo info) {
    }

    public final void noteInitializationDone() {
        OptionSet globalOptions = DebuggerManager.get().globalOptions();
        globalOptions.deltaWithRespectTo(this.defaultGlobalOptionSet);
        globalOptions.applyTo(this.debugger.getOptionClient());
        globalOptions.doneApplying();
    }

    public void noteRunArgs(String[] argv) {
        this.ignoreSettingsChange = true;
        this.currentRunProfile().setArgs(argv);
        this.ignoreSettingsChange = false;
    }

    public void noteRedir(String infile, String outfile, boolean append) {
        this.ignoreSettingsChange = true;
        this.currentDbgProfile().setRedirection(infile, outfile, append);
        String args = this.currentRunProfile().getArgsFlat();
        String redirection = this.currentDbgProfile().getRedirection();
        if (redirection != null) {
            args = args + " ";
            args = args + this.currentDbgProfile().getRedirection();
        }
        if (args != null) {
            this.currentRunProfile().setArgsRaw(args);
        }
        this.ignoreSettingsChange = false;
    }

    public void noteRunDir(String dir) {
        dir = this.debugger.remoteToLocal("noteRunDir", dir);
        this.currentRunProfile().setRunDirectory(dir);
    }

    public void noteEnvVar(String name, String new_value) {
        Env env = this.currentRunProfile().getEnvironment();
        if (new_value == null) {
            env.removeByName(name);
        } else {
            env.putenv(name, new_value);
        }
        this.ignoreSettingsChange = true;
        this.currentRunProfile().setEnvironment(env);
        this.ignoreSettingsChange = false;
    }

    private boolean isInUse(RunProfile profile, NativeDebugger myself) {
        DebuggerManager manager = DebuggerManager.get();
        for (NativeDebugger aDebugger : manager.nativeDebuggers()) {
            if (aDebugger == myself || aDebugger.profileBridge().currentRunProfile() != profile) continue;
            return true;
        }
        return false;
    }

    protected abstract DebuggerSettings createSettingsFromTarget(DebugTarget var1);

    public void noteProgLoaded(String progname) {
        if (IpeUtils.sameString("-", this.tentativeTarget) || IpeUtils.sameString(progname, IpeUtils.normalizePath(this.tentativeTarget, EditorBridge.getSourceFileSystem(this.debugger))) && !this.isInUse(this.tentativeSettings.runProfile(), this.debugger)) {
            this.commitToTentativeSettings();
        } else {
            DebugTarget original = this.info.getDebugTarget();
            if (original == null) {
                original = new DebugTarget((MakeConfiguration)this.info.getConfiguration());
                original.setHostName(this.info.getHostName());
            }
            DebugTarget dt = original.cloneRecord();
            DebuggerSettings newSettings = this.createSettingsFromTarget(dt);
            if (Log.Startup.debug) {
                if (this.currentRunProfile() == newSettings.runProfile()) {
                    System.out.println("ProfileBridge.noteProgLoaded(): YES");
                } else {
                    System.out.println("ProfileBridge.noteProgLoaded(): NO");
                }
            }
            this.commitToAltSettings(newSettings, progname);
            this.info.setConfiguration((Configuration)dt.getConfig());
            this.info.setDebugTarget(dt);
        }
        this.debugger.optionLayersReset();
        this.resolveDefaults();
        if (this.mainSettings != this.lastAppliedSettings) {
            int dirty = 0;
            dirty = this.debugger.session().getCorefile() != null ? -1 : (this.debugger.session().getPid() != -1L ? -1 : -1);
            this.initialApply(dirty);
            this.applyConfigurationOptions(true, this.lastAppliedSettings);
            this.lastAppliedSettings = this.mainSettings;
        } else {
            int dirty = 0;
            dirty |= 0x20;
            this.initialApply(dirty |= 0x200);
        }
    }

    public void noteProgUnloaded() {
        this.commitToAltSettings(null, null);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("runargs-ch".equals(name)) {
            this.debugger.invalidateSessionData();
        }
        if (!this.ignoreSettingsChange) {
            if ("runargs-ch".equals(name)) {
                this.applyRunargs();
            } else if ("rundir-ch".equals(name)) {
                this.applyRunDirectory();
            } else if ("envvars-ch".equals(name)) {
                String o = (String)evt.getOldValue();
                Env n = (Env)evt.getNewValue();
                if (this.savedEnv != null) {
                    String savedEnvString = this.savedEnv.toString();
                    if (savedEnvString.equals(o)) {
                        this.applyEnvvars(this.savedEnv.getenvAsPairs(), n.getenvAsPairs());
                    } else {
                        this.applyEnvvars();
                    }
                } else {
                    this.applyEnvvars();
                }
                this.savedEnv = n.clone();
            } else if ("options".equals(name)) {
                this.applyConfigurationOptions(false, null);
            } else if ("signals".equals(name)) {
                Signals o = (Signals)evt.getOldValue();
                Signals n = (Signals)evt.getNewValue();
                assert (o != null) : "ProfileBridge.propertyChange(): null old signals";
                assert (n != null) : "ProfileBridge.propertyChange(): null new signals";
                this.applySignals(o, n);
            } else if ("pathmap".equals(name)) {
                Pathmap o = (Pathmap)evt.getOldValue();
                Pathmap n = (Pathmap)evt.getNewValue();
                assert (o != null) : "ProfileBridge.propertyChange(): null old pathmap";
                assert (n != null) : "ProfileBridge.propertyChange(): null new pathmap";
                this.applyPathmap(o, n);
            } else if ("interceptlist".equals(name)) {
                this.applyInterceptList();
            } else if (!this.propertyChangeExtra(evt)) {
                ErrorManager.getDefault().log("Unhandled ProfileBridge.propertyChange: " + name);
            }
        }
    }

    protected boolean propertyChangeExtra(PropertyChangeEvent event) {
        return false;
    }

    private void resolveDefaults() {
        DbgProfile mainDbgProfile = this.mainSettings.dbgProfile();
        DbgProfile tentativeDbgProfile = this.tentativeSettings.dbgProfile();
        if (tentativeDbgProfile.signals().count() != 0) {
            mainDbgProfile.signals().assign(tentativeDbgProfile.signals());
        } else {
            mainDbgProfile.signals().assign(this.getDefaultSettings().dbgProfile().signals());
        }
        if (tentativeDbgProfile.pathmap().count() != 0) {
            mainDbgProfile.pathmap().assign(tentativeDbgProfile.pathmap());
        } else {
            mainDbgProfile.pathmap().assign(this.getDefaultSettings().dbgProfile().pathmap());
        }
    }

    private void initialApplyWork(int dirty) {
        OptionLayers optionLayers;
        if ((dirty & 2) != 0) {
            this.applyRunDirectory();
        }
        if ((dirty & 1) != 0) {
            this.applyRunargs();
        }
        if ((dirty & 4) != 0) {
            this.applyEnvvars();
        }
        if ((dirty & 0x100) != 0) {
            this.applyClasspath();
        }
        if ((dirty & 8) != 0) {
            // empty if block
        }
        if ((dirty & 0x10) != 0) {
            this.applyPathmap(null, this.mainSettings.dbgProfile().pathmap());
        }
        if ((dirty & 0x80) != 0) {
            this.applyInterceptList();
        }
        if ((dirty & 0x40) != 0) {
            this.applySignals(null, this.mainSettings.dbgProfile().signals());
        }
        if ((dirty & 0x20) != 0 && DebuggerOption.SAVE_BREAKPOINTS.isEnabled(optionLayers = this.debugger.optionLayers())) {
            BreakpointBag bb = DebuggerManager.get().breakpointBag();
            this.debugger.bm().postRestoreBreakpoints(bb);
        }
        if ((dirty & 0x200) != 0) {
            WatchBag wb = DebuggerManager.get().watchBag();
            this.debugger.restoreWatches(wb);
        }
    }

    private void initialApply(int dirty) {
        this.debugger.postRestoring(true);
        try {
            this.initialApplyWork(dirty);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.debugger.postRestoring(false);
    }

    protected abstract void applyPathmap(Pathmap var1, Pathmap var2);

    protected abstract void applyRunargs();

    protected abstract void applyRunDirectory();

    protected abstract void applyClasspath();

    protected abstract void applyEnvvars();

    protected abstract void applyEnvvars(String[][] var1, String[][] var2);

    protected abstract void applySignals(Signals var1, Signals var2);

    protected abstract void applyInterceptList();

    protected final void applyConfigurationOptions(boolean firstTime, DebuggerSettings lastSettings) {
        OptionSet dbxOptions = this.mainSettings.dbgProfile().getOptions();
        if (firstTime) {
            OptionSet lastOptionSet = null;
            lastOptionSet = lastSettings != null && lastSettings.dbgProfile() != null ? lastSettings.dbgProfile().getOptions() : this.defaultProfileOptionSet;
            dbxOptions.deltaWithRespectTo(lastOptionSet);
        }
        dbxOptions.applyTo(this.debugger.getOptionClient());
        dbxOptions.doneApplying();
        this.applyConfigurationOptionsExtra(firstTime, lastSettings);
    }

    protected void applyConfigurationOptionsExtra(boolean firstTime, DebuggerSettings lastSettings) {
    }

    public final DebuggerSettings cloneMainSettings() {
        return this.mainSettings == null ? null : this.mainSettings.clone(this.info.getConfiguration());
    }
}

