/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.capture;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.debugger.common2.capture.CaptureInfo;
import org.netbeans.modules.cnd.debugger.common2.capture.CapturePanel;
import org.netbeans.modules.cnd.debugger.common2.capture.Catalog;
import org.netbeans.modules.cnd.debugger.common2.capture.ExternalStart;
import org.netbeans.modules.cnd.debugger.common2.capture.ExternalStartProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.ProjectSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public final class ExternalStartManager {
    private static Job pendingJob;
    private static boolean debuggerStarted;
    private static boolean waitingForDebuggerAck;
    private static final LinkedList<Job> queue;
    private static final HashMap<String, ExternalStart> hostXstartMap;

    public static void startLocal() {
        if (Utilities.isWindows()) {
            return;
        }
        Host host = Host.getLocal();
        ExternalStart xstart = ExternalStartManager.getXstart(host);
        if (xstart == null && (xstart = ExternalStartManager.createExternalStart(host)) != null) {
            ExternalStartManager.addXstart(host, xstart);
            xstart.start();
        }
    }

    public static ExternalStart getXstart(Host host) {
        if (DebuggerManager.isStandalone()) {
            return hostXstartMap.get(host.getHostName());
        }
        if (host.getHostName().equals("localhost")) {
            return hostXstartMap.get(host.getHostName());
        }
        return hostXstartMap.get(host.getHostLogin() + '@' + host.getHostName());
    }

    public static ExternalStart getXstart(String hostName) {
        int i = hostName.indexOf(58);
        if (i > 0) {
            hostName = hostName.substring(0, i);
        }
        return hostXstartMap.get(hostName);
    }

    static void addXstart(Host host, ExternalStart x) {
        if (DebuggerManager.isStandalone()) {
            hostXstartMap.put(host.getHostName(), x);
        } else if (host.getHostName().equals("localhost")) {
            hostXstartMap.put(host.getHostName(), x);
        } else {
            hostXstartMap.put(host.getHostLogin() + '@' + host.getHostName(), x);
        }
    }

    static boolean isSupported() {
        ExternalStartProvider xstartProvider = (ExternalStartProvider)Lookup.getDefault().lookup(ExternalStartProvider.class);
        return xstartProvider != null && xstartProvider.isSupported();
    }

    static ExternalStart createExternalStart(Host host) {
        ExternalStartProvider xstartProvider = (ExternalStartProvider)Lookup.getDefault().lookup(ExternalStartProvider.class);
        if (xstartProvider != null) {
            return xstartProvider.createExternalStart(host);
        }
        return null;
    }

    public static void stopAll() {
        Collection<ExternalStart> xstart_set = hostXstartMap.values();
        for (ExternalStart xstart : xstart_set) {
            xstart.stop();
        }
    }

    public static void enqueue(Job job) {
        queue.add(job);
        ExternalStartManager.runJob();
    }

    static void fail(String label) {
        if (pendingJob != null) {
            pendingJob.failed(Catalog.get(label));
            pendingJob = null;
        }
        ExternalStartManager.runJob();
    }

    static void debuggerStarted() {
        assert (waitingForDebuggerAck);
        debuggerStarted = true;
    }

    public static boolean attached(int pid) {
        if (pendingJob == null) {
            return false;
        }
        assert (ExternalStartManager.pendingJob.captureInfo().pid == pid);
        pendingJob.proceed();
        pendingJob = null;
        ExternalStartManager.runJob();
        return true;
    }

    private static void runJob() {
        if (queue.isEmpty()) {
            return;
        }
        if (pendingJob != null) {
            return;
        }
        pendingJob = queue.removeFirst();
        CapturePanel panel = new CapturePanel(pendingJob.captureInfo());
        NotifyDescriptor.Confirmation dlg = new NotifyDescriptor.Confirmation((Object)panel, Catalog.get("LBL_dialogName"), 0);
        Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
        if (answer == NotifyDescriptor.NO_OPTION || answer == NotifyDescriptor.CLOSED_OPTION) {
            ExternalStartManager.fail("LBL_UserDeniedRequest");
            return;
        }
        Project project = panel.getSelectedProject();
        boolean noProject = panel.getNoProject();
        ProjectSupport.ProjectSeed seed = new ProjectSupport.ProjectSeed(panel.getSelectedProject(), EngineTypeManager.getFallbackEnineType(), panel.getNoProject(), ExternalStartManager.pendingJob.captureInfo().executable, ExternalStartManager.pendingJob.captureInfo().model, null, ExternalStartManager.pendingJob.captureInfo().pid, ExternalStartManager.pendingJob.captureInfo().workingDirectory, pendingJob.captureInfo().quotedArgvString(), null, ExternalStartManager.pendingJob.captureInfo().hostName);
        ProjectSupport.getProject(seed);
        try {
            debuggerStarted = false;
            waitingForDebuggerAck = true;
            DebugTarget dt = new DebugTarget(seed.conf());
            dt.setExecutable(seed.executableNoSentinel());
            dt.setHostName(seed.getHostName());
            dt.setPid(seed.pid());
            dt.setCaptureInfo(pendingJob.captureInfo());
            DebuggerManager.get().attach(dt);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            ExternalStartManager.fail("LBL_IDEError");
            return;
        }
        if (!debuggerStarted) {
            ExternalStartManager.fail("LBL_CancelledByUser");
        }
        waitingForDebuggerAck = false;
    }

    static {
        queue = new LinkedList();
        hostXstartMap = new HashMap();
    }

    public static class NoopExternalStartProvider
    implements ExternalStartProvider {
        public ExternalStart createExternalStart(Host host) {
            return new ExternalStart(){

                public boolean attached(int pid) {
                    return false;
                }

                public void debuggerStarted() {
                }

                public void fail() {
                }

                public boolean start() {
                    return false;
                }

                public boolean stop() {
                    return false;
                }

                public boolean isRunning() {
                    return false;
                }
            };
        }

        public boolean isSupported() {
            return false;
        }
    }

    public static interface Job {
        public CaptureInfo captureInfo();

        public void failed(String var1);

        public void proceed();
    }
}

