/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.capture;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.cnd.debugger.common2.capture.Catalog;
import org.netbeans.modules.cnd.debugger.common2.capture.ExternalStart;
import org.netbeans.modules.cnd.debugger.common2.capture.ExternalStartManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.EditHostListAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CndRemote;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHost;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHostList;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.InfoPanel;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.MasterView;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class CaptureListenAction
extends SystemAction
implements Presenter.Menu {
    private static final Preferences prefs = NbPreferences.forModule(ExternalStart.class);
    private static final String PREFIX = "xstart.";
    private static final String PREF_DONOTSHOWAGAIN = "xstart.doNotShowAgain";

    public String getName() {
        return Catalog.get("LBL_ListenToCaptures");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CaptureListenAction.class);
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public JMenuItem getMenuPresenter() {
        JMenu mi = new JMenu();
        Actions.connect((JMenuItem)mi, (Action)((Object)this), (boolean)false);
        mi.addMenuListener(new MainItemListener());
        return mi;
    }

    private static boolean isDoNotShowAgain() {
        return prefs.getBoolean(PREF_DONOTSHOWAGAIN, false);
    }

    private static void setDoNotShowAgain(boolean doNotShowAgain) {
        prefs.putBoolean(PREF_DONOTSHOWAGAIN, doNotShowAgain);
    }

    protected class PopupItemTarget
    extends JCheckBoxMenuItem
    implements ActionListener {
        private ExternalStart xstart;
        private String hostName;

        public PopupItemTarget(ExternalStart xs, String hostName, String hostDispName, boolean allowed) {
            super(hostDispName, allowed);
            this.xstart = xs;
            this.hostName = hostName;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            String hn = this.hostName;
            CndRemote.validate(hn, new Runnable(){

                public void run() {
                    PopupItemTarget.this.toggleXstart();
                }
            });
        }

        private void toggleXstart() {
            if (!ExternalStartManager.isSupported()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Catalog.get("MSG_ss_attach_not_supported"), 0));
                return;
            }
            Host host = Host.byName(this.hostName);
            if (this.xstart == null) {
                this.xstart = ExternalStartManager.createExternalStart(host);
                ExternalStartManager.addXstart(host, this.xstart);
            }
            if (this.xstart.isRunning()) {
                this.xstart.stop();
            } else {
                if (!CaptureListenAction.isDoNotShowAgain()) {
                    String msg = DebuggerManager.isStandalone() ? Catalog.get("MSG_dbxtool_ss_attach_info") : Catalog.get("MSG_ss_attach_info");
                    InfoPanel panel = new InfoPanel(msg);
                    NotifyDescriptor.Confirmation dlg = new NotifyDescriptor.Confirmation((Object)panel, CaptureListenAction.this.getName(), 2);
                    Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
                    CaptureListenAction.setDoNotShowAgain(panel.dontShowAgain());
                    if (answer == NotifyDescriptor.CANCEL_OPTION || answer == NotifyDescriptor.CLOSED_OPTION) {
                        return;
                    }
                }
                this.xstart.start();
            }
        }
    }

    private class MainItemListener
    implements MenuListener {
        private MainItemListener() {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            menu.removeAll();
        }

        public void menuSelected(MenuEvent e) {
            EditHostListAction editHostListAction;
            JMenu menu = (JMenu)e.getSource();
            String[] hostChoices = null;
            String hostName = null;
            CustomizableHostList hostlist = null;
            hostlist = CustomizableHostList.getInstance();
            hostChoices = DebuggerManager.isStandalone() ? hostlist.getRecordsName() : CndRemote.getServerListIDs();
            if (hostChoices.length > 0) {
                for (int i = 0; i < hostChoices.length && i < MasterView.MAX_VISIBLE_IN_MENU; ++i) {
                    ExternalStart xstart;
                    String hostDispName = hostName = hostChoices[i];
                    if (DebuggerManager.isStandalone()) {
                        CustomizableHost host = hostlist.getHostByName(hostName);
                        hostDispName = host.displayName();
                    }
                    boolean allowed = (xstart = ExternalStartManager.getXstart(hostName)) == null ? false : xstart.isRunning();
                    menu.add(new PopupItemTarget(xstart, hostName, hostDispName, allowed));
                }
            }
            if ((editHostListAction = (EditHostListAction)SharedClassObject.findObject(EditHostListAction.class, (boolean)true)) != null) {
                editHostListAction.setEnabled(hostChoices.length > 0);
                if (DebuggerManager.isStandalone()) {
                    menu.add(new JSeparator());
                    menu.add(editHostListAction.getMenuPresenter());
                }
            }
        }
    }
}

