/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;

public abstract class HostMappingProviderUnixAbstract
implements HostMappingProvider {
    private static final Logger log = RemoteUtil.LOGGER;
    private static final String NET = "/net/";
    private static final Pattern pattern = Pattern.compile("\t+| +");

    protected abstract String getShareCommand();

    protected abstract String fetchPath(String[] var1);

    @Override
    public Map<String, String> findMappings(ExecutionEnvironment execEnv, ExecutionEnvironment otherExecEnv) {
        ProcessUtils.ExitStatus exit;
        HashMap<String, String> mappings = new HashMap<String, String>();
        String hostName = execEnv.isLocal() ? HostMappingProviderUnixAbstract.getLocalHostName() : execEnv.getHost();
        log.log(Level.FINE, "Find Mappings for {0}", execEnv);
        if (hostName != null && (exit = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)this.getShareCommand(), (String[])new String[0])).isOK()) {
            List<String> paths = this.parseOutput(execEnv, new StringReader(exit.output));
            for (String path : paths) {
                String host;
                log.log(Level.FINE, "Path {0}", path);
                assert (path != null && path.length() > 0 && path.charAt(0) == '/');
                String netPath = NET + hostName + path;
                if (HostInfoProvider.fileExists((ExecutionEnvironment)otherExecEnv, (String)netPath)) {
                    if (execEnv.isLocal()) {
                        log.log(Level.FINE, "{0}->{1}", new Object[]{path, netPath});
                        mappings.put(path, netPath);
                    } else {
                        log.log(Level.FINE, "{0}->{1}", new Object[]{netPath, path});
                        mappings.put(netPath, path);
                    }
                }
                if (mappings.containsKey(path) || !execEnv.isLocal() || (host = this.getIP()) == null || host.length() <= 0) continue;
                log.log(Level.FINE, "IP={0}", host);
                netPath = NET + host + path;
                if (!HostInfoProvider.fileExists((ExecutionEnvironment)otherExecEnv, (String)netPath)) continue;
                mappings.put(path, netPath);
                log.log(Level.FINE, "{0}->{1}", new Object[]{path, netPath});
            }
        }
        return mappings;
    }

    private String getIP() {
        String host = null;
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface nextElement = networkInterfaces.nextElement();
                if (nextElement.isLoopback()) continue;
                for (InterfaceAddress addr : nextElement.getInterfaceAddresses()) {
                    String s = addr.getAddress().getHostAddress();
                    if (s.indexOf(46) <= 0 || s.indexOf(46) >= 5) continue;
                    host = s;
                }
            }
        }
        catch (SocketException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return host;
    }

    private List<String> parseOutput(ExecutionEnvironment execEnv, Reader outputReader) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(outputReader);
            String line = reader.readLine();
            while (line != null) {
                String path = this.fetchPath(pattern.split(line));
                if (path != null && HostInfoProvider.fileExists((ExecutionEnvironment)execEnv, (String)path)) {
                    paths.add(path);
                }
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return paths;
    }

    private static String getLocalHostName() {
        String hostName = null;
        try {
            hostName = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getHostname();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return hostName;
    }
}

