/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.support.InvokeOperationCookie;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ProjectInfo;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsInvokeOperation;
import org.netbeans.modules.websvc.spi.support.InvokeOperationActionProvider;
import org.openide.filesystems.FileObject;

public class JaxWsInvokeOperationProvider
implements InvokeOperationActionProvider {
    public InvokeOperationCookie getInvokeOperationCookie(FileObject fileObject) {
        if (JAXWSClientSupport.getJaxWsClientSupport((FileObject)fileObject) != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            ProjectInfo projectInfo = new ProjectInfo(project);
            int n = projectInfo.getProjectType();
            if (n == 0 && !this.isJAXRPCProject(project) && !this.isJAXWSProject(project) || n == 0 && this.isJAXWSProject(project) && this.isJaxWsLibraryOnClasspath(fileObject) || Util.isJavaEE5orHigher((Project)project) && (n == 1 || n == 3 || n == 2)) {
                return new JaxWsInvokeOperation(fileObject);
            }
            if (JaxWsUtils.isEjbJavaEE5orHigher(projectInfo)) {
                return new JaxWsInvokeOperation(fileObject);
            }
            if (n == 1 && !Util.isJavaEE5orHigher((Project)project) && this.isJaxWsLibraryOnRuntimeClasspath(fileObject)) {
                return new JaxWsInvokeOperation(fileObject);
            }
        }
        return null;
    }

    private boolean isJaxWsLibraryOnRuntimeClasspath(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        return classPath != null && classPath.findResource("javax/xml/ws/Service.class") != null && classPath.findResource("javax/xml/rpc/Service.class") == null;
    }

    private boolean isJAXRPCProject(Project project) {
        ClassPath classPath;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        FileObject fileObject = null;
        if (sourceGroupArray.length > 0 && (classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile")) != null) {
            fileObject = classPath.findResource("com/sun/xml/rpc/tools/ant/Wscompile.class");
        }
        return fileObject != null;
    }

    private boolean isJAXWSProject(Project project) {
        ClassPath classPath;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        FileObject fileObject = null;
        if (sourceGroupArray.length > 0 && (classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile")) != null) {
            fileObject = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        }
        return fileObject != null;
    }

    private boolean isJaxWsLibraryOnClasspath(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        if (classPath != null && classPath.findResource("javax/xml/ws/Service.class") != null) {
            return true;
        }
        classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        return classPath != null && classPath.findResource("javax/xml/ws/Service.class") != null;
    }
}

