/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;

public class MethodVisitor {
    private String operationName;
    private ExecutableElement method;
    private CompilationInfo info;
    private boolean hasWebMethod;
    private boolean hasPublicMethod;
    private List<ExecutableElement> publicMethods;

    public MethodVisitor(CompilationInfo info) {
        this.info = info;
    }

    public ExecutableElement getMethod(String operationName) {
        this.operationName = operationName;
        new JavaMethodVisitor().scan(this.info.getCompilationUnit(), null);
        return this.method;
    }

    public boolean hasWebMethod() {
        new WebMethodVisitor().scan(this.info.getCompilationUnit(), null);
        return this.hasWebMethod;
    }

    public List<ExecutableElement> getPublicMethods() {
        new PublicMethodVisitor().scan(this.info.getCompilationUnit(), null);
        return this.publicMethods;
    }

    public boolean hasPublicMethod() {
        new PublicMethodVisitor().scan(this.info.getCompilationUnit(), null);
        return this.hasPublicMethod;
    }

    private boolean hasWebMethodAnnotation(ExecutableElement method) {
        boolean isWebMethod = false;
        TypeElement methodAnotationEl = this.info.getElements().getTypeElement("javax.jws.WebMethod");
        List<? extends AnnotationMirror> methodAnnotations = method.getAnnotationMirrors();
        Iterator<? extends AnnotationMirror> i$ = methodAnnotations.iterator();
        if (i$.hasNext()) {
            AnnotationMirror anMirror = i$.next();
            if (this.info.getTypes().isSameType(methodAnotationEl.asType(), anMirror.getAnnotationType())) {
                isWebMethod = true;
                Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = anMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                    String value;
                    if (!entry.getKey().getSimpleName().contentEquals("exclude") || !"true".equals(value = (String)expressions.get(entry.getKey()).getValue())) continue;
                    isWebMethod = false;
                    break;
                }
            }
        }
        return isWebMethod;
    }

    private boolean isMethodFor(ExecutableElement method, String operationName) {
        if (method.getSimpleName().toString().equals(operationName)) {
            return true;
        }
        TypeElement methodAnotationEl = this.info.getElements().getTypeElement("javax.jws.WebMethod");
        List<? extends AnnotationMirror> methodAnnotations = method.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : methodAnnotations) {
            if (!this.info.getTypes().isSameType(methodAnotationEl.asType(), annotationMirror.getAnnotationType())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                String name;
                if (!entry.getKey().getSimpleName().contentEquals("operationName") || !operationName.equals(name = (String)expressions.get(entry.getKey()).getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private class JavaMethodVisitor
    extends TreePathScanner<Void, Void> {
        @Override
        public Void visitClass(ClassTree t, Void v) {
            Element el = MethodVisitor.this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null) {
                TypeElement te = (TypeElement)el;
                List<ExecutableElement> methods = ElementFilter.methodsIn(te.getEnclosedElements());
                for (ExecutableElement m : methods) {
                    if (!MethodVisitor.this.isMethodFor(m, MethodVisitor.this.operationName)) continue;
                    MethodVisitor.this.method = m;
                    break;
                }
            }
            return null;
        }
    }

    private class WebMethodVisitor
    extends TreePathScanner<Void, Void> {
        private WebMethodVisitor() {
        }

        @Override
        public Void visitClass(ClassTree t, Void v) {
            Element el = MethodVisitor.this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null) {
                TypeElement te = (TypeElement)el;
                List<ExecutableElement> methods = ElementFilter.methodsIn(te.getEnclosedElements());
                for (ExecutableElement m : methods) {
                    if (!MethodVisitor.this.hasWebMethodAnnotation(m)) continue;
                    MethodVisitor.this.hasWebMethod = true;
                    break;
                }
            }
            return null;
        }
    }

    private class PublicMethodVisitor
    extends TreePathScanner<Void, Void> {
        public PublicMethodVisitor() {
            MethodVisitor.this.publicMethods = new ArrayList();
        }

        @Override
        public Void visitClass(ClassTree t, Void v) {
            Element el = MethodVisitor.this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null) {
                TypeElement te = (TypeElement)el;
                List<ExecutableElement> methods = ElementFilter.methodsIn(te.getEnclosedElements());
                for (ExecutableElement m : methods) {
                    if (!m.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                    MethodVisitor.this.hasPublicMethod = true;
                    MethodVisitor.this.publicMethods.add(m);
                }
            }
            return null;
        }
    }
}

