/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.awt.Image;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ModuleSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.WaitNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class RepositoryPathNode
extends AbstractNode {
    public static RepositoryPathNode create(Client.Factory clientFactory, CVSRoot root, String path) {
        String[] atoms;
        assert (!path.startsWith("/")) : path;
        RepositoryPathChildren kids = new RepositoryPathChildren(clientFactory, root, path);
        Lookup lookup = Lookups.singleton((Object)path);
        RepositoryPathNode node = new RepositoryPathNode((Children)kids, lookup);
        String name = root.getRepository();
        if (!path.equals("") && (atoms = path.split("/")).length > 0) {
            name = atoms[atoms.length - 1];
        }
        node.setDisplayName(name);
        return node;
    }

    private RepositoryPathNode(Children children, Lookup lookup) {
        super(children, lookup);
        this.setIconBaseWithExtension("org/netbeans/modules/versioning/system/cvss/ui/selectors/defaultFolder.gif");
    }

    public Image getIcon(int type) {
        Image img = null;
        if (type == 1) {
            img = (Image)UIManager.get("Nb.Explorer.Folder.icon");
        }
        if (img == null) {
            img = super.getIcon(type);
        }
        return img;
    }

    public Image getOpenedIcon(int type) {
        Image img = null;
        if (type == 1) {
            img = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
        }
        if (img == null) {
            img = super.getIcon(type);
        }
        return img;
    }

    static class RepositoryPathChildren
    extends Children.Keys
    implements Runnable {
        private final Client.Factory clientFactory;
        private final CVSRoot root;
        private final String path;
        private RequestProcessor.Task task;

        public RepositoryPathChildren(Client.Factory client, CVSRoot root, String path) {
            this.clientFactory = client;
            this.root = root;
            this.path = path;
        }

        protected void addNotify() {
            super.addNotify();
            WaitNode waitNode = new WaitNode(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2024"));
            this.setKeys(Collections.singleton(waitNode));
            this.task = CvsVersioningSystem.getInstance().getParallelRequestProcessor().post((Runnable)this);
        }

        protected void removeNotify() {
            this.task.cancel();
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Node) {
                return new Node[]{(Node)key};
            }
            String relPath = this.path.equals("") ? (String)key : this.path + "/" + key;
            RepositoryPathNode pathNode = RepositoryPathNode.create(this.clientFactory, this.root, relPath);
            return new Node[]{pathNode};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Client client = this.clientFactory.createClient();
            try {
                List<String> keys = ModuleSelector.listRepositoryPath(client, this.root, this.path);
                this.setKeys(keys);
            }
            catch (CommandException e) {
                this.setKeys(Collections.singleton(this.errorNode((Exception)((Object)e))));
            }
            catch (AuthenticationException e) {
                this.setKeys(Collections.singleton(this.errorNode((Exception)((Object)e))));
            }
            catch (IllegalArgumentException e) {
                this.setKeys(Collections.singleton(this.errorNode(e)));
            }
            finally {
                try {
                    client.getConnection().close();
                }
                catch (Throwable ex) {
                    Logger.getLogger(BranchSelector.class.getName()).log(Level.INFO, null, ex);
                }
            }
        }

        private Node errorNode(Exception ex) {
            AbstractNode errorNode = new AbstractNode(Children.LEAF);
            errorNode.setDisplayName(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2025"));
            errorNode.setShortDescription(ex.getLocalizedMessage());
            return errorNode;
        }
    }
}

