/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.project;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.importcmd.ImportCommand;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.executor.CheckoutExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.Kit;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

final class ImportExecutor
extends ExecutorSupport
implements Runnable {
    private final String module;
    private final String cvsRoot;
    private final boolean checkout;
    private final String folder;
    private CheckoutExecutor checkoutExecutor;
    private File checkoutDir;
    private final ExecutorGroup group;

    public ImportExecutor(ImportCommand cmd, GlobalOptions options, boolean checkout, String folder, ExecutorGroup group) {
        super(CvsVersioningSystem.getInstance(), (Command)cmd, options);
        this.module = cmd.getModule();
        this.cvsRoot = options.getCVSRoot();
        this.checkout = checkout;
        this.folder = folder;
        this.group = group;
        group.addExecutor(this);
        if (checkout) {
            this.checkoutDir = Kit.createTmpFolder();
            CheckoutAction checkoutAction = (CheckoutAction)SystemAction.get(CheckoutAction.class);
            this.checkoutExecutor = checkoutAction.checkout(this.cvsRoot, this.module, null, this.checkoutDir.getAbsolutePath(), false, group);
            group.addBarrier(this);
        }
    }

    @Override
    protected void commandFinished(ClientRuntime.Result result) {
    }

    @Override
    public void run() {
        CvsVersioningSystem.getInstance().versionedFilesChanged();
        if (this.checkoutExecutor.isSuccessful()) {
            if (this.group.isFailed()) {
                CvsVersioningSystem.LOG.log(Level.INFO, ImportExecutor.class.getName() + "Import into repository failed, metadata cannot be copied.");
            } else {
                this.copyMetadata();
            }
        }
        Kit.deleteRecursively(this.checkoutDir);
        CvsVersioningSystem.getInstance().versionedFilesChanged();
    }

    private void copyMetadata() {
        File dest = new File(this.folder);
        File src = new File(this.checkoutDir, this.module);
        assert (src.isDirectory()) : src.getAbsolutePath();
        this.copyFolderMeta(src, dest);
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        cache.refresh(dest, 0);
    }

    private void copyFolderMeta(File src, File dest) {
        File[] files = src.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.isDirectory()) continue;
            if ("CVS".equals(file.getName())) {
                this.copyCvsMeta(file, dest);
                continue;
            }
            File destDir = new File(dest, file.getName());
            if (!destDir.isDirectory()) continue;
            this.copyFolderMeta(file, destDir);
        }
    }

    private void copyCvsMeta(File src, File dest) {
        File destCvsDir = new File(dest, "CVS");
        if (!destCvsDir.exists() || destCvsDir.isDirectory() && destCvsDir.listFiles().length == 0) {
            destCvsDir.mkdirs();
            if (destCvsDir.isDirectory()) {
                try {
                    File root = new File(src, "Root");
                    ImportExecutor.copyFile(root, new File(destCvsDir, "Root"));
                    File repository = new File(src, "Repository");
                    ImportExecutor.copyFile(repository, new File(destCvsDir, "Repository"));
                    File entries = new File(src, "Entries");
                    ImportExecutor.copyFile(entries, new File(destCvsDir, "Entries"));
                    StandardAdminHandler parser = new StandardAdminHandler();
                    Iterator it = parser.getEntries(dest);
                    while (it.hasNext()) {
                        Entry entry = (Entry)it.next();
                        String name = entry.getName();
                        Date date = entry.getLastModified();
                        File sourceFile = new File(dest, name);
                        if (!sourceFile.isFile()) continue;
                        sourceFile.setLastModified(date.getTime());
                    }
                }
                catch (IOException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, NbBundle.getMessage(ImportExecutor.class, (String)"BK3001"));
                    err.notify((Throwable)e);
                }
            }
        }
    }

    private static void copyFile(File src, File dst) throws IOException {
        FileOutputStream fos = new FileOutputStream(dst);
        FileInputStream fis = new FileInputStream(src);
        long len = src.length();
        assert ((long)((int)len) == len) : "Unsupported file size:" + len;
        ImportExecutor.copyStream(fos, fis, (int)len);
    }

    private static void copyStream(OutputStream out, InputStream in, int len) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        do {
            n = len <= 4096 ? len : 4096;
            if ((n = in.read(buffer, 0, n)) < 0) {
                throw new EOFException();
            }
            out.write(buffer, 0, n);
        } while ((len -= n) != 0);
    }
}

