/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class DiffStreamSource
extends StreamSource {
    private final File baseFile;
    private final String revision;
    private final String title;
    private String mimeType = "text/plain";
    private File remoteFile;
    private boolean binary;
    private ExecutorGroup group;
    private boolean initialized;
    private Boolean canWriteBaseFile;

    public DiffStreamSource(File baseFile, String revision, String title) {
        this.baseFile = baseFile;
        this.revision = revision;
        this.title = title;
    }

    public String getName() {
        return this.baseFile.getName();
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void setGroup(ExecutorGroup group) {
        this.group = group;
    }

    public synchronized String getMIMEType() {
        try {
            this.init(null);
        }
        catch (IOException e) {
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        this.init(this.group);
        if (this.revision == null || this.remoteFile == null || this.binary) {
            return null;
        }
        FileObject remoteFo = FileUtil.toFileObject((File)this.remoteFile);
        return Utils.createReader((FileObject)remoteFo);
    }

    public Writer createWriter(Difference[] conflicts) throws IOException {
        throw new IOException("Operation not supported");
    }

    public synchronized boolean isEditable() {
        return !this.binary && "".equals(this.revision) && this.isPrimary() && this.isBaseFileWritable();
    }

    private boolean isBaseFileWritable() {
        if (this.canWriteBaseFile == null) {
            FileObject fo = FileUtil.toFileObject((File)this.baseFile);
            this.canWriteBaseFile = fo != null && fo.canWrite();
        }
        return this.canWriteBaseFile;
    }

    private boolean isPrimary() {
        FileObject fo = FileUtil.toFileObject((File)this.baseFile);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                return fo.equals(dao.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init(null);
        }
        catch (IOException e) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject remoteFo = FileUtil.toFileObject((File)this.remoteFile);
        if (remoteFo == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{remoteFo});
    }

    synchronized void init(ExecutorGroup group) throws IOException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.revision == null) {
            return;
        }
        this.binary = this.baseFile.exists() && !CvsVersioningSystem.getInstance().isText(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getRemoteFile(this.baseFile, this.revision, group);
            } else {
                File tempFolder = Utils.getTempFolder();
                Set allFiles = Utils.getAllDataObjectFiles((File)this.baseFile);
                for (File file : allFiles) {
                    boolean isBase = file.equals(this.baseFile);
                    try {
                        File rf = VersionsCache.getInstance().getRemoteFile(file, this.revision, group);
                        if (rf == null && !isBase) {
                            rf = VersionsCache.getInstance().getRemoteFile(file, "*", group);
                        }
                        if (rf == null) continue;
                        File newRemoteFile = new File(tempFolder, file.getName());
                        newRemoteFile.deleteOnExit();
                        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(newRemoteFile), (InputStream)new FileInputStream(rf));
                        if (!isBase) continue;
                        this.remoteFile = newRemoteFile;
                        Utils.associateEncoding((File)file, (File)newRemoteFile);
                    }
                    catch (Exception e) {
                        if (!isBase) continue;
                        throw e;
                    }
                }
            }
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.binary = !CvsVersioningSystem.getInstance().isText(this.remoteFile);
            }
        }
        catch (Exception e) {
            IOException failure = new IOException("Cannot initialize stream source");
            failure.initCause(e);
            throw failure;
        }
        FileObject fo = FileUtil.toFileObject((File)this.baseFile);
        if (fo == null && this.remoteFile != null) {
            fo = FileUtil.toFileObject((File)this.remoteFile);
        }
        this.mimeType = this.binary ? "application/octet-stream" : (fo != null ? fo.getMIMEType() : "text/plain");
        this.canWriteBaseFile = fo != null && fo.canWrite();
    }
}

