/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.turbo.TurboProvider;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class DiskMapTurboProvider
implements TurboProvider {
    static final String ATTR_STATUS_MAP = "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP";
    private boolean storeCreated;
    private File cacheStore;
    private int storeSerial;
    private int cachedStoreSerial = -1;
    private Map<File, FileInformation> cachedValues;
    private static final int STATUS_VALUABLE = -12;
    private static final int CACHE_SIZE_WARNING_THRESHOLD = 100000;
    private boolean hugeCacheNotified;

    DiskMapTurboProvider() {
        this.initCacheStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Map<File, FileInformation> getAllModifiedValues() {
        if (this.cachedStoreSerial != this.storeSerial || this.cachedValues == null) {
            this.cachedValues = new HashMap<File, FileInformation>();
            File[] files = this.cacheStore.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    FilterInputStream dis = null;
                    try {
                        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                        block14: while (true) {
                            int pathLen = ((DataInputStream)dis).readInt();
                            ((DataInputStream)dis).readInt();
                            String path = this.readChars((DataInputStream)dis, pathLen);
                            Map<File, FileInformation> value = this.readValue((DataInputStream)dis, path);
                            Iterator<File> j = value.keySet().iterator();
                            while (true) {
                                if (!j.hasNext()) continue block14;
                                File f = j.next();
                                FileInformation info = value.get(f);
                                if ((info.getStatus() & 0xFFFFFFF4) == 0) continue;
                                this.cachedValues.put(f, info);
                            }
                            break;
                        }
                    }
                    catch (EOFException e) {
                        if (dis == null) continue;
                        try {
                            dis.close();
                        }
                        catch (IOException e2) {}
                        continue;
                    }
                    catch (Exception e) {
                        try {
                            ErrorManager.getDefault().notify((Throwable)e);
                            continue;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (dis != null) {
                                try {
                                    dis.close();
                                }
                                catch (IOException e3) {}
                            }
                        }
                    }
                }
            }
            this.cachedStoreSerial = this.storeSerial;
            this.cachedValues = Collections.unmodifiableMap(this.cachedValues);
            if (!this.hugeCacheNotified && this.cachedValues.size() > 100000) {
                CvsVersioningSystem.LOG.log(Level.WARNING, "Cache contains too many entries: {0}", this.cachedValues.size());
                this.hugeCacheNotified = true;
            }
        }
        return this.cachedValues;
    }

    public boolean recognizesAttribute(String name) {
        return ATTR_STATUS_MAP.equals(name);
    }

    public boolean recognizesEntity(Object key) {
        return key instanceof File;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object readEntry(Object key, String name, TurboProvider.MemoryCache memoryCache) {
        block24: {
            if (!DiskMapTurboProvider.$assertionsDisabled && !(key instanceof File)) {
                throw new AssertionError();
            }
            if (!DiskMapTurboProvider.$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            readFailed = false;
            dir = (File)key;
            store = this.getStore(dir);
            if (!store.isFile()) {
                return null;
            }
            dirPath = dir.getAbsolutePath();
            dirPathLen = dirPath.length();
            dis = null;
            try {
                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(store)));
lbl15:
                // 2 sources

                while (true) {
                    pathLen = dis.readInt();
                    mapLen = dis.readInt();
                    if (pathLen != dirPathLen) {
                        this.skip(dis, pathLen * 2 + mapLen);
                        continue;
                    }
                    path = this.readChars((DataInputStream)dis, pathLen);
                    if (dirPath.equals(path)) {
                        var13_17 = this.readValue((DataInputStream)dis, path);
                        if (dis == null) return var13_17;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (EOFException e) {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e) {}
                }
                break block24;
            }
            catch (Exception e) {
                try {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    readFailed = true;
                    break block24;
                }
                catch (Throwable var15_19) {
                    throw var15_19;
                }
                finally {
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            try {
                dis.close();
                return var13_17;
            }
            catch (IOException e) {
                // empty catch block
            }
            return var13_17;
lbl-1000:
            // 1 sources

            {
                this.skip(dis, mapLen);
                ** continue;
            }
        }
        if (readFailed == false) return null;
        store.delete();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeEntry(Object key, String name, Object value) {
        File storeNew;
        File store;
        block31: {
            assert (key instanceof File);
            assert (name != null);
            if (value != null) {
                if (!(value instanceof Map)) {
                    return false;
                }
                if (!this.isValuable(value)) {
                    value = null;
                }
            }
            File dir = (File)key;
            String dirPath = dir.getAbsolutePath();
            int dirPathLen = dirPath.length();
            store = this.getStore(dir);
            if (value == null && !store.exists()) {
                return true;
            }
            this.makeSureCacheStoreExists();
            storeNew = new File(store.getParentFile(), store.getName() + ".new");
            FilterOutputStream oos = null;
            FilterInputStream dis = null;
            try {
                oos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(storeNew)));
                if (value != null) {
                    this.writeEntry((DataOutputStream)oos, dirPath, value);
                }
                if (!store.exists()) break block31;
                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(store)));
                while (true) {
                    int pathLen;
                    try {
                        pathLen = ((DataInputStream)dis).readInt();
                    }
                    catch (EOFException e) {
                        break;
                    }
                    int mapLen = ((DataInputStream)dis).readInt();
                    if (pathLen == dirPathLen) {
                        String path = this.readChars((DataInputStream)dis, pathLen);
                        if (dirPath.equals(path)) {
                            this.skip(dis, mapLen);
                            continue;
                        }
                        ((DataOutputStream)oos).writeInt(pathLen);
                        ((DataOutputStream)oos).writeInt(mapLen);
                        ((DataOutputStream)oos).writeChars(path);
                        DiskMapTurboProvider.copyStreams(oos, dis, mapLen);
                        continue;
                    }
                    ((DataOutputStream)oos).writeInt(pathLen);
                    ((DataOutputStream)oos).writeInt(mapLen);
                    DiskMapTurboProvider.copyStreams(oos, dis, mapLen + pathLen * 2);
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Copy: " + store.getAbsolutePath() + " to: " + storeNew.getAbsolutePath());
                ErrorManager.getDefault().notify((Throwable)e);
                boolean bl = true;
                return bl;
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e) {}
                }
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        ++this.storeSerial;
        store.delete();
        storeNew.renameTo(store);
        return true;
    }

    private void skip(InputStream is, long len) throws IOException {
        while (len > 0L) {
            long n = is.skip(len);
            if (n < 0L) {
                throw new EOFException("Missing " + len + " bytes.");
            }
            len -= n;
        }
    }

    private String readChars(DataInputStream dis, int len) throws IOException {
        StringBuffer sb = new StringBuffer(len);
        while (len-- > 0) {
            sb.append(dis.readChar());
        }
        return sb.toString();
    }

    private Map<File, FileInformation> readValue(DataInputStream dis, String dirPath) throws IOException {
        HashMap<File, FileInformation> map = new HashMap<File, FileInformation>();
        int len = dis.readInt();
        while (len-- > 0) {
            int status;
            int nameLen = dis.readInt();
            String name = this.readChars(dis, nameLen);
            File file = new File(dirPath, name);
            FileInformation info = new FileInformation(status & 0xFFFF, (status = dis.readInt()) > 65535);
            map.put(file, info);
        }
        return map;
    }

    private void writeEntry(DataOutputStream dos, String dirPath, Object value) throws IOException {
        Map map = (Map)value;
        Set set = map.keySet();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(set.size() * 50);
        DataOutputStream temp = new DataOutputStream(baos);
        temp.writeInt(set.size());
        for (File file : set) {
            FileInformation info = (FileInformation)map.get(file);
            temp.writeInt(file.getName().length());
            temp.writeChars(file.getName());
            temp.writeInt(info.getStatus() + (info.isDirectory() ? 65536 : 0));
        }
        temp.close();
        byte[] valueBytes = baos.toByteArray();
        dos.writeInt(dirPath.length());
        dos.writeInt(valueBytes.length);
        dos.writeChars(dirPath);
        dos.write(valueBytes);
    }

    private boolean isValuable(Object value) {
        Map map = (Map)value;
        for (FileInformation info : map.values()) {
            if ((info.getStatus() & 0xFFFFFFF4) == 0) continue;
            return true;
        }
        return false;
    }

    private File getStore(File dir) {
        String dirPath = dir.getAbsolutePath();
        int dirHash = dirPath.hashCode();
        return new File(this.cacheStore, Integer.toString(dirHash % 173 + 172) + ".bin");
    }

    private void initCacheStore() {
        String userDir = System.getProperty("netbeans.user");
        if (userDir != null) {
            this.cacheStore = new File(new File(new File(userDir, "var"), "cache"), "cvscache");
        } else {
            File cachedir = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            this.cacheStore = new File(cachedir, "cvscache");
        }
    }

    private void makeSureCacheStoreExists() {
        if (!this.storeCreated) {
            assert (Thread.holdsLock(this));
            this.storeCreated = true;
            this.cacheStore.mkdirs();
        }
    }

    private static void copyStreams(OutputStream out, InputStream in, int len) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        do {
            n = len <= 4096 ? len : 4096;
            if ((n = in.read(buffer, 0, n)) < 0) {
                throw new EOFException("Missing " + len + " bytes.");
            }
            out.write(buffer, 0, n);
        } while ((len -= n) != 0);
        out.flush();
    }
}

