/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.swing.JOptionPane;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.ui.RefactoringActionsProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

abstract class PackagetoTreePathHandleTask
implements Runnable,
CancellableTask<CompilationController> {
    private static final String JAVA_EXTENSION = "java";
    public CompilationInfo cinfo;
    private final Collection<FileObject> javaFileObjects = new HashSet<FileObject>();
    private final Collection<TreePathHandle> handles = new ArrayList<TreePathHandle>();

    public PackagetoTreePathHandleTask(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            FileObject primaryFileObject = dataObject.getPrimaryFile();
            this.javaFileObjects.addAll(PackagetoTreePathHandleTask.findJavaSourceFiles(primaryFileObject));
        }
    }

    public void cancel() {
    }

    public void run(CompilationController info) throws Exception {
        info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        this.cinfo = info;
        CompilationUnitTree unit = info.getCompilationUnit();
        for (Tree tree : unit.getTypeDecls()) {
            Element element = info.getTrees().getElement(TreePath.getPath(unit, tree));
            if (element == null || !element.getKind().isClass() && !element.getKind().isInterface() || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            TreePathHandle typeHandle = TreePathHandle.create((TreePath)TreePath.getPath(unit, tree), (CompilationInfo)info);
            this.handles.add(typeHandle);
        }
    }

    @Override
    public void run() {
        for (FileObject javaFileObject : this.javaFileObjects) {
            JavaSource source = JavaSource.forFileObject((FileObject)javaFileObject);
            assert (source != null);
            try {
                source.runUserActionTask((Task)this, false);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        TopComponent activetc = TopComponent.getRegistry().getActivated();
        RefactoringUI ui = this.createRefactoringUI(this.handles, this.cinfo);
        if (ui != null) {
            UI.openRefactoringUI((RefactoringUI)ui, (TopComponent)activetc);
        } else {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameKeyword"));
        }
    }

    protected final FileObject[] getFileHandles() {
        return this.javaFileObjects.toArray(new FileObject[0]);
    }

    protected abstract RefactoringUI createRefactoringUI(Collection<TreePathHandle> var1, CompilationInfo var2);

    public static Collection<FileObject> findJavaSourceFiles(FileObject pkg) {
        ArrayList<FileObject> javaSrcFiles = new ArrayList<FileObject>();
        PackagetoTreePathHandleTask.addSourcesInPackage(pkg, javaSrcFiles);
        return javaSrcFiles;
    }

    private static void addSourcesInPackage(FileObject pkgFileObject, Collection<FileObject> javaSrcFiles) {
        for (FileObject childFileObject : pkgFileObject.getChildren()) {
            if (!childFileObject.isData() || !JAVA_EXTENSION.equalsIgnoreCase(childFileObject.getExt())) continue;
            javaSrcFiles.add(childFileObject);
        }
    }
}

