/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.CopyClassPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class CopyClassRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final SingleCopyRefactoring refactoring;
    private CopyClassPanel panel;
    private FileObject resource;
    private FileObject targetFolder;
    private PasteType paste;

    public CopyClassRefactoringUI(FileObject resource, FileObject target, PasteType paste) {
        this.refactoring = new SingleCopyRefactoring(Lookups.singleton((Object)resource));
        this.resource = resource;
        this.targetFolder = target;
        this.paste = paste;
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            FileObject target = this.targetFolder != null ? this.targetFolder : this.resource.getParent();
            this.panel = new CopyClassPanel(parent, this.getName() + " - " + this.resource.getName(), RetoucheUtils.getPackageName(target), target, this.resource.getName());
            this.panel.setCombosEnabled(this.targetFolder == null);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.setupRefactoring();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (this.panel == null) {
            return null;
        }
        this.setupRefactoring();
        return this.refactoring.fastCheckParameters();
    }

    private void setupRefactoring() {
        this.refactoring.setNewName(this.panel.getNewName());
        FileObject rootFolder = this.panel.getRootFolder();
        Lookup target = Lookup.EMPTY;
        if (rootFolder != null) {
            try {
                URL url = URLMapper.findURL((FileObject)rootFolder, (int)1);
                URL targetURL = new URL(url.toExternalForm() + this.panel.getPackageName().replace('.', '/'));
                target = Lookups.singleton((Object)targetURL);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.refactoring.setTarget(target);
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(CopyClassRefactoringUI.class, (String)"DSC_CopyClass", (Object)this.refactoring.getNewName());
    }

    public String getName() {
        return NbBundle.getMessage(CopyClassRefactoringUI.class, (String)"LBL_CopyClass");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CopyClassRefactoringUI.class.getName());
    }

    public boolean isRefactoringBypassRequired() {
        if (this.panel == null) {
            return false;
        }
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    FileObject source = (FileObject)CopyClassRefactoringUI.this.refactoring.getRefactoringSource().lookup(FileObject.class);
                    FileObject target = RetoucheUtils.getOrCreateFolder((URL)CopyClassRefactoringUI.this.refactoring.getTarget().lookup(URL.class));
                    if (source != null) {
                        DataObject sourceDo = DataObject.find((FileObject)source);
                        DataFolder targetFolder = DataFolder.findFolder((FileObject)target);
                        sourceDo.copy(targetFolder).rename(CopyClassRefactoringUI.this.panel.getNewName());
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }
}

