/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.spi;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.ErrorManager;

public class RefactoringVisitor
extends TreePathScanner<Tree, Element> {
    protected WorkingCopy workingCopy;
    protected TreeMaker make;

    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        this.workingCopy = workingCopy;
        try {
            if (this.workingCopy.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                throw new ToPhaseException();
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
        this.make = workingCopy.getTreeMaker();
    }

    protected void rewrite(Tree oldTree, Tree newTree) {
        this.workingCopy.rewrite(oldTree, newTree);
        TreePath current = this.getCurrentPath();
        if (current.getLeaf() == oldTree) {
            JavaRefactoringUtils.cacheTreePathInfo(current, (CompilationInfo)this.workingCopy);
        } else {
            TreePath tp = this.workingCopy.getTrees().getPath(current.getCompilationUnit(), oldTree);
            JavaRefactoringUtils.cacheTreePathInfo(current, (CompilationInfo)this.workingCopy);
        }
    }
}

