/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class RetoucheCommit
implements Transaction {
    private static final Logger LOG = Logger.getLogger(RetoucheCommit.class.getName());
    List<BackupFacility.Handle> ids = new ArrayList<BackupFacility.Handle>();
    private boolean commited = false;
    Collection<ModificationResult> results;
    private Set<File> newFiles;
    private boolean newFilesStored = false;

    public RetoucheCommit(Collection<ModificationResult> results) {
        this.results = results;
    }

    public void commit() {
        try {
            if (this.commited) {
                for (BackupFacility.Handle id : this.ids) {
                    try {
                        id.restore();
                    }
                    catch (IOException ex) {
                        throw (RuntimeException)new RuntimeException().initCause(ex);
                    }
                }
            } else {
                this.commited = true;
                for (ModificationResult result : this.results) {
                    this.ids.add(BackupFacility.getDefault().backup((Collection)result.getModifiedFileObjects()));
                    if (this.newFiles == null) {
                        this.newFiles = new HashSet<File>();
                    }
                    this.newFiles.addAll(result.getNewFiles());
                    result.commit();
                }
                RetoucheCommit.openNewFiles(this.newFiles);
            }
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public void rollback() {
        for (BackupFacility.Handle id : this.ids) {
            try {
                id.restore();
            }
            catch (IOException ex) {
                throw (RuntimeException)new RuntimeException().initCause(ex);
            }
        }
        boolean localStored = false;
        if (this.newFiles != null) {
            for (File f : this.newFiles) {
                try {
                    FileObject fo = FileUtil.toFileObject((File)f);
                    if (!this.newFilesStored) {
                        this.ids.add(BackupFacility.getDefault().backup(new FileObject[]{fo}));
                        localStored = true;
                    }
                    fo.delete();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.newFilesStored |= localStored;
        }
    }

    private static void openNewFiles(Set<File> newFiles) {
        if (newFiles == null) {
            return;
        }
        for (File file : newFiles) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie editor = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                if (editor == null) continue;
                editor.open();
            }
            catch (DataObjectNotFoundException ex) {
                LOG.log(Level.INFO, ex.getMessage(), ex);
            }
        }
    }
}

