/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.java.plugins.InnerToOuterTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class InnerToOuterRefactoringPlugin
extends JavaRefactoringPlugin {
    private final InnerToOuterRefactoring refactoring;
    private TreePathHandle treePathHandle;

    InnerToOuterRefactoringPlugin(InnerToOuterRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            case PRECHECK: {
                ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
                return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
            }
        }
        return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
    }

    @Override
    protected Problem preCheck(CompilationController info) throws IOException {
        this.fireProgressListenerStart(1, 4);
        Problem preCheckProblem = null;
        info.toPhase(JavaSource.Phase.RESOLVED);
        Element el = this.treePathHandle.resolveElement((CompilationInfo)info);
        TreePathHandle sourceType = this.refactoring.getSourceType();
        Problem result = InnerToOuterRefactoringPlugin.isElementAvail(sourceType, (CompilationInfo)info);
        if (result != null) {
            return result;
        }
        result = JavaPluginUtils.isSourceElement(el, (CompilationInfo)info);
        if (result != null) {
            return result;
        }
        this.refactoring.setClassName(RetoucheUtils.getSimpleName(sourceType));
        this.fireProgressListenerStep();
        if (el instanceof TypeElement) {
            if (((TypeElement)el).getNestingKind() == NestingKind.ANONYMOUS) {
                preCheckProblem = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_Anonymous"));
                return preCheckProblem;
            }
            if (!((TypeElement)el).getNestingKind().isNested()) {
                preCheckProblem = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_MustBeInnerClass"));
                return preCheckProblem;
            }
        } else {
            preCheckProblem = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_MustBeInnerClass"));
            return preCheckProblem;
        }
        this.fireProgressListenerStep();
        this.refactoring.setReferenceName("outer");
        this.fireProgressListenerStop();
        return preCheckProblem;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject[] children;
        Problem result = null;
        String newName = this.refactoring.getClassName();
        if (!Utilities.isJavaIdentifier((String)newName)) {
            result = InnerToOuterRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)newName));
            return result;
        }
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        FileObject folder = primFile.getParent();
        for (FileObject child : children = folder.getChildren()) {
            if (child.isVirtual() || !child.getName().equals(newName) || !"java".equals(child.getExt())) continue;
            result = InnerToOuterRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)newName, (Object)folder.getName()));
            return result;
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        HashSet<FileObject> set = new HashSet<FileObject>();
        ClassIndex idx = cpInfo.getClassIndex();
        set.addAll(idx.getResources(RetoucheUtils.getElementHandle(this.refactoring.getSourceType()), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        return set;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(1, a.size());
        InnerToOuterTransformer innerToOuter = new InnerToOuterTransformer(this.refactoring);
        JavaRefactoringPlugin.TransformTask transform = new JavaRefactoringPlugin.TransformTask(this, innerToOuter, this.refactoring.getSourceType());
        Problem problem = this.createAndAddElements(a, transform, refactoringElements, this.refactoring);
        this.fireProgressListenerStop();
        return problem != null ? problem : innerToOuter.getProblem();
    }
}

