/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.javadoc.Doc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavadocUtilities;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.openide.util.Exceptions;

public class ChangeParamsTransformer
extends RefactoringVisitor {
    private static final Set<Modifier> ALL_ACCESS_MODIFIERS = EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC);
    private Set<ElementHandle<ExecutableElement>> allMethods;
    private boolean synthConstructor;
    private Boolean constructorRefactoring;
    ChangeParametersRefactoring refactoring;

    public ChangeParamsTransformer(ChangeParametersRefactoring refactoring, Set<ElementHandle<ExecutableElement>> am) {
        this.refactoring = refactoring;
        this.allMethods = am;
    }

    private void init() {
        if (this.constructorRefactoring == null) {
            Element el;
            ElementHandle<ExecutableElement> handle = this.allMethods.iterator().next();
            this.constructorRefactoring = handle.getKind() == ElementKind.CONSTRUCTOR;
            this.synthConstructor = this.constructorRefactoring != false && (el = handle.resolve((CompilationInfo)this.workingCopy)) != null && this.workingCopy.getElementUtilities().isSynthetic(el);
        }
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        this.init();
        return (Tree)super.visitCompilationUnit(node, p);
    }

    @Override
    public Tree visitNewClass(NewClassTree tree, Element p) {
        if (this.constructorRefactoring.booleanValue() && !this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            Trees trees = this.workingCopy.getTrees();
            Element el = trees.getElement(this.getCurrentPath());
            if ((el = this.resolveAnonymousClassConstructor(el, tree, trees)) != null && this.isMethodMatch(el)) {
                List<ExpressionTree> arguments = this.getNewArguments(tree.getArguments());
                NewClassTree nju = this.make.NewClass(tree.getEnclosingExpression(), tree.getTypeArguments(), tree.getIdentifier(), arguments, tree.getClassBody());
                this.rewrite(tree, nju);
            }
        }
        return (Tree)super.visitNewClass(tree, p);
    }

    private Element resolveAnonymousClassConstructor(Element el, NewClassTree tree, Trees trees) {
        Tree t;
        if (el != null && tree.getClassBody() != null && (t = trees.getTree(el)) != null && t.getKind() == Tree.Kind.METHOD) {
            MethodTree constructorTree = (MethodTree)t;
            Tree superCall = constructorTree.getBody().getStatements().get(0);
            TreePath superCallPath = trees.getPath(this.getCurrentPath().getCompilationUnit(), ((ExpressionStatementTree)superCall).getExpression());
            el = trees.getElement(superCallPath);
        }
        return el;
    }

    private List<ExpressionTree> getNewArguments(List<? extends ExpressionTree> currentArguments) {
        ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
        ChangeParametersRefactoring.ParameterInfo[] pi = this.refactoring.getParameterInfo();
        for (int i = 0; i < pi.length; ++i) {
            ExpressionTree vt;
            int originalIndex = pi[i].getOriginalIndex();
            if (originalIndex < 0) {
                String value = pi[i].getDefaultValue();
                SourcePositions[] pos = new SourcePositions[1];
                vt = this.workingCopy.getTreeUtilities().parseExpression(value, pos);
            } else {
                if (i == pi.length - 1 && pi[i].getType().endsWith("...")) {
                    for (int j = originalIndex; j < currentArguments.size(); ++j) {
                        arguments.add(currentArguments.get(j));
                    }
                    break;
                }
                vt = currentArguments.get(originalIndex);
            }
            arguments.add(vt);
        }
        return arguments;
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree tree, Element p) {
        Element el;
        if ((this.constructorRefactoring.booleanValue() || !this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null && this.isMethodMatch(el)) {
            List<ExpressionTree> arguments = this.getNewArguments(tree.getArguments());
            MethodInvocationTree nju = this.make.MethodInvocation(tree.getTypeArguments(), tree.getMethodSelect(), arguments);
            if (this.constructorRefactoring.booleanValue() && this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                this.rewriteSyntheticConstructor(nju);
            } else {
                this.rewrite(tree, nju);
            }
        }
        return (Tree)super.visitMethodInvocation(tree, p);
    }

    private void rewriteSyntheticConstructor(MethodInvocationTree nju) {
        TreePath constructorPath;
        for (constructorPath = this.getCurrentPath(); constructorPath != null && constructorPath.getLeaf().getKind() != Tree.Kind.METHOD; constructorPath = constructorPath.getParentPath()) {
        }
        if (constructorPath != null) {
            MethodTree constrTree = (MethodTree)constructorPath.getLeaf();
            BlockTree body = constrTree.getBody();
            body = this.make.removeBlockStatement(body, 0);
            body = this.make.insertBlockStatement(body, 0, (StatementTree)this.make.ExpressionStatement((ExpressionTree)nju));
            if (this.workingCopy.getTreeUtilities().isSynthetic(constructorPath)) {
                MethodTree njuConstructor = this.make.Method(this.make.Modifiers(constrTree.getModifiers().getFlags(), constrTree.getModifiers().getAnnotations()), (CharSequence)constrTree.getName(), constrTree.getReturnType(), constrTree.getTypeParameters(), constrTree.getParameters(), constrTree.getThrows(), body, (ExpressionTree)constrTree.getDefaultValue());
                this.rewrite(constrTree, njuConstructor);
            } else {
                this.rewrite(constrTree.getBody(), body);
            }
        }
    }

    @Override
    public Tree visitMethod(MethodTree tree, Element p) {
        if (this.constructorRefactoring.booleanValue() && this.isSyntheticConstructorOfAnnonymousClass(this.workingCopy.getTrees().getElement(this.getCurrentPath()))) {
            return tree;
        }
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitMethod(tree, p);
    }

    private void renameDeclIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (!this.synthConstructor && this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            return;
        }
        MethodTree current = (MethodTree)tree;
        Element el = this.workingCopy.getTrees().getElement(path);
        if (this.isMethodMatch(el)) {
            List<? extends VariableTree> currentParameters = current.getParameters();
            ArrayList<VariableTree> newParameters = new ArrayList<VariableTree>();
            ChangeParametersRefactoring.ParameterInfo[] p = this.refactoring.getParameterInfo();
            for (int i = 0; i < p.length; ++i) {
                int originalIndex = p[i].getOriginalIndex();
                VariableTree vt = originalIndex < 0 ? this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)p[i].getName(), (Tree)this.make.Identifier((CharSequence)p[i].getType()), null) : currentParameters.get(p[i].getOriginalIndex());
                newParameters.add(vt);
            }
            HashSet<Modifier> modifiers = new HashSet<Modifier>(current.getModifiers().getFlags());
            if (!el.getEnclosingElement().getKind().isInterface()) {
                modifiers.removeAll(ALL_ACCESS_MODIFIERS);
                modifiers.addAll(this.refactoring.getModifiers());
            }
            for (VariableTree vt : newParameters) {
                PackageElement packageOf;
                Set declaredTypes = this.workingCopy.getClasspathInfo().getClassIndex().getDeclaredTypes(vt.getType().toString(), ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class));
                HashSet declaredTypesMirr = new HashSet(declaredTypes);
                TypeElement type = null;
                for (ElementHandle typeName : declaredTypes) {
                    TypeElement te = this.workingCopy.getElements().getTypeElement(typeName.getQualifiedName());
                    if (te == null) {
                        Logger.getLogger(ChangeParamsTransformer.class.getName()).log(Level.INFO, "Cannot resolve type element \"" + typeName + "\".");
                        continue;
                    }
                    if (!te.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    declaredTypesMirr.remove(typeName);
                }
                if (declaredTypesMirr.size() == 1) {
                    ElementHandle typeName = (ElementHandle)declaredTypesMirr.iterator().next();
                    TypeElement te = this.workingCopy.getElements().getTypeElement(typeName.getQualifiedName());
                    if (te == null) {
                        Logger.getLogger(ChangeParamsTransformer.class.getName()).log(Level.INFO, "Cannot resolve type element \"" + typeName + "\".");
                        continue;
                    }
                    type = te;
                }
                if (type == null || (packageOf = this.workingCopy.getElements().getPackageOf(type)).getQualifiedName().toString().equals("java.lang")) continue;
                try {
                    SourceUtils.resolveImport((CompilationInfo)this.workingCopy, (TreePath)path, (String)type.getQualifiedName().toString());
                }
                catch (NullPointerException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            MethodTree nju = this.make.Method(this.make.Modifiers(modifiers, current.getModifiers().getAnnotations()), (CharSequence)current.getName(), current.getReturnType(), current.getTypeParameters(), newParameters, current.getThrows(), current.getBody(), (ExpressionTree)current.getDefaultValue());
            this.rewrite(tree, nju);
            ArrayList<? extends VariableTree> l = new ArrayList<VariableTree>(currentParameters);
            l.removeAll(newParameters);
            this.removeFromJavadoc((ExecutableElement)el, l);
            return;
        }
    }

    private void removeFromJavadoc(ExecutableElement method, List<? extends VariableTree> parameters) {
        Doc javadoc = this.workingCopy.getElementUtilities().javaDocFor((Element)method);
        block0: for (Tag t : javadoc.tags("param")) {
            for (VariableTree variableTree : parameters) {
                String text = t.text();
                int a = text.indexOf(32);
                if (a > 0) {
                    text = text.substring(0, a);
                }
                if (!text.equals(variableTree.getName().toString())) continue;
                this.removeFromDoc((ParamTag)t);
                continue block0;
            }
        }
    }

    private void removeFromDoc(ParamTag t) {
        try {
            Position[] tagBounds = JavadocUtilities.findTagBounds((CompilationInfo)this.workingCopy, this.workingCopy.getDocument(), (Tag)t);
            int length = tagBounds[1].getOffset() - tagBounds[0].getOffset();
            this.workingCopy.rewriteInComment(tagBounds[0].getOffset(), length, "");
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private boolean isMethodMatch(Element method) {
        if ((method.getKind() == ElementKind.METHOD || method.getKind() == ElementKind.CONSTRUCTOR) && this.allMethods != null) {
            for (ElementHandle<ExecutableElement> mh : this.allMethods) {
                ExecutableElement baseMethod = (ExecutableElement)mh.resolve((CompilationInfo)this.workingCopy);
                if (baseMethod == null) {
                    Logger.getLogger("org.netbeans.modules.refactoring.java").info("ChangeParamsTransformer cannot resolve " + mh);
                    continue;
                }
                if (!baseMethod.equals(method) && !this.workingCopy.getElements().overrides((ExecutableElement)method, baseMethod, this.workingCopy.getElementUtilities().enclosingTypeElement((Element)baseMethod))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSyntheticConstructorOfAnnonymousClass(Element el) {
        if (el != null && el.getKind() == ElementKind.CONSTRUCTOR && this.workingCopy.getElementUtilities().isSynthetic(el)) {
            Element enclosingElement = el.getEnclosingElement();
            return enclosingElement != null && enclosingElement.getKind().isClass() && ((TypeElement)enclosingElement).getNestingKind() == NestingKind.ANONYMOUS;
        }
        return false;
    }
}

