/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.util.lookup.Lookups;

public final class UseSuperTypeRefactoring
extends AbstractRefactoring {
    private final TreePathHandle javaClassHandle;
    private ElementHandle<TypeElement> superType;
    private ElementHandle<TypeElement>[] candidateSuperTypes;

    public UseSuperTypeRefactoring(TreePathHandle javaClassHandle) {
        super(Lookups.fixed((Object[])new Object[]{javaClassHandle}));
        this.javaClassHandle = javaClassHandle;
        this.deriveSuperTypes(javaClassHandle);
    }

    public TreePathHandle getTypeElement() {
        return this.javaClassHandle;
    }

    public void setTargetSuperType(ElementHandle<TypeElement> superClass) {
        this.superType = superClass;
    }

    public ElementHandle<TypeElement> getTargetSuperType() {
        return this.superType;
    }

    public ElementHandle<TypeElement>[] getCandidateSuperTypes() {
        return this.candidateSuperTypes;
    }

    private void deriveSuperTypes(final TreePathHandle javaClassHandle) {
        JavaSource javaSrc = JavaSource.forFileObject((FileObject)javaClassHandle.getFileObject());
        try {
            javaSrc.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController complController) throws IOException {
                    complController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement javaClassElement = (TypeElement)javaClassHandle.resolveElement((CompilationInfo)complController);
                    UseSuperTypeRefactoring.access$002(UseSuperTypeRefactoring.this, UseSuperTypeRefactoring.this.deduceSuperTypes(javaClassElement, complController));
                }
            }, false);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
    }

    private void reduceParamTypes(Collection candidateSuperTypeList, Collection javaClassList) {
    }

    private ElementHandle[] deduceSuperTypes(TypeElement subTypeElement, CompilationController compCtlr) {
        TypeMirror subtypeMirror = subTypeElement.asType();
        Types types = compCtlr.getTypes();
        TypeMirrorComparator comparator = new TypeMirrorComparator();
        TreeSet<TypeMirror> finalSuperTypeMirrors = new TreeSet<TypeMirror>(comparator);
        TreeSet<TypeMirror> workingTypeMirrors = new TreeSet<TypeMirror>(comparator);
        workingTypeMirrors.add(subtypeMirror);
        this.getAllSuperIFs(subtypeMirror, workingTypeMirrors, finalSuperTypeMirrors, compCtlr);
        ElementHandle[] superTypeHandles = new ElementHandle[finalSuperTypeMirrors.size()];
        int index = 0;
        for (TypeMirror typeMirror : finalSuperTypeMirrors) {
            superTypeHandles[index++] = ElementHandle.create((Element)types.asElement(typeMirror));
        }
        return superTypeHandles;
    }

    private void getAllSuperIFs(TypeMirror subTypeMirror, Collection<TypeMirror> uniqueIFs, Collection<TypeMirror> finalIFCollection, CompilationController compCtlr) {
        Types types = compCtlr.getTypes();
        for (TypeMirror typeMirror : types.directSupertypes(subTypeMirror)) {
            finalIFCollection.add(typeMirror);
            if (uniqueIFs.contains(typeMirror)) continue;
            this.getAllSuperIFs(typeMirror, uniqueIFs, finalIFCollection, compCtlr);
        }
    }

    static /* synthetic */ ElementHandle[] access$002(UseSuperTypeRefactoring x0, ElementHandle[] x1) {
        x0.candidateSuperTypes = x1;
        return x1;
    }

    private static class TypeMirrorComparator
    implements Comparator<TypeMirror> {
        private TypeMirrorComparator() {
        }

        @Override
        public int compare(TypeMirror type1, TypeMirror type2) {
            return ((Object)type1).toString().compareTo(((Object)type2).toString());
        }
    }
}

