/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeCallback15
extends SVNMergeCallback {
    public SVNMergeCallback15(SVNAdminArea adminArea, SVNURL url, boolean force, boolean dryRun, SVNDiffOptions options, Map conflictedPathsGetter, SVNMergeDriver mergeDriver) {
        super(adminArea, url, force, dryRun, options, conflictedPathsGetter, mergeDriver);
    }

    public SVNStatusType propertiesChanged(String path, SVNProperties originalProperties, SVNProperties diff, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        SVNProperties regularProps = new SVNProperties();
        this.categorizeProperties(diff, regularProps, null, null);
        if (regularProps.isEmpty()) {
            return SVNStatusType.UNKNOWN;
        }
        try {
            SVNProperties filteredProps;
            SVNMergeDriver.MergeSource mergeSource;
            File file = this.getFile(path);
            SVNWCAccess wcAccess = this.getWCAccess();
            if (wcAccess.getAdminArea(file) == null) {
                wcAccess.probeTry(file, true, -1);
            }
            if ((mergeSource = this.myMergeDriver.getCurrentMergeSource()).getRevision1() < mergeSource.getRevision2() && (filteredProps = this.myMergeDriver.filterSelfReferentialMergeInfo(regularProps, file)) != null) {
                regularProps = filteredProps;
            }
            SVNStatusType status = SVNPropertiesManager.mergeProperties(this.getWCAccess(), file, originalProperties, regularProps, false, this.myIsDryRun);
            if (!this.myIsDryRun) {
                Iterator propsIter = regularProps.nameSet().iterator();
                while (propsIter.hasNext()) {
                    String propName = (String)propsIter.next();
                    SVNPropertyValue propValue = regularProps.getSVNPropertyValue(propName);
                    if (!"svn:mergeinfo".equals(propName)) continue;
                    SVNPropertyValue mergeInfoProp = originalProperties.getSVNPropertyValue("svn:mergeinfo");
                    if (mergeInfoProp == null && propValue != null) {
                        this.myMergeDriver.addPathWithNewMergeInfo(file);
                        continue;
                    }
                    if (mergeInfoProp == null || propValue != null) continue;
                    this.myMergeDriver.addPathWithDeletedMergeInfo(file);
                }
            }
            return status;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE || e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) {
                return SVNStatusType.MISSING;
            }
            throw e;
        }
    }

    public SVNStatusType directoryAdded(String path, long revision, boolean[] isTreeConflicted) throws SVNException {
        SVNFileType fileType;
        this.setIsConflicted(isTreeConflicted, false);
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            if (this.myIsDryRun && this.myAddedPath != null && SVNPathUtil.isAncestor(this.myAddedPath, path)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.MISSING;
        }
        SVNURL copyFromURL = null;
        long copyFromRevision = -1L;
        if (this.myMergeDriver.myIsSameRepository) {
            copyFromURL = this.myURL.appendPath(path, false);
            copyFromRevision = revision;
        }
        if ((fileType = SVNFileType.getType(mergedFile)) == SVNFileType.NONE) {
            SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
            if (entry != null && !entry.isScheduledForDeletion()) {
                return SVNStatusType.OBSTRUCTED;
            }
            if (this.myIsDryRun) {
                this.myAddedPath = path;
            } else {
                if (!mergedFile.mkdirs() && SVNFileType.getType(mergedFile) != SVNFileType.DIRECTORY) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", mergedFile);
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
                ISVNEventHandler oldEventHandler = dir.getWCAccess().getEventHandler();
                dir.getWCAccess().setEventHandler(null);
                SVNWCManager.add(mergedFile, dir, copyFromURL, copyFromRevision, null);
                dir.getWCAccess().setEventHandler(oldEventHandler);
            }
            return SVNStatusType.CHANGED;
        }
        if (fileType == SVNFileType.DIRECTORY) {
            SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
            if (entry == null || entry.isScheduledForDeletion()) {
                if (!this.myIsDryRun) {
                    ISVNEventHandler oldEventHandler = dir.getWCAccess().getEventHandler();
                    dir.getWCAccess().setEventHandler(null);
                    SVNWCManager.add(mergedFile, dir, copyFromURL, copyFromRevision, null);
                    dir.getWCAccess().setEventHandler(oldEventHandler);
                }
                if (this.myIsDryRun) {
                    this.myAddedPath = path;
                }
                return SVNStatusType.CHANGED;
            }
            if (this.myIsDryRun && this.isPathDeleted(path)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.OBSTRUCTED;
        }
        if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
            SVNEntry entry;
            if (this.myIsDryRun) {
                this.myAddedPath = null;
            }
            if ((entry = this.getWCAccess().getEntry(mergedFile, false)) != null && this.myIsDryRun && this.isPathDeleted(path)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.OBSTRUCTED;
        }
        if (this.myIsDryRun) {
            this.myAddedPath = null;
        }
        return SVNStatusType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType directoryDeleted(String path, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            return SVNStatusType.MISSING;
        }
        SVNEntry entry = this.getWCAccess().getEntry(mergedFile, true);
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        if (fileType == SVNFileType.DIRECTORY) {
            if (entry != null && !entry.isScheduledForDeletion()) {
                final ISVNEventHandler oldEventHandler = this.getWCAccess().getEventHandler();
                ISVNEventHandler handler = new ISVNEventHandler(){

                    public void checkCancelled() throws SVNCancelException {
                        oldEventHandler.checkCancelled();
                    }

                    public void handleEvent(SVNEvent event, double progress) throws SVNException {
                    }
                };
                this.getWCAccess().setEventHandler(handler);
                try {
                    this.delete(mergedFile, this.myIsForce, this.myIsDryRun);
                }
                catch (SVNException e) {
                    SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                    return sVNStatusType;
                }
                finally {
                    this.getWCAccess().setEventHandler(oldEventHandler);
                }
                return SVNStatusType.CHANGED;
            }
        } else {
            if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
                return SVNStatusType.OBSTRUCTED;
            }
            if (fileType == SVNFileType.NONE) {
                return SVNStatusType.MISSING;
            }
        }
        return SVNStatusType.UNKNOWN;
    }

    public void directoryOpened(String path, long revision, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
    }

    public SVNStatusType[] fileChanged(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, SVNProperties originalProperties, SVNProperties diff, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        boolean needsMerge = true;
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), this.myIsDryRun);
        if (dir == null) {
            return new SVNStatusType[]{SVNStatusType.MISSING, SVNStatusType.MISSING};
        }
        SVNStatusType[] result = new SVNStatusType[]{SVNStatusType.UNCHANGED, SVNStatusType.UNCHANGED};
        SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
        SVNFileType fileType = null;
        if (entry != null) {
            fileType = SVNFileType.getType(mergedFile);
        }
        if (entry == null || fileType != SVNFileType.FILE && fileType != SVNFileType.SYMLINK) {
            return new SVNStatusType[]{SVNStatusType.MISSING, SVNStatusType.MISSING};
        }
        if (diff != null && !diff.isEmpty()) {
            result[1] = this.propertiesChanged(path, originalProperties, diff, null);
        }
        String name = mergedFile.getName();
        if (file1 != null) {
            boolean same;
            boolean textModified = dir.hasTextModifications(name, false);
            if (!textModified && (SVNProperty.isBinaryMimeType(mimeType1) || SVNProperty.isBinaryMimeType(mimeType2)) && (same = SVNFileUtil.compareFiles(!this.myIsAddNecessitatedMerge ? file1 : file2, mergedFile, null))) {
                if (!this.myIsDryRun && !this.myIsAddNecessitatedMerge) {
                    SVNFileUtil.rename(file2, mergedFile);
                    boolean executable = false;
                    executable = diff != null && diff.containsName("svn:executable") ? diff.getStringValue("svn:executable") != null : originalProperties != null && originalProperties.getStringValue("svn:executable") != null;
                    SVNFileUtil.setExecutable(mergedFile, executable);
                }
                result[0] = SVNStatusType.CHANGED;
                needsMerge = false;
            }
            if (needsMerge) {
                String localLabel = ".working";
                String baseLabel = ".merge-left.r" + revision1;
                String latestLabel = ".merge-right.r" + revision2;
                SVNStatusType mergeResult = dir.mergeText(name, file1, file2, null, localLabel, baseLabel, latestLabel, diff, this.myIsDryRun, this.myDiffOptions, null);
                dir.runLogs();
                if (mergeResult == SVNStatusType.CONFLICTED || mergeResult == SVNStatusType.CONFLICTED_UNRESOLVED) {
                    result[0] = mergeResult;
                } else if (textModified && mergeResult != SVNStatusType.UNCHANGED) {
                    result[0] = SVNStatusType.MERGED;
                } else if (mergeResult == SVNStatusType.MERGED) {
                    result[0] = SVNStatusType.CHANGED;
                } else if (mergeResult != SVNStatusType.MISSING) {
                    result[0] = SVNStatusType.UNCHANGED;
                }
                if (mergeResult == SVNStatusType.CONFLICTED) {
                    if (this.myConflictedPaths == null) {
                        this.myConflictedPaths = new SVNHashMap();
                    }
                    this.myConflictedPaths.put(path, path);
                }
            }
        }
        return result;
    }

    public SVNStatusType[] fileAdded(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, SVNProperties originalProperties, SVNProperties diff, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        SVNStatusType[] result = new SVNStatusType[]{null, SVNStatusType.UNKNOWN};
        SVNProperties newProps = new SVNProperties(originalProperties);
        Iterator propChangesIter = diff.nameSet().iterator();
        while (propChangesIter.hasNext()) {
            String propName = (String)propChangesIter.next();
            if (SVNProperty.isWorkingCopyProperty(propName) || !this.myMergeDriver.isSameRepository() && !SVNProperty.isRegularProperty(propName) || !this.myMergeDriver.isSameRepository() && "svn:mergeinfo".equals(propName)) continue;
            SVNPropertyValue propValue = diff.getSVNPropertyValue(propName);
            newProps.put(propName, propValue);
        }
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            if (this.myIsDryRun && this.myAddedPath != null && SVNPathUtil.isAncestor(this.myAddedPath, path)) {
                result[0] = SVNStatusType.CHANGED;
                if (!newProps.isEmpty()) {
                    result[1] = SVNStatusType.CHANGED;
                }
            } else {
                result[0] = SVNStatusType.MISSING;
            }
            return result;
        }
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        if (fileType == SVNFileType.NONE) {
            SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
            if (entry != null && !entry.isScheduledForDeletion()) {
                result[0] = SVNStatusType.OBSTRUCTED;
                return result;
            }
            if (!this.myIsDryRun) {
                String copyFromURL = null;
                long copyFromRevision = -1L;
                if (this.myMergeDriver.myIsSameRepository) {
                    String targePath = this.myMergeDriver.myTarget.getAbsolutePath();
                    String minePath = mergedFile.getAbsolutePath();
                    String relativePath = SVNPathUtil.getRelativePath(targePath, minePath);
                    copyFromURL = this.myURL.appendPath(relativePath, false).toString();
                    copyFromRevision = revision2;
                }
                SVNWCManager.addRepositoryFile(dir, mergedFile.getName(), null, file2, newProps, null, copyFromURL, copyFromRevision);
            }
            result[0] = SVNStatusType.CHANGED;
            if (!newProps.isEmpty()) {
                result[1] = SVNStatusType.CHANGED;
            }
        } else if (fileType == SVNFileType.DIRECTORY) {
            result[0] = this.myIsDryRun && this.isPathDeleted(path) ? SVNStatusType.CHANGED : SVNStatusType.OBSTRUCTED;
        } else if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
            SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
            if (entry == null || entry.isScheduledForDeletion()) {
                result[0] = SVNStatusType.OBSTRUCTED;
            } else if (this.myIsDryRun && this.isPathDeleted(path)) {
                result[0] = SVNStatusType.CHANGED;
            } else {
                this.myIsAddNecessitatedMerge = true;
                result = this.fileChanged(path, file1, file2, revision1, revision2, mimeType1, mimeType2, originalProperties, diff, null);
                this.myIsAddNecessitatedMerge = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType fileDeleted(String path, File file1, File file2, String mimeType1, String mimeType2, SVNProperties originalProperties, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            return SVNStatusType.MISSING;
        }
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
            if (this.areFilesTheSame(file1, originalProperties, mergedFile, dir) || this.myMergeDriver.myIsForce || this.myMergeDriver.myIsRecordOnly) {
                ISVNEventHandler oldEventHandler = this.getWCAccess().getEventHandler();
                this.getWCAccess().setEventHandler(null);
                try {
                    this.delete(mergedFile, this.myIsForce, this.myIsDryRun);
                }
                catch (SVNException e) {
                    SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                    return sVNStatusType;
                }
                finally {
                    this.getWCAccess().setEventHandler(oldEventHandler);
                }
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.OBSTRUCTED;
        }
        if (fileType == SVNFileType.DIRECTORY) {
            return SVNStatusType.OBSTRUCTED;
        }
        if (fileType == SVNFileType.NONE) {
            return SVNStatusType.MISSING;
        }
        return SVNStatusType.UNKNOWN;
    }

    public SVNStatusType[] directoryClosed(String path, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        return new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};
    }

    protected void delete(File path, boolean force, boolean dryRun) throws SVNException {
        if (!force) {
            SVNWCManager.canDelete(path, this.getWCAccess().getOptions(), this.getWCAccess());
        }
        SVNAdminArea root = this.getWCAccess().retrieve(path.getParentFile());
        if (!dryRun) {
            SVNWCManager.delete(this.getWCAccess(), root, path, true, false);
        }
    }
}

